/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.rest.DecisionRequirementsDefinitionRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.repository.DecisionRequirementsDefinitionDto;
import org.camunda.bpm.engine.rest.dto.repository.DecisionRequirementsDefinitionQueryDto;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.repository.DecisionRequirementsDefinitionResource;
import org.camunda.bpm.engine.rest.sub.repository.impl.DecisionRequirementsDefinitionResourceImpl;
import org.camunda.bpm.engine.rest.util.QueryUtil;

public class DecisionRequirementsDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements DecisionRequirementsDefinitionRestService {
    public DecisionRequirementsDefinitionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public List<DecisionRequirementsDefinitionDto> getDecisionRequirementsDefinitions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        DecisionRequirementsDefinitionQueryDto queryDto = new DecisionRequirementsDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ArrayList<DecisionRequirementsDefinitionDto> dtos = new ArrayList<DecisionRequirementsDefinitionDto>();
        ProcessEngine engine = this.getProcessEngine();
        DecisionRequirementsDefinitionQuery query = (DecisionRequirementsDefinitionQuery)queryDto.toQuery(engine);
        List<DecisionRequirementsDefinition> matchingDefinitions = QueryUtil.list(query, firstResult, maxResults);
        for (DecisionRequirementsDefinition definition : matchingDefinitions) {
            DecisionRequirementsDefinitionDto dto = DecisionRequirementsDefinitionDto.fromDecisionRequirementsDefinition(definition);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public CountResultDto getDecisionRequirementsDefinitionsCount(UriInfo uriInfo) {
        DecisionRequirementsDefinitionQueryDto queryDto = new DecisionRequirementsDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        DecisionRequirementsDefinitionQuery query = (DecisionRequirementsDefinitionQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public DecisionRequirementsDefinitionResource getDecisionRequirementsDefinitionById(String decisionRequirementsDefinitionId) {
        return new DecisionRequirementsDefinitionResourceImpl(this.getProcessEngine(), decisionRequirementsDefinitionId);
    }

    @Override
    public DecisionRequirementsDefinitionResource getDecisionRequirementsDefinitionByKey(String decisionRequirementsDefinitionKey) {
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.getProcessEngine().getRepositoryService().createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(decisionRequirementsDefinitionKey).withoutTenantId().latestVersion().singleResult();
        if (decisionRequirementsDefinition == null) {
            String errorMessage = String.format("No matching decision requirements definition with key: %s and no tenant-id", decisionRequirementsDefinitionKey);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getDecisionRequirementsDefinitionById(decisionRequirementsDefinition.getId());
    }

    @Override
    public DecisionRequirementsDefinitionResource getDecisionRequirementsDefinitionByKeyAndTenantId(String decisionRequirementsDefinitionKey, String tenantId) {
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.getProcessEngine().getRepositoryService().createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey(decisionRequirementsDefinitionKey).tenantIdIn(new String[]{tenantId}).latestVersion().singleResult();
        if (decisionRequirementsDefinition == null) {
            String errorMessage = String.format("No matching decision requirements definition with key: %s and tenant-id: %s", decisionRequirementsDefinitionKey, tenantId);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getDecisionRequirementsDefinitionById(decisionRequirementsDefinition.getId());
    }
}

