/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.authorization.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.rest.dto.ResourceOptionsDto;
import org.camunda.bpm.engine.rest.dto.authorization.AuthorizationDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractAuthorizedRestResource;
import org.camunda.bpm.engine.rest.sub.authorization.AuthorizationResource;

public class AuthorizationResourceImpl
extends AbstractAuthorizedRestResource
implements AuthorizationResource {
    protected final AuthorizationService authorizationService;
    protected String relativeRootResourcePath;

    public AuthorizationResourceImpl(String processEngineName, String resourceId, String relativeRootResourcePath, ObjectMapper objectMapper) {
        super(processEngineName, (Resource)Resources.AUTHORIZATION, resourceId, objectMapper);
        this.relativeRootResourcePath = relativeRootResourcePath;
        this.authorizationService = this.getProcessEngine().getAuthorizationService();
    }

    @Override
    public AuthorizationDto getAuthorization(UriInfo context) {
        Authorization dbAuthorization = this.getDbAuthorization();
        return AuthorizationDto.fromAuthorization(dbAuthorization, this.getProcessEngine().getProcessEngineConfiguration());
    }

    @Override
    public void deleteAuthorization() {
        Authorization dbAuthorization = this.getDbAuthorization();
        this.authorizationService.deleteAuthorization(dbAuthorization.getId());
    }

    @Override
    public void updateAuthorization(AuthorizationDto dto) {
        Authorization dbAuthorization = this.getDbAuthorization();
        AuthorizationDto.update(dto, dbAuthorization, this.getProcessEngine().getProcessEngineConfiguration());
        this.authorizationService.saveAuthorization(dbAuthorization);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        ResourceOptionsDto dto = new ResourceOptionsDto();
        URI uri = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/authorization").path(this.resourceId).build(new Object[0]);
        dto.addReflexiveLink(uri, "GET", "self");
        if (this.isAuthorized((Permission)Permissions.DELETE)) {
            dto.addReflexiveLink(uri, "DELETE", "delete");
        }
        if (this.isAuthorized((Permission)Permissions.UPDATE)) {
            dto.addReflexiveLink(uri, "PUT", "update");
        }
        return dto;
    }

    protected Authorization getDbAuthorization() {
        Authorization dbAuthorization = (Authorization)this.authorizationService.createAuthorizationQuery().authorizationId(this.resourceId).singleResult();
        if (dbAuthorization == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Authorization with id " + this.resourceId + " does not exist.");
        }
        return dbAuthorization;
    }
}

