/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.runtime.impl;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.management.SetJobRetriesBuilder;
import org.camunda.bpm.engine.rest.dto.runtime.JobDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobDuedateDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobSuspensionStateDto;
import org.camunda.bpm.engine.rest.dto.runtime.PriorityDto;
import org.camunda.bpm.engine.rest.dto.runtime.RetriesDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.sub.runtime.JobResource;
import org.camunda.bpm.engine.runtime.Job;

public class JobResourceImpl
implements JobResource {
    private ProcessEngine engine;
    private String jobId;

    public JobResourceImpl(ProcessEngine engine, String jobId) {
        this.engine = engine;
        this.jobId = jobId;
    }

    @Override
    public JobDto getJob() {
        ManagementService managementService = this.engine.getManagementService();
        Job job = (Job)managementService.createJobQuery().jobId(this.jobId).singleResult();
        if (job == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Job with id " + this.jobId + " does not exist");
        }
        return JobDto.fromJob(job);
    }

    @Override
    public String getStacktrace() {
        try {
            ManagementService managementService = this.engine.getManagementService();
            String stacktrace = managementService.getJobExceptionStacktrace(this.jobId);
            return stacktrace;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }

    @Override
    public void setJobRetries(RetriesDto dto) {
        try {
            ManagementService managementService = this.engine.getManagementService();
            SetJobRetriesBuilder builder = managementService.setJobRetries(dto.getRetries().intValue()).jobId(this.jobId);
            if (dto.isDueDateSet()) {
                builder.dueDate(dto.getDueDate());
            }
            builder.execute();
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public void executeJob() {
        try {
            ManagementService managementService = this.engine.getManagementService();
            managementService.executeJob(this.jobId);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (RuntimeException r) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, r.getMessage());
        }
    }

    @Override
    public void setJobDuedate(JobDuedateDto dto) {
        try {
            ManagementService managementService = this.engine.getManagementService();
            managementService.setJobDuedate(this.jobId, dto.getDuedate(), dto.isCascade());
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public void recalculateDuedate(boolean creationDateBased) {
        try {
            ManagementService managementService = this.engine.getManagementService();
            managementService.recalculateJobDuedate(this.jobId, creationDateBased);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), e.getMessage());
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public void updateSuspensionState(JobSuspensionStateDto dto) {
        dto.setJobId(this.jobId);
        dto.updateSuspensionState(this.engine);
    }

    @Override
    public void setJobPriority(PriorityDto dto) {
        if (dto.getPriority() == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "Priority for job '" + this.jobId + "' cannot be null.");
        }
        try {
            ManagementService managementService = this.engine.getManagementService();
            managementService.setJobPriority(this.jobId, dto.getPriority().longValue());
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public void deleteJob() {
        try {
            this.engine.getManagementService().deleteJob(this.jobId);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (NullValueException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }
}

