/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.calendar;

import java.util.Date;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.calendar.BusinessCalendar;
import org.camunda.bpm.engine.impl.calendar.CronExpression;
import org.camunda.bpm.engine.impl.calendar.DurationHelper;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.EngineUtilLogger;

public class CycleBusinessCalendar
implements BusinessCalendar {
    private static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;
    public static String NAME = "cycle";

    @Override
    public Date resolveDuedate(String duedateDescription) {
        return this.resolveDuedate(duedateDescription, null);
    }

    @Override
    public Date resolveDuedate(String duedateDescription, Date startDate) {
        try {
            if (duedateDescription.startsWith("R")) {
                return new DurationHelper(duedateDescription, startDate).getDateAfter(startDate);
            }
            CronExpression ce = new CronExpression(duedateDescription);
            return ce.getTimeAfter(startDate == null ? ClockUtil.getCurrentTime() : startDate);
        }
        catch (Exception e) {
            throw LOG.exceptionWhileParsingCronExpresison(duedateDescription, e);
        }
    }
}

