/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.impl.cmd.AbstractInstanceCancellationCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.cmd.ActivityInstanceCancellationCmd;
import org.camunda.bpm.engine.impl.cmd.GetActivityInstanceCmd;
import org.camunda.bpm.engine.impl.cmd.TransitionInstanceCancellationCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessElementInstance;
import org.camunda.bpm.engine.runtime.TransitionInstance;

public class ActivityCancellationCmd
extends AbstractProcessInstanceModificationCommand {
    protected String activityId;
    protected boolean cancelCurrentActiveActivityInstances;
    protected ActivityInstance activityInstanceTree;

    public ActivityCancellationCmd(String activityId) {
        this(null, activityId);
    }

    public ActivityCancellationCmd(String processInstanceId, String activityId) {
        super(processInstanceId);
        this.activityId = activityId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ActivityInstance activityInstanceTree = this.getActivityInstanceTree(commandContext);
        List<AbstractInstanceCancellationCmd> commands = this.createActivityInstanceCancellations(activityInstanceTree, commandContext);
        for (AbstractInstanceCancellationCmd cmd : commands) {
            cmd.setSkipCustomListeners(this.skipCustomListeners);
            cmd.setSkipIoMappings(this.skipIoMappings);
            cmd.execute(commandContext);
        }
        return null;
    }

    protected Set<String> collectParentScopeIdsForActivity(ProcessDefinitionImpl processDefinition, String activityId) {
        HashSet<String> parentScopeIds = new HashSet<String>();
        for (ScopeImpl scope = processDefinition.findActivity(activityId); scope != null; scope = scope.getFlowScope()) {
            parentScopeIds.add(scope.getId());
        }
        return parentScopeIds;
    }

    protected List<TransitionInstance> getTransitionInstancesForActivity(ActivityInstance tree, Set<String> parentScopeIds) {
        if (!parentScopeIds.contains(tree.getActivityId())) {
            return Collections.emptyList();
        }
        ArrayList<TransitionInstance> instances = new ArrayList<TransitionInstance>();
        TransitionInstance[] transitionInstances = tree.getChildTransitionInstances();
        for (TransitionInstance transitionInstance : transitionInstances) {
            if (!this.activityId.equals(transitionInstance.getActivityId())) continue;
            instances.add(transitionInstance);
        }
        for (ProcessElementInstance processElementInstance : tree.getChildActivityInstances()) {
            instances.addAll(this.getTransitionInstancesForActivity((ActivityInstance)processElementInstance, parentScopeIds));
        }
        return instances;
    }

    protected List<ActivityInstance> getActivityInstancesForActivity(ActivityInstance tree, Set<String> parentScopeIds) {
        if (!parentScopeIds.contains(tree.getActivityId())) {
            return Collections.emptyList();
        }
        ArrayList<ActivityInstance> instances = new ArrayList<ActivityInstance>();
        if (this.activityId.equals(tree.getActivityId())) {
            instances.add(tree);
        }
        for (ActivityInstance child : tree.getChildActivityInstances()) {
            instances.addAll(this.getActivityInstancesForActivity(child, parentScopeIds));
        }
        return instances;
    }

    public ActivityInstance getActivityInstanceTree(final CommandContext commandContext) {
        return commandContext.runWithoutAuthorization(new Callable<ActivityInstance>(){

            @Override
            public ActivityInstance call() throws Exception {
                return new GetActivityInstanceCmd(ActivityCancellationCmd.this.processInstanceId).execute(commandContext);
            }
        });
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityInstanceTreeToCancel(ActivityInstance activityInstanceTreeToCancel) {
        this.activityInstanceTree = activityInstanceTreeToCancel;
    }

    @Override
    protected String describe() {
        return "Cancel all instances of activity '" + this.activityId + "'";
    }

    public List<AbstractInstanceCancellationCmd> createActivityInstanceCancellations(ActivityInstance activityInstanceTree, CommandContext commandContext) {
        ArrayList<AbstractInstanceCancellationCmd> commands = new ArrayList<AbstractInstanceCancellationCmd>();
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        ProcessDefinitionEntity processDefinition = processInstance.getProcessDefinition();
        Set<String> parentScopeIds = this.collectParentScopeIdsForActivity(processDefinition, this.activityId);
        List<ActivityInstance> childrenForActivity = this.getActivityInstancesForActivity(activityInstanceTree, parentScopeIds);
        for (ActivityInstance instance : childrenForActivity) {
            commands.add(new ActivityInstanceCancellationCmd(this.processInstanceId, instance.getId()));
        }
        List<TransitionInstance> transitionInstancesForActivity = this.getTransitionInstancesForActivity(activityInstanceTree, parentScopeIds);
        for (TransitionInstance instance : transitionInstancesForActivity) {
            commands.add(new TransitionInstanceCancellationCmd(this.processInstanceId, instance.getId()));
        }
        return commands;
    }

    public boolean isCancelCurrentActiveActivityInstances() {
        return this.cancelCurrentActiveActivityInstances;
    }

    public void setCancelCurrentActiveActivityInstances(boolean cancelCurrentActiveActivityInstances) {
        this.cancelCurrentActiveActivityInstances = cancelCurrentActiveActivityInstances;
    }
}

