/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.type;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.form.type.SimpleFormFieldType;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.LongValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class LongFormType
extends SimpleFormFieldType {
    public static final String TYPE_NAME = "long";

    @Override
    public String getName() {
        return TYPE_NAME;
    }

    @Override
    public TypedValue convertValue(TypedValue propertyValue) {
        if (propertyValue instanceof LongValue) {
            return propertyValue;
        }
        Object value = propertyValue.getValue();
        if (value == null) {
            return Variables.longValue(null, (boolean)propertyValue.isTransient());
        }
        if (value instanceof Number || value instanceof String) {
            return Variables.longValue((Long)new Long(value.toString()), (boolean)propertyValue.isTransient());
        }
        throw new ProcessEngineException("Value '" + value + "' is not of type Long.");
    }

    @Override
    public Object convertFormValueToModelValue(Object propertyValue) {
        if (propertyValue == null || "".equals(propertyValue)) {
            return null;
        }
        return new Long(propertyValue.toString());
    }

    @Override
    public String convertModelValueToFormValue(Object modelValue) {
        if (modelValue == null) {
            return null;
        }
        return modelValue.toString();
    }
}

