/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.CleanableHistoricProcessInstanceReportImpl;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class HistoricProcessInstanceManager
extends AbstractHistoricManager {
    public HistoricProcessInstanceEntity findHistoricProcessInstance(String processInstanceId) {
        if (this.isHistoryEnabled()) {
            return this.getDbEntityManager().selectById(HistoricProcessInstanceEntity.class, processInstanceId);
        }
        return null;
    }

    public HistoricProcessInstanceEventEntity findHistoricProcessInstanceEvent(String eventId) {
        if (this.isHistoryEnabled()) {
            return this.getDbEntityManager().selectById(HistoricProcessInstanceEventEntity.class, eventId);
        }
        return null;
    }

    public void deleteHistoricProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        List historicProcessInstanceIds;
        if (this.isHistoryEnabled() && !(historicProcessInstanceIds = this.getDbEntityManager().selectList("selectHistoricProcessInstanceIdsByProcessDefinitionId", processDefinitionId)).isEmpty()) {
            this.deleteHistoricProcessInstanceByIds(historicProcessInstanceIds);
        }
    }

    public void deleteHistoricProcessInstanceByIds(List<String> processInstanceIds) {
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getHistoricDetailManager().deleteHistoricDetailsByProcessInstanceIds(processInstanceIds);
        commandContext.getHistoricVariableInstanceManager().deleteHistoricVariableInstanceByProcessInstanceIds(processInstanceIds);
        commandContext.getCommentManager().deleteCommentsByProcessInstanceIds(processInstanceIds);
        commandContext.getAttachmentManager().deleteAttachmentsByProcessInstanceIds(processInstanceIds);
        commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstancesByProcessInstanceIds(processInstanceIds, false);
        commandContext.getHistoricActivityInstanceManager().deleteHistoricActivityInstancesByProcessInstanceIds(processInstanceIds);
        commandContext.getHistoricIncidentManager().deleteHistoricIncidentsByProcessInstanceIds(processInstanceIds);
        commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByProcessInstanceIds(processInstanceIds);
        commandContext.getHistoricExternalTaskLogManager().deleteHistoricExternalTaskLogsByProcessInstanceIds(processInstanceIds);
        commandContext.getDbEntityManager().deletePreserveOrder(HistoricProcessInstanceEntity.class, "deleteHistoricProcessInstances", processInstanceIds);
    }

    public long findHistoricProcessInstanceCountByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(historicProcessInstanceQuery);
            return (Long)this.getDbEntityManager().selectOne("selectHistoricProcessInstanceCountByQueryCriteria", historicProcessInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricProcessInstance> findHistoricProcessInstancesByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery, Page page) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(historicProcessInstanceQuery);
            return this.getDbEntityManager().selectList("selectHistoricProcessInstancesByQueryCriteria", historicProcessInstanceQuery, page);
        }
        return Collections.EMPTY_LIST;
    }

    public List<HistoricProcessInstance> findHistoricProcessInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectHistoricProcessInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricProcessInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricProcessInstanceCountByNativeQuery", parameterMap);
    }

    protected void configureQuery(HistoricProcessInstanceQueryImpl query) {
        this.getAuthorizationManager().configureHistoricProcessInstanceQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    public List<String> findHistoricProcessInstanceIdsForCleanup(Integer batchSize, int minuteFrom, int minuteTo) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("currentTimestamp", ClockUtil.getCurrentTime());
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        ListQueryParameterObject parameterObject = new ListQueryParameterObject(parameters, 0, batchSize);
        return this.getDbEntityManager().selectList("selectHistoricProcessInstanceIdsForCleanup", parameterObject);
    }

    public List<String> findHistoricProcessInstanceIds(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        this.configureQuery(historicProcessInstanceQuery);
        return this.getDbEntityManager().selectList("selectHistoricProcessInstanceIdsByQueryCriteria", historicProcessInstanceQuery);
    }

    public List<CleanableHistoricProcessInstanceReportResult> findCleanableHistoricProcessInstancesReportByCriteria(CleanableHistoricProcessInstanceReportImpl query, Page page) {
        query.setCurrentTimestamp(ClockUtil.getCurrentTime());
        this.getAuthorizationManager().configureQueryHistoricFinishedInstanceReport(query, Resources.PROCESS_DEFINITION);
        this.getTenantManager().configureQuery(query);
        return this.getDbEntityManager().selectList("selectFinishedProcessInstancesReportEntities", query, page);
    }

    public long findCleanableHistoricProcessInstancesReportCountByCriteria(CleanableHistoricProcessInstanceReportImpl query) {
        query.setCurrentTimestamp(ClockUtil.getCurrentTime());
        this.getAuthorizationManager().configureQueryHistoricFinishedInstanceReport(query, Resources.PROCESS_DEFINITION);
        this.getTenantManager().configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectFinishedProcessInstancesReportEntitiesCount", query);
    }

    public void addRemovalTimeToProcessInstancesByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime) {
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getHistoricActivityInstanceManager().addRemovalTimeToActivityInstancesByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        commandContext.getHistoricTaskInstanceManager().addRemovalTimeToTaskInstancesByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        commandContext.getHistoricVariableInstanceManager().addRemovalTimeToVariableInstancesByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        commandContext.getHistoricDetailManager().addRemovalTimeToDetailsByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        commandContext.getHistoricIncidentManager().addRemovalTimeToIncidentsByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        commandContext.getHistoricExternalTaskLogManager().addRemovalTimeToExternalTaskLogByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        commandContext.getHistoricJobLogManager().addRemovalTimeToJobLogByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        commandContext.getOperationLogManager().addRemovalTimeToUserOperationLogByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        commandContext.getHistoricIdentityLinkManager().addRemovalTimeToIdentityLinkLogByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        commandContext.getCommentManager().addRemovalTimeToCommentsByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        commandContext.getAttachmentManager().addRemovalTimeToAttachmentsByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        commandContext.getByteArrayManager().addRemovalTimeToByteArraysByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(HistoricProcessInstanceEventEntity.class, "updateHistoricProcessInstanceEventsByRootProcessInstanceId", parameters);
    }

    public void addRemovalTimeById(String processInstanceId, Date removalTime) {
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getHistoricActivityInstanceManager().addRemovalTimeToActivityInstancesByProcessInstanceId(processInstanceId, removalTime);
        commandContext.getHistoricTaskInstanceManager().addRemovalTimeToTaskInstancesByProcessInstanceId(processInstanceId, removalTime);
        commandContext.getHistoricVariableInstanceManager().addRemovalTimeToVariableInstancesByProcessInstanceId(processInstanceId, removalTime);
        commandContext.getHistoricDetailManager().addRemovalTimeToDetailsByProcessInstanceId(processInstanceId, removalTime);
        commandContext.getHistoricIncidentManager().addRemovalTimeToIncidentsByProcessInstanceId(processInstanceId, removalTime);
        commandContext.getHistoricExternalTaskLogManager().addRemovalTimeToExternalTaskLogByProcessInstanceId(processInstanceId, removalTime);
        commandContext.getHistoricJobLogManager().addRemovalTimeToJobLogByProcessInstanceId(processInstanceId, removalTime);
        commandContext.getOperationLogManager().addRemovalTimeToUserOperationLogByProcessInstanceId(processInstanceId, removalTime);
        commandContext.getHistoricIdentityLinkManager().addRemovalTimeToIdentityLinkLogByProcessInstanceId(processInstanceId, removalTime);
        commandContext.getCommentManager().addRemovalTimeToCommentsByProcessInstanceId(processInstanceId, removalTime);
        commandContext.getAttachmentManager().addRemovalTimeToAttachmentsByProcessInstanceId(processInstanceId, removalTime);
        commandContext.getByteArrayManager().addRemovalTimeToByteArraysByProcessInstanceId(processInstanceId, removalTime);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(HistoricProcessInstanceEventEntity.class, "updateHistoricProcessInstanceByProcessInstanceId", parameters);
    }

    public Map<Class<? extends DbEntity>, DbOperation> deleteHistoricProcessInstancesByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        CommandContext commandContext = Context.getCommandContext();
        HashMap<Class<? extends DbEntity>, DbOperation> deleteOperations = new HashMap<Class<? extends DbEntity>, DbOperation>();
        DbOperation deleteActivityInstances = commandContext.getHistoricActivityInstanceManager().deleteHistoricActivityInstancesByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteActivityInstances.getEntityType(), deleteActivityInstances);
        DbOperation deleteTaskInstances = commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstancesByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteTaskInstances.getEntityType(), deleteTaskInstances);
        DbOperation deleteVariableInstances = commandContext.getHistoricVariableInstanceManager().deleteHistoricVariableInstancesByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteVariableInstances.getEntityType(), deleteVariableInstances);
        DbOperation deleteDetails = commandContext.getHistoricDetailManager().deleteHistoricDetailsByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteDetails.getEntityType(), deleteDetails);
        DbOperation deleteIncidents = commandContext.getHistoricIncidentManager().deleteHistoricIncidentsByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteIncidents.getEntityType(), deleteIncidents);
        DbOperation deleteTaskLog = commandContext.getHistoricExternalTaskLogManager().deleteExternalTaskLogByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteTaskLog.getEntityType(), deleteTaskLog);
        DbOperation deleteJobLog = commandContext.getHistoricJobLogManager().deleteJobLogByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteJobLog.getEntityType(), deleteJobLog);
        DbOperation deleteOperationLog = commandContext.getOperationLogManager().deleteOperationLogByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteOperationLog.getEntityType(), deleteOperationLog);
        DbOperation deleteIdentityLinkLog = commandContext.getHistoricIdentityLinkManager().deleteHistoricIdentityLinkLogByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteIdentityLinkLog.getEntityType(), deleteIdentityLinkLog);
        DbOperation deleteComments = commandContext.getCommentManager().deleteCommentsByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteComments.getEntityType(), deleteComments);
        DbOperation deleteAttachments = commandContext.getAttachmentManager().deleteAttachmentsByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteAttachments.getEntityType(), deleteAttachments);
        DbOperation deleteByteArrays = commandContext.getByteArrayManager().deleteByteArraysByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteByteArrays.getEntityType(), deleteByteArrays);
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        DbBulkOperation deleteProcessInstances = this.getDbEntityManager().deletePreserveOrder(HistoricProcessInstanceEntity.class, "deleteHistoricProcessInstancesByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
        deleteOperations.put(deleteProcessInstances.getEntityType(), deleteProcessInstances);
        return deleteOperations;
    }
}

