/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.identity.Picture;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityInfoEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.ResourceTypes;

public class SetUserPictureCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected Picture picture;

    public SetUserPictureCmd(String userId, Picture picture) {
        this.userId = userId;
        this.picture = picture;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("userId", (Object)this.userId);
        IdentityInfoEntity pictureInfo = commandContext.getIdentityInfoManager().findUserInfoByUserIdAndKey(this.userId, "picture");
        if (pictureInfo != null) {
            String byteArrayId = pictureInfo.getValue();
            if (byteArrayId != null) {
                commandContext.getByteArrayManager().deleteByteArrayById(byteArrayId);
            }
        } else {
            pictureInfo = new IdentityInfoEntity();
            pictureInfo.setUserId(this.userId);
            pictureInfo.setKey("picture");
            commandContext.getDbEntityManager().insert(pictureInfo);
        }
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(this.picture.getMimeType(), this.picture.getBytes(), ResourceTypes.REPOSITORY);
        commandContext.getByteArrayManager().insertByteArray(byteArrayEntity);
        pictureInfo.setValue(byteArrayEntity.getId());
        return null;
    }
}

