/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.telemetry.TelemetryLogger;

public class IsTelemetryEnabledCmd
implements Command<Boolean> {
    protected static final TelemetryLogger LOG = ProcessEngineLogger.TELEMETRY_LOGGER;

    @Override
    public Boolean execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkCamundaAdmin();
        PropertyEntity telemetryProperty = commandContext.getPropertyManager().findPropertyById("camunda.telemetry.enabled");
        if (telemetryProperty != null) {
            if (telemetryProperty.getValue().toLowerCase().equals("null")) {
                return null;
            }
            return Boolean.parseBoolean(telemetryProperty.getValue());
        }
        LOG.databaseTelemetryPropertyMissingInfo();
        return null;
    }
}

