/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.removaltime;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.BatchJobDeclaration;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeJsonConverter;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class ProcessSetRemovalTimeJobHandler
extends AbstractBatchJobHandler<SetRemovalTimeBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("process-set-removal-time");

    @Override
    public void execute(BatchJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        String byteArrayId = configuration.getConfigurationByteArrayId();
        byte[] configurationByteArray = this.findByteArrayById(byteArrayId, commandContext).getBytes();
        SetRemovalTimeBatchConfiguration batchConfiguration = (SetRemovalTimeBatchConfiguration)this.readConfiguration(configurationByteArray);
        for (String instanceId : batchConfiguration.getIds()) {
            HistoricProcessInstanceEntity instance = this.findProcessInstanceById(instanceId, commandContext);
            if (instance == null) continue;
            if (batchConfiguration.isHierarchical() && this.hasHierarchy(instance)) {
                String rootProcessInstanceId = instance.getRootProcessInstanceId();
                HistoricProcessInstanceEntity rootInstance = this.findProcessInstanceById(rootProcessInstanceId, commandContext);
                Date removalTime = this.getOrCalculateRemovalTime(batchConfiguration, rootInstance, commandContext);
                this.addRemovalTimeToHierarchy(rootProcessInstanceId, removalTime, commandContext);
                continue;
            }
            Date removalTime = this.getOrCalculateRemovalTime(batchConfiguration, instance, commandContext);
            if (removalTime == instance.getRemovalTime()) continue;
            this.addRemovalTime(instanceId, removalTime, commandContext);
        }
    }

    protected Date getOrCalculateRemovalTime(SetRemovalTimeBatchConfiguration batchConfiguration, HistoricProcessInstanceEntity instance, CommandContext commandContext) {
        if (batchConfiguration.hasRemovalTime()) {
            return batchConfiguration.getRemovalTime();
        }
        if (this.hasBaseTime(instance, commandContext)) {
            return this.calculateRemovalTime(instance, commandContext);
        }
        return null;
    }

    protected void addRemovalTimeToHierarchy(String rootProcessInstanceId, Date removalTime, CommandContext commandContext) {
        commandContext.getHistoricProcessInstanceManager().addRemovalTimeToProcessInstancesByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        if (this.isDmnEnabled(commandContext)) {
            commandContext.getHistoricDecisionInstanceManager().addRemovalTimeToDecisionsByRootProcessInstanceId(rootProcessInstanceId, removalTime);
        }
    }

    protected void addRemovalTime(String instanceId, Date removalTime, CommandContext commandContext) {
        commandContext.getHistoricProcessInstanceManager().addRemovalTimeById(instanceId, removalTime);
        if (this.isDmnEnabled(commandContext)) {
            commandContext.getHistoricDecisionInstanceManager().addRemovalTimeToDecisionsByProcessInstanceId(instanceId, removalTime);
        }
    }

    protected boolean hasBaseTime(HistoricProcessInstanceEntity instance, CommandContext commandContext) {
        return this.isStrategyStart(commandContext) || this.isStrategyEnd(commandContext) && this.isEnded(instance);
    }

    protected boolean isEnded(HistoricProcessInstanceEntity instance) {
        return instance.getEndTime() != null;
    }

    protected boolean isStrategyStart(CommandContext commandContext) {
        return "start".equals(this.getHistoryRemovalTimeStrategy(commandContext));
    }

    protected boolean isStrategyEnd(CommandContext commandContext) {
        return "end".equals(this.getHistoryRemovalTimeStrategy(commandContext));
    }

    protected boolean hasHierarchy(HistoricProcessInstanceEntity instance) {
        return instance.getRootProcessInstanceId() != null;
    }

    protected String getHistoryRemovalTimeStrategy(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryRemovalTimeStrategy();
    }

    protected ProcessDefinition findProcessDefinitionById(String processDefinitionId, CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId);
    }

    protected boolean isDmnEnabled(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().isDmnEnabled();
    }

    protected Date calculateRemovalTime(HistoricProcessInstanceEntity processInstance, CommandContext commandContext) {
        ProcessDefinition processDefinition = this.findProcessDefinitionById(processInstance.getProcessDefinitionId(), commandContext);
        return commandContext.getProcessEngineConfiguration().getHistoryRemovalTimeProvider().calculateRemovalTime(processInstance, processDefinition);
    }

    protected ByteArrayEntity findByteArrayById(String byteArrayId, CommandContext commandContext) {
        return commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, byteArrayId);
    }

    protected HistoricProcessInstanceEntity findProcessInstanceById(String instanceId, CommandContext commandContext) {
        return commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstance(instanceId);
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected SetRemovalTimeBatchConfiguration createJobConfiguration(SetRemovalTimeBatchConfiguration configuration, List<String> processInstanceIds) {
        return new SetRemovalTimeBatchConfiguration(processInstanceIds).setRemovalTime(configuration.getRemovalTime()).setHasRemovalTime(configuration.hasRemovalTime()).setHierarchical(configuration.isHierarchical());
    }

    @Override
    protected JsonObjectConverter<SetRemovalTimeBatchConfiguration> getJsonConverterInstance() {
        return SetRemovalTimeJsonConverter.INSTANCE;
    }

    @Override
    public String getType() {
        return "process-set-removal-time";
    }
}

