/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.variables;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.BatchJobDeclaration;
import org.camunda.bpm.engine.impl.batch.variables.SetVariablesJsonConverter;
import org.camunda.bpm.engine.impl.cmd.SetExecutionVariablesCmd;
import org.camunda.bpm.engine.impl.core.variable.VariableUtil;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;

public class BatchSetVariablesHandler
extends AbstractBatchJobHandler<BatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("set-variables");

    @Override
    public void execute(BatchJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        String byteArrayId = configuration.getConfigurationByteArrayId();
        ByteArrayEntity byteArray = this.findByteArrayById(byteArrayId, commandContext);
        byte[] configurationByteArray = byteArray.getBytes();
        Object batchConfiguration = this.readConfiguration(configurationByteArray);
        String batchId = ((BatchConfiguration)batchConfiguration).getBatchId();
        Map<String, ?> variables = VariableUtil.findBatchVariablesSerialized(batchId, commandContext);
        List<String> processInstanceIds = ((BatchConfiguration)batchConfiguration).getIds();
        for (String processInstanceId : processInstanceIds) {
            commandContext.executeWithOperationLogPrevented(new SetExecutionVariablesCmd(processInstanceId, variables, false, true));
        }
        commandContext.getByteArrayManager().delete(byteArray);
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected BatchConfiguration createJobConfiguration(BatchConfiguration configuration, List<String> processIdsForJob) {
        return new BatchConfiguration(processIdsForJob);
    }

    @Override
    protected JsonObjectConverter<BatchConfiguration> getJsonConverterInstance() {
        return SetVariablesJsonConverter.INSTANCE;
    }

    @Override
    public String getType() {
        return "set-variables";
    }

    @Override
    protected void postProcessJob(BatchConfiguration configuration, JobEntity job, BatchConfiguration jobConfiguration) {
        if (jobConfiguration.getIds() != null && jobConfiguration.getIds().size() == 1) {
            job.setProcessInstanceId(jobConfiguration.getIds().get(0));
        }
    }

    protected ByteArrayEntity findByteArrayById(String byteArrayId, CommandContext commandContext) {
        return commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, byteArrayId);
    }
}

