/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobRetriesCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetJobsRetriesCmd
extends AbstractSetJobRetriesCmd
implements Command<Void>,
Serializable {
    protected final List<String> jobIds;
    protected final int retries;

    public SetJobsRetriesCmd(List<String> jobIds, int retries) {
        EnsureUtil.ensureNotEmpty("Job ID's", jobIds);
        EnsureUtil.ensureGreaterThanOrEqual("Retries count", retries, 0L);
        this.jobIds = jobIds;
        this.retries = retries;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        for (String id : this.jobIds) {
            this.setJobRetriesByJobId(id, this.retries, commandContext);
        }
        return null;
    }
}

