/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn;

import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.engine.dmn.DecisionEvaluationBuilder;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.exception.dmn.DecisionDefinitionNotFoundException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.dmn.DecisionLogger;
import org.camunda.bpm.engine.impl.dmn.cmd.EvaluateDecisionTableCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DecisionTableEvaluationBuilderImpl
implements DecisionEvaluationBuilder {
    private static final DecisionLogger LOG = ProcessEngineLogger.DECISION_LOGGER;
    protected CommandExecutor commandExecutor;
    protected String decisionDefinitionKey;
    protected String decisionDefinitionId;
    protected Integer version;
    protected Map<String, Object> variables;
    protected String decisionDefinitionTenantId;
    protected boolean isTenantIdSet = false;

    public DecisionTableEvaluationBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public DecisionEvaluationBuilder variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    @Override
    public DecisionEvaluationBuilder version(Integer version) {
        this.version = version;
        return this;
    }

    @Override
    public DecisionEvaluationBuilder decisionDefinitionTenantId(String tenantId) {
        this.decisionDefinitionTenantId = tenantId;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public DecisionEvaluationBuilder decisionDefinitionWithoutTenantId() {
        this.decisionDefinitionTenantId = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public DmnDecisionTableResult evaluate() {
        EnsureUtil.ensureOnlyOneNotNull(NotValidException.class, "either decision definition id or key must be set", this.decisionDefinitionId, this.decisionDefinitionKey);
        if (this.isTenantIdSet && this.decisionDefinitionId != null) {
            throw LOG.exceptionEvaluateDecisionDefinitionByIdAndTenantId();
        }
        try {
            return this.commandExecutor.execute(new EvaluateDecisionTableCmd(this));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (DecisionDefinitionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    public static DecisionEvaluationBuilder evaluateDecisionTableByKey(CommandExecutor commandExecutor, String decisionDefinitionKey) {
        DecisionTableEvaluationBuilderImpl builder = new DecisionTableEvaluationBuilderImpl(commandExecutor);
        builder.decisionDefinitionKey = decisionDefinitionKey;
        return builder;
    }

    public static DecisionEvaluationBuilder evaluateDecisionTableById(CommandExecutor commandExecutor, String decisionDefinitionId) {
        DecisionTableEvaluationBuilderImpl builder = new DecisionTableEvaluationBuilderImpl(commandExecutor);
        builder.decisionDefinitionId = decisionDefinitionId;
        return builder;
    }

    public String getDecisionDefinitionKey() {
        return this.decisionDefinitionKey;
    }

    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public String getDecisionDefinitionTenantId() {
        return this.decisionDefinitionTenantId;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }
}

