/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.juel;

import java.io.PrintWriter;
import java.util.Stack;
import org.camunda.bpm.engine.impl.juel.Node;

public class NodePrinter {
    private static boolean isLastSibling(Node node, Node parent) {
        if (parent != null) {
            return node == parent.getChild(parent.getCardinality() - 1);
        }
        return true;
    }

    private static void dump(PrintWriter writer, Node node, Stack<Node> predecessors) {
        Node parent;
        if (!predecessors.isEmpty()) {
            parent = null;
            for (Node predecessor : predecessors) {
                if (NodePrinter.isLastSibling(predecessor, parent)) {
                    writer.print("   ");
                } else {
                    writer.print("|  ");
                }
                parent = predecessor;
            }
            writer.println("|");
        }
        parent = null;
        for (Node predecessor : predecessors) {
            if (NodePrinter.isLastSibling(predecessor, parent)) {
                writer.print("   ");
            } else {
                writer.print("|  ");
            }
            parent = predecessor;
        }
        writer.print("+- ");
        writer.println(node.toString());
        predecessors.push(node);
        for (int i = 0; i < node.getCardinality(); ++i) {
            NodePrinter.dump(writer, node.getChild(i), predecessors);
        }
        predecessors.pop();
    }

    public static void dump(PrintWriter writer, Node node) {
        NodePrinter.dump(writer, node, new Stack<Node>());
    }
}

