/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.deletion;

import camundajar.impl.com.google.gson.JsonObject;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.AbstractBatchConfigurationObjectConverter;
import org.camunda.bpm.engine.impl.batch.DeploymentMappingJsonConverter;
import org.camunda.bpm.engine.impl.batch.DeploymentMappings;
import org.camunda.bpm.engine.impl.batch.deletion.DeleteProcessInstanceBatchConfiguration;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public class DeleteProcessInstanceBatchConfigurationJsonConverter
extends AbstractBatchConfigurationObjectConverter<DeleteProcessInstanceBatchConfiguration> {
    public static final DeleteProcessInstanceBatchConfigurationJsonConverter INSTANCE = new DeleteProcessInstanceBatchConfigurationJsonConverter();
    public static final String DELETE_REASON = "deleteReason";
    public static final String PROCESS_INSTANCE_IDS = "processInstanceIds";
    public static final String PROCESS_INSTANCE_ID_MAPPINGS = "processInstanceIdMappings";
    public static final String SKIP_CUSTOM_LISTENERS = "skipCustomListeners";
    public static final String SKIP_SUBPROCESSES = "skipSubprocesses";
    public static final String FAIL_IF_NOT_EXISTS = "failIfNotExists";

    @Override
    public JsonObject writeConfiguration(DeleteProcessInstanceBatchConfiguration configuration) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addField(json, DELETE_REASON, configuration.getDeleteReason());
        JsonUtil.addListField(json, PROCESS_INSTANCE_ID_MAPPINGS, DeploymentMappingJsonConverter.INSTANCE, configuration.getIdMappings());
        JsonUtil.addListField(json, PROCESS_INSTANCE_IDS, configuration.getIds());
        JsonUtil.addField(json, SKIP_CUSTOM_LISTENERS, configuration.isSkipCustomListeners());
        JsonUtil.addField(json, SKIP_SUBPROCESSES, configuration.isSkipSubprocesses());
        JsonUtil.addField(json, FAIL_IF_NOT_EXISTS, configuration.isFailIfNotExists());
        return json;
    }

    @Override
    public DeleteProcessInstanceBatchConfiguration readConfiguration(JsonObject json) {
        DeleteProcessInstanceBatchConfiguration configuration = new DeleteProcessInstanceBatchConfiguration(this.readProcessInstanceIds(json), this.readIdMappings(json), null, JsonUtil.getBoolean(json, SKIP_CUSTOM_LISTENERS), JsonUtil.getBoolean(json, SKIP_SUBPROCESSES), JsonUtil.getBoolean(json, FAIL_IF_NOT_EXISTS));
        String deleteReason = JsonUtil.getString(json, DELETE_REASON);
        if (deleteReason != null && !deleteReason.isEmpty()) {
            configuration.setDeleteReason(deleteReason);
        }
        return configuration;
    }

    protected List<String> readProcessInstanceIds(JsonObject jsonObject) {
        return JsonUtil.asStringList(JsonUtil.getArray(jsonObject, PROCESS_INSTANCE_IDS));
    }

    protected DeploymentMappings readIdMappings(JsonObject json) {
        return JsonUtil.asList(JsonUtil.getArray(json, PROCESS_INSTANCE_ID_MAPPINGS), DeploymentMappingJsonConverter.INSTANCE, DeploymentMappings::new);
    }
}

