/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractSetTaskPropertyCmd<T>
implements Command<Void>,
Serializable {
    protected final String taskId;
    protected final T value;

    public AbstractSetTaskPropertyCmd(String taskId, T value) {
        this(taskId, value, false);
    }

    protected AbstractSetTaskPropertyCmd(String taskId, T value, boolean skipValueValidation) {
        this.taskId = this.ensureNotNullAndGet("taskId", taskId);
        this.value = skipValueValidation ? value : this.ensureNotNullAndGet("value", value);
    }

    @Override
    public Void execute(CommandContext context) {
        TaskEntity task = this.validateAndGet(this.taskId, context);
        this.executeSetOperation(task, this.value);
        task.triggerUpdateEvent();
        this.logOperation(context, task);
        return null;
    }

    protected void logOperation(CommandContext context, TaskEntity task) {
        task.logUserOperation(this.getUserOperationLogName());
    }

    protected TaskEntity validateAndGet(String taskId, CommandContext context) {
        TaskManager taskManager = context.getTaskManager();
        TaskEntity task = taskManager.findTaskById(taskId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "Cannot find task with id " + taskId, "task", (Object)task);
        this.checkTaskAgainstContext(task, context);
        return task;
    }

    protected void checkTaskAgainstContext(TaskEntity task, CommandContext context) {
        for (CommandChecker checker : context.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkTaskAssign(task);
        }
    }

    protected abstract String getUserOperationLogName();

    protected abstract void executeSetOperation(TaskEntity var1, T var2);

    protected <T> T ensureNotNullAndGet(String variableName, T value) {
        EnsureUtil.ensureNotNull(variableName, value);
        return value;
    }
}

