/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.el;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.dmn.engine.impl.spi.el.ElProvider;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.dmn.el.ProcessEngineJuelElProvider;
import org.camunda.bpm.engine.impl.el.ElProviderCompatible;
import org.camunda.bpm.engine.impl.el.Expression;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.el.JuelExpression;
import org.camunda.bpm.engine.impl.el.ProcessApplicationBeanElResolverDelegate;
import org.camunda.bpm.engine.impl.el.ProcessApplicationElResolverDelegate;
import org.camunda.bpm.engine.impl.el.ProcessEngineElContext;
import org.camunda.bpm.engine.impl.el.ReadOnlyMapELResolver;
import org.camunda.bpm.engine.impl.el.VariableContextElResolver;
import org.camunda.bpm.engine.impl.el.VariableScopeElResolver;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.test.mock.MockElResolver;
import org.camunda.bpm.engine.variable.context.VariableContext;
import org.camunda.bpm.impl.juel.ExpressionFactoryImpl;
import org.camunda.bpm.impl.juel.jakarta.el.ArrayELResolver;
import org.camunda.bpm.impl.juel.jakarta.el.CompositeELResolver;
import org.camunda.bpm.impl.juel.jakarta.el.ELContext;
import org.camunda.bpm.impl.juel.jakarta.el.ELResolver;
import org.camunda.bpm.impl.juel.jakarta.el.ExpressionFactory;
import org.camunda.bpm.impl.juel.jakarta.el.FunctionMapper;
import org.camunda.bpm.impl.juel.jakarta.el.ListELResolver;
import org.camunda.bpm.impl.juel.jakarta.el.MapELResolver;
import org.camunda.bpm.impl.juel.jakarta.el.ValueExpression;

public class JuelExpressionManager
implements ExpressionManager,
ElProviderCompatible {
    protected Map<String, Method> functions = new HashMap<String, Method>();
    protected ExpressionFactory expressionFactory = new ExpressionFactoryImpl();
    protected Map<Object, Object> beans;
    protected volatile boolean initialized = false;
    protected ELResolver elResolver;
    protected FunctionMapper functionMapper;
    protected ELContext parsingElContext;
    protected volatile ElProvider elProvider;

    public JuelExpressionManager() {
        this(null);
    }

    public JuelExpressionManager(Map<Object, Object> beans) {
        this.beans = beans;
    }

    @Override
    public Expression createExpression(String expression) {
        this.ensureInitialized();
        ValueExpression valueExpression = this.createValueExpression(expression);
        return new JuelExpression(valueExpression, this, expression);
    }

    @Override
    public void addFunction(String name, Method function) {
        EnsureUtil.ensureNotEmpty("name", name);
        EnsureUtil.ensureNotNull("function", (Object)function);
        this.functions.put(name, function);
    }

    public ValueExpression createValueExpression(String expression) {
        this.ensureInitialized();
        return this.expressionFactory.createValueExpression(this.parsingElContext, expression, Object.class);
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public ELContext getElContext(VariableScope variableScope) {
        this.ensureInitialized();
        ELContext elContext = null;
        if (variableScope instanceof AbstractVariableScope) {
            AbstractVariableScope variableScopeImpl = (AbstractVariableScope)variableScope;
            elContext = variableScopeImpl.getCachedElContext();
        }
        if (elContext == null) {
            elContext = this.createElContext(variableScope);
            if (variableScope instanceof AbstractVariableScope) {
                ((AbstractVariableScope)variableScope).setCachedElContext(elContext);
            }
        }
        return elContext;
    }

    public ELContext createElContext(VariableContext variableContext) {
        this.ensureInitialized();
        ProcessEngineElContext elContext = new ProcessEngineElContext(this.functionMapper, this.elResolver);
        elContext.putContext(ExpressionFactory.class, this.expressionFactory);
        elContext.putContext(VariableContext.class, variableContext);
        return elContext;
    }

    protected ProcessEngineElContext createElContext(VariableScope variableScope) {
        this.ensureInitialized();
        ProcessEngineElContext elContext = new ProcessEngineElContext(this.functionMapper, this.elResolver);
        elContext.putContext(ExpressionFactory.class, this.expressionFactory);
        if (variableScope != null) {
            elContext.putContext(VariableScope.class, variableScope);
        }
        return elContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureInitialized() {
        if (!this.initialized) {
            JuelExpressionManager juelExpressionManager = this;
            synchronized (juelExpressionManager) {
                if (!this.initialized) {
                    this.elResolver = this.createElResolver();
                    this.functionMapper = this.createFunctionMapper();
                    this.parsingElContext = new ProcessEngineElContext(this.functionMapper);
                    this.initialized = true;
                }
            }
        }
    }

    protected ELResolver createElResolver() {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add((ELResolver)new VariableScopeElResolver());
        elResolver.add((ELResolver)new VariableContextElResolver());
        elResolver.add((ELResolver)new MockElResolver());
        if (this.beans != null) {
            elResolver.add((ELResolver)new ReadOnlyMapELResolver(this.beans));
        }
        elResolver.add((ELResolver)new ProcessApplicationElResolverDelegate());
        elResolver.add((ELResolver)new ArrayELResolver());
        elResolver.add((ELResolver)new ListELResolver());
        elResolver.add((ELResolver)new MapELResolver());
        elResolver.add((ELResolver)new ProcessApplicationBeanElResolverDelegate());
        return elResolver;
    }

    protected FunctionMapper createFunctionMapper() {
        FunctionMapper functionMapper = new FunctionMapper(){

            public Method resolveFunction(String prefix, String localName) {
                Object fullName = localName;
                if (prefix != null && !prefix.trim().isEmpty()) {
                    fullName = prefix + ":" + localName;
                }
                return JuelExpressionManager.this.functions.get(fullName);
            }
        };
        return functionMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElProvider toElProvider() {
        if (this.elProvider == null) {
            JuelExpressionManager juelExpressionManager = this;
            synchronized (juelExpressionManager) {
                if (this.elProvider == null) {
                    this.elProvider = this.createElProvider();
                }
            }
        }
        return this.elProvider;
    }

    protected ElProvider createElProvider() {
        return new ProcessEngineJuelElProvider(this);
    }
}

