/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.HistoryTimeToLiveParser;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class UpdateCaseDefinitionHistoryTimeToLiveCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;
    protected Integer historyTimeToLive;

    public UpdateCaseDefinitionHistoryTimeToLiveCmd(String caseDefinitionId, Integer historyTimeToLive) {
        this.caseDefinitionId = caseDefinitionId;
        this.historyTimeToLive = historyTimeToLive;
    }

    @Override
    public Void execute(CommandContext context) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "caseDefinitionId", (Object)this.caseDefinitionId);
        if (this.historyTimeToLive != null) {
            EnsureUtil.ensureGreaterThanOrEqual(BadUserRequestException.class, "", "historyTimeToLive", this.historyTimeToLive.intValue(), 0L);
        }
        this.validate(this.historyTimeToLive, context);
        CaseDefinitionEntity caseDefinitionEntity = context.getCaseDefinitionManager().findLatestDefinitionById(this.caseDefinitionId);
        for (CommandChecker checker : context.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateCaseDefinition(caseDefinitionEntity);
        }
        this.logUserOperation(context, caseDefinitionEntity);
        caseDefinitionEntity.setHistoryTimeToLive(this.historyTimeToLive);
        return null;
    }

    protected void logUserOperation(CommandContext commandContext, CaseDefinitionEntity caseDefinitionEntity) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("historyTimeToLive", caseDefinitionEntity.getHistoryTimeToLive(), this.historyTimeToLive));
        propertyChanges.add(new PropertyChange("caseDefinitionKey", null, caseDefinitionEntity.getKey()));
        commandContext.getOperationLogManager().logCaseDefinitionOperation("UpdateHistoryTimeToLive", this.caseDefinitionId, caseDefinitionEntity.getTenantId(), propertyChanges);
    }

    protected void validate(Integer historyTimeToLive, CommandContext context) {
        HistoryTimeToLiveParser parser = HistoryTimeToLiveParser.create(context);
        parser.validate(historyTimeToLive);
    }
}

