/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractInstantiationCmd;
import org.camunda.bpm.engine.impl.core.model.CoreModelElement;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class ActivityBeforeInstantiationCmd
extends AbstractInstantiationCmd {
    protected String activityId;

    public ActivityBeforeInstantiationCmd(String processInstanceId, String activityId) {
        this(processInstanceId, activityId, null);
    }

    public ActivityBeforeInstantiationCmd(String processInstanceId, String activityId, String ancestorActivityInstanceId) {
        super(processInstanceId, ancestorActivityInstanceId);
        this.activityId = activityId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        ProcessDefinitionEntity processDefinition = processInstance.getProcessDefinition();
        ActivityImpl activity = processDefinition.findActivity(this.activityId);
        if (activity != null && "compensationBoundaryCatch".equals(activity.getProperty("type"))) {
            throw new ProcessEngineException("Cannot start before activity " + this.activityId + "; activity " + "is a compensation boundary event.");
        }
        return super.execute(commandContext);
    }

    @Override
    protected ScopeImpl getTargetFlowScope(ProcessDefinitionImpl processDefinition) {
        ActivityImpl activity = processDefinition.findActivity(this.activityId);
        return activity.getFlowScope();
    }

    @Override
    protected CoreModelElement getTargetElement(ProcessDefinitionImpl processDefinition) {
        ActivityImpl activity = processDefinition.findActivity(this.activityId);
        return activity;
    }

    @Override
    protected String getTargetElementId() {
        return this.activityId;
    }

    @Override
    protected String describe() {
        StringBuilder sb = new StringBuilder();
        sb.append("Start before activity '");
        sb.append(this.activityId);
        sb.append("'");
        if (this.ancestorActivityInstanceId != null) {
            sb.append(" with ancestor activity instance '");
            sb.append(this.ancestorActivityInstanceId);
            sb.append("'");
        }
        return sb.toString();
    }
}

