/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.variable.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.variable.impl.TypedValueField;
import org.camunda.bpm.client.variable.impl.ValueMapper;
import org.camunda.bpm.client.variable.impl.ValueMappers;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DefaultValueMappers<T extends TypedValue>
implements Serializable,
ValueMappers<T> {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    private static final long serialVersionUID = 1L;
    protected List<ValueMapper<? extends TypedValue>> serializerList = new ArrayList<ValueMapper<? extends TypedValue>>();
    protected String defaultSerializationFormat;

    public DefaultValueMappers(String defaultSerializationFormat) {
        this.defaultSerializationFormat = defaultSerializationFormat;
    }

    @Override
    public ValueMapper<T> findMapperForTypedValue(T typedValue) {
        ValueType type = typedValue.getType();
        if (type != null && type.isAbstract()) {
            throw LOG.valueMapperExceptionWhileSerializingAbstractValue(type.getName());
        }
        ArrayList<ValueMapper<? extends TypedValue>> matchedSerializers = new ArrayList<ValueMapper<? extends TypedValue>>();
        for (ValueMapper<? extends TypedValue> serializer2 : this.serializerList) {
            if (!serializer2.canHandleTypedValue((TypedValue)typedValue)) continue;
            matchedSerializers.add(serializer2);
            if (!serializer2.getType().isPrimitiveValueType()) continue;
            break;
        }
        if (matchedSerializers.size() == 1) {
            return (ValueMapper)matchedSerializers.get(0);
        }
        if (matchedSerializers.size() > 1) {
            return matchedSerializers.stream().filter(serializer -> this.defaultSerializationFormat.equals(serializer.getSerializationDataformat())).findFirst().orElse((ValueMapper)matchedSerializers.get(0));
        }
        throw LOG.valueMapperExceptionDueToSerializerNotFoundForTypedValue((TypedValue)typedValue);
    }

    @Override
    public ValueMapper<T> findMapperForTypedValueField(TypedValueField typedValueField) {
        ValueMapper matchedSerializer = this.serializerList.stream().filter(serializer -> serializer.canHandleTypedValueField(typedValueField)).findFirst().orElse(null);
        if (matchedSerializer == null) {
            throw LOG.valueMapperExceptionDueToSerializerNotFoundForTypedValueField(typedValueField.getValue());
        }
        return matchedSerializer;
    }

    @Override
    public ValueMappers addMapper(ValueMapper<T> serializer) {
        this.serializerList.add(serializer);
        return this;
    }
}

