/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.assertions;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.assertions.AbstractProcessAssert;
import org.camunda.bpm.engine.test.assertions.JobAssert;
import org.camunda.bpm.engine.test.assertions.ProcessDefinitionAssert;
import org.camunda.bpm.engine.test.assertions.ProcessInstanceAssert;
import org.camunda.bpm.engine.test.assertions.TaskAssert;

public class ProcessEngineAssertions
extends Assertions {
    static ThreadLocal<ProcessEngine> processEngine = new ThreadLocal();

    protected ProcessEngineAssertions() {
    }

    public static ProcessEngine processEngine() {
        ProcessEngine processEngine = ProcessEngineAssertions.processEngine.get();
        if (processEngine != null) {
            return processEngine;
        }
        Map processEngines = ProcessEngines.getProcessEngines();
        if (processEngines.size() == 1) {
            processEngine = (ProcessEngine)processEngines.values().iterator().next();
            ProcessEngineAssertions.init(processEngine);
            return processEngine;
        }
        String message = processEngines.size() == 0 ? "No ProcessEngine found to be registered with " + ProcessEngines.class.getSimpleName() + "!" : String.format(processEngines.size() + " ProcessEngines initialized. Call %s.init" + "(ProcessEngine processEngine) first!", ProcessEngineAssertions.class.getSimpleName());
        throw new IllegalStateException(message);
    }

    public static void init(ProcessEngine processEngine) {
        ProcessEngineAssertions.processEngine.set(processEngine);
        AbstractProcessAssert.resetLastAsserts();
    }

    public static void reset() {
        processEngine.remove();
        AbstractProcessAssert.resetLastAsserts();
    }

    public static ProcessDefinitionAssert assertThat(ProcessDefinition actual) {
        return ProcessDefinitionAssert.assertThat(ProcessEngineAssertions.processEngine(), actual);
    }

    public static ProcessInstanceAssert assertThat(ProcessInstance actual) {
        return ProcessInstanceAssert.assertThat(ProcessEngineAssertions.processEngine(), actual);
    }

    public static TaskAssert assertThat(Task actual) {
        return TaskAssert.assertThat(ProcessEngineAssertions.processEngine(), actual);
    }

    public static JobAssert assertThat(Job actual) {
        return JobAssert.assertThat(ProcessEngineAssertions.processEngine(), actual);
    }
}

