/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.serializer.support;

import keycloakjar.org.springframework.core.convert.converter.Converter;
import keycloakjar.org.springframework.core.serializer.DefaultSerializer;
import keycloakjar.org.springframework.core.serializer.Serializer;
import keycloakjar.org.springframework.core.serializer.support.SerializationFailedException;
import keycloakjar.org.springframework.util.Assert;

public class SerializingConverter
implements Converter<Object, byte[]> {
    private final Serializer<Object> serializer;

    public SerializingConverter() {
        this.serializer = new DefaultSerializer();
    }

    public SerializingConverter(Serializer<Object> serializer) {
        Assert.notNull(serializer, "Serializer must not be null");
        this.serializer = serializer;
    }

    @Override
    public byte[] convert(Object source) {
        try {
            return this.serializer.serializeToByteArray(source);
        }
        catch (Throwable ex) {
            throw new SerializationFailedException("Failed to serialize object using " + this.serializer.getClass().getSimpleName(), ex);
        }
    }
}

