/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.server.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelId;
import java.nio.file.Path;
import java.util.List;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.apache.commons.logging.LogFactory;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.core.io.buffer.DataBufferUtils;
import keycloakjar.org.springframework.core.io.buffer.NettyDataBufferFactory;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.ResponseCookie;
import keycloakjar.org.springframework.http.ZeroCopyHttpOutputMessage;
import keycloakjar.org.springframework.http.server.reactive.AbstractServerHttpResponse;
import keycloakjar.org.springframework.http.server.reactive.NettyHeadersAdapter;
import keycloakjar.org.springframework.http.server.reactive.ReactorServerHttpRequest;
import keycloakjar.org.springframework.util.Assert;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ChannelOperationsId;
import reactor.netty.http.server.HttpServerResponse;

class ReactorServerHttpResponse
extends AbstractServerHttpResponse
implements ZeroCopyHttpOutputMessage {
    private static final Log logger = LogFactory.getLog(ReactorServerHttpResponse.class);
    private final HttpServerResponse response;

    public ReactorServerHttpResponse(HttpServerResponse response, DataBufferFactory bufferFactory) {
        super(bufferFactory, new HttpHeaders(new NettyHeadersAdapter(response.responseHeaders())));
        Assert.notNull((Object)response, "HttpServerResponse must not be null");
        this.response = response;
    }

    @Override
    public <T> T getNativeResponse() {
        return (T)this.response;
    }

    @Override
    public HttpStatus getStatusCode() {
        HttpStatus status = super.getStatusCode();
        return status != null ? status : HttpStatus.resolve(this.response.status().code());
    }

    @Override
    public Integer getRawStatusCode() {
        Integer status = super.getRawStatusCode();
        return status != null ? status.intValue() : this.response.status().code();
    }

    @Override
    protected void applyStatusCode() {
        Integer status = super.getRawStatusCode();
        if (status != null) {
            this.response.status(status.intValue());
        }
    }

    @Override
    protected Mono<Void> writeWithInternal(Publisher<? extends DataBuffer> publisher) {
        return this.response.send(this.toByteBufs(publisher)).then();
    }

    @Override
    protected Mono<Void> writeAndFlushWithInternal(Publisher<? extends Publisher<? extends DataBuffer>> publisher) {
        return this.response.sendGroups((Publisher)Flux.from(publisher).map(this::toByteBufs)).then();
    }

    @Override
    protected void applyHeaders() {
    }

    @Override
    protected void applyCookies() {
        for (List cookies : this.getCookies().values()) {
            for (ResponseCookie cookie : cookies) {
                this.response.addHeader((CharSequence)"Set-Cookie", (CharSequence)cookie.toString());
            }
        }
    }

    @Override
    public Mono<Void> writeWith(Path file, long position, long count) {
        return this.doCommit(() -> this.response.sendFile(file, position, count).then());
    }

    private Publisher<ByteBuf> toByteBufs(Publisher<? extends DataBuffer> dataBuffers) {
        return dataBuffers instanceof Mono ? Mono.from(dataBuffers).map(NettyDataBufferFactory::toByteBuf) : Flux.from(dataBuffers).map(NettyDataBufferFactory::toByteBuf);
    }

    @Override
    protected void touchDataBuffer(DataBuffer buffer) {
        if (logger.isDebugEnabled()) {
            if (ReactorServerHttpRequest.reactorNettyRequestChannelOperationsIdPresent && ChannelOperationsIdHelper.touch(buffer, this.response)) {
                return;
            }
            this.response.withConnection(connection -> {
                ChannelId id = connection.channel().id();
                DataBufferUtils.touch(buffer, "Channel id: " + id.asShortText());
            });
        }
    }

    private static class ChannelOperationsIdHelper {
        private ChannelOperationsIdHelper() {
        }

        public static boolean touch(DataBuffer dataBuffer, HttpServerResponse response) {
            if (response instanceof ChannelOperationsId) {
                String id = ((ChannelOperationsId)response).asLongText();
                DataBufferUtils.touch(dataBuffer, "Channel id: " + id);
                return true;
            }
            return false;
        }
    }
}

