/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http.impl;

import keycloakjar.org.apache.hc.core5.http.protocol.HttpProcessor;
import keycloakjar.org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import keycloakjar.org.apache.hc.core5.http.protocol.RequestConnControl;
import keycloakjar.org.apache.hc.core5.http.protocol.RequestContent;
import keycloakjar.org.apache.hc.core5.http.protocol.RequestExpectContinue;
import keycloakjar.org.apache.hc.core5.http.protocol.RequestTargetHost;
import keycloakjar.org.apache.hc.core5.http.protocol.RequestUserAgent;
import keycloakjar.org.apache.hc.core5.http.protocol.RequestValidateHost;
import keycloakjar.org.apache.hc.core5.http.protocol.ResponseConnControl;
import keycloakjar.org.apache.hc.core5.http.protocol.ResponseContent;
import keycloakjar.org.apache.hc.core5.http.protocol.ResponseDate;
import keycloakjar.org.apache.hc.core5.http.protocol.ResponseServer;
import keycloakjar.org.apache.hc.core5.util.TextUtils;
import keycloakjar.org.apache.hc.core5.util.VersionInfo;

public final class HttpProcessors {
    private static final String SOFTWARE = "Apache-HttpCore";

    public static HttpProcessorBuilder customServer(String serverInfo) {
        return HttpProcessorBuilder.create().addAll(new ResponseDate(), new ResponseServer(!TextUtils.isBlank(serverInfo) ? serverInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "keycloakjar.org.apache.hc.core5", HttpProcessors.class)), new ResponseContent(), new ResponseConnControl()).addAll(new RequestValidateHost());
    }

    public static HttpProcessor server(String serverInfo) {
        return HttpProcessors.customServer(serverInfo).build();
    }

    public static HttpProcessor server() {
        return HttpProcessors.customServer(null).build();
    }

    public static HttpProcessorBuilder customClient(String agentInfo) {
        return HttpProcessorBuilder.create().addAll(RequestContent.INSTANCE, RequestTargetHost.INSTANCE, RequestConnControl.INSTANCE, new RequestUserAgent(!TextUtils.isBlank(agentInfo) ? agentInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "keycloakjar.org.apache.hc.core5", HttpProcessors.class)), RequestExpectContinue.INSTANCE);
    }

    public static HttpProcessor client(String agentInfo) {
        return HttpProcessors.customClient(agentInfo).build();
    }

    public static HttpProcessor client() {
        return HttpProcessors.customClient(null).build();
    }
}

