/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.generate;

import java.util.function.Consumer;
import keycloakjar.org.springframework.aot.generate.DefaultMethodReference;
import keycloakjar.org.springframework.aot.generate.MethodReference;
import keycloakjar.org.springframework.javapoet.ClassName;
import keycloakjar.org.springframework.javapoet.MethodSpec;
import keycloakjar.org.springframework.util.Assert;

public final class GeneratedMethod {
    private final ClassName className;
    private final String name;
    private final MethodSpec methodSpec;

    GeneratedMethod(ClassName className, String name, Consumer<MethodSpec.Builder> method) {
        this.className = className;
        this.name = name;
        MethodSpec.Builder builder = MethodSpec.methodBuilder(this.name);
        method.accept(builder);
        this.methodSpec = builder.build();
        Assert.state(this.name.equals(this.methodSpec.name), "'method' consumer must not change the generated method name");
    }

    public String getName() {
        return this.name;
    }

    public MethodReference toMethodReference() {
        return new DefaultMethodReference(this.methodSpec, this.className);
    }

    MethodSpec getMethodSpec() {
        return this.methodSpec;
    }

    public String toString() {
        return this.name;
    }
}

