/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.hint.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import keycloakjar.org.springframework.aot.hint.ExecutableMode;
import keycloakjar.org.springframework.aot.hint.MemberCategory;
import keycloakjar.org.springframework.aot.hint.ReflectionHints;
import keycloakjar.org.springframework.aot.hint.annotation.ReflectiveProcessor;

public class SimpleReflectiveProcessor
implements ReflectiveProcessor {
    @Override
    public void registerReflectionHints(ReflectionHints hints, AnnotatedElement element) {
        if (element instanceof Class) {
            Class type = (Class)element;
            this.registerTypeHint(hints, type);
        } else if (element instanceof Constructor) {
            Constructor constructor = (Constructor)element;
            this.registerConstructorHint(hints, constructor);
        } else if (element instanceof Field) {
            Field field = (Field)element;
            this.registerFieldHint(hints, field);
        } else if (element instanceof Method) {
            Method method = (Method)element;
            this.registerMethodHint(hints, method);
        }
    }

    protected void registerTypeHint(ReflectionHints hints, Class<?> type) {
        hints.registerType(type, new MemberCategory[0]);
    }

    protected void registerConstructorHint(ReflectionHints hints, Constructor<?> constructor) {
        hints.registerConstructor(constructor, ExecutableMode.INVOKE);
    }

    protected void registerFieldHint(ReflectionHints hints, Field field) {
        hints.registerField(field);
    }

    protected void registerMethodHint(ReflectionHints hints, Method method) {
        hints.registerMethod(method, ExecutableMode.INVOKE);
    }
}

