/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import keycloakjar.org.springframework.beans.ExtendedBeanInfo;
import keycloakjar.org.springframework.beans.StandardBeanInfoFactory;
import keycloakjar.org.springframework.lang.NonNull;

public class ExtendedBeanInfoFactory
extends StandardBeanInfoFactory {
    @Override
    @NonNull
    public BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        BeanInfo beanInfo = super.getBeanInfo(beanClass);
        return this.supports(beanClass) ? new ExtendedBeanInfo(beanInfo) : beanInfo;
    }

    private boolean supports(Class<?> beanClass) {
        for (Method method : beanClass.getMethods()) {
            if (!ExtendedBeanInfo.isCandidateWriteMethod(method)) continue;
            return true;
        }
        return false;
    }
}

