/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.codec;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.AbstractCharSequenceDecoder;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.MimeType;
import keycloakjar.org.springframework.util.MimeTypeUtils;

public final class CharBufferDecoder
extends AbstractCharSequenceDecoder<CharBuffer> {
    public CharBufferDecoder(List<String> delimiters, boolean stripDelimiter, MimeType ... mimeTypes) {
        super(delimiters, stripDelimiter, mimeTypes);
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return elementType.resolve() == CharBuffer.class && super.canDecode(elementType, mimeType);
    }

    @Override
    protected CharBuffer decodeInternal(DataBuffer dataBuffer, Charset charset) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(dataBuffer.readableByteCount());
        dataBuffer.toByteBuffer(byteBuffer);
        return charset.decode(byteBuffer);
    }

    public static CharBufferDecoder textPlainOnly() {
        return CharBufferDecoder.textPlainOnly(DEFAULT_DELIMITERS, true);
    }

    public static CharBufferDecoder textPlainOnly(List<String> delimiters, boolean stripDelimiter) {
        MimeType textPlain = new MimeType("text", "plain", DEFAULT_CHARSET);
        return new CharBufferDecoder(delimiters, stripDelimiter, textPlain);
    }

    public static CharBufferDecoder allMimeTypes() {
        return CharBufferDecoder.allMimeTypes(DEFAULT_DELIMITERS, true);
    }

    public static CharBufferDecoder allMimeTypes(List<String> delimiters, boolean stripDelimiter) {
        MimeType textPlain = new MimeType("text", "plain", DEFAULT_CHARSET);
        return new CharBufferDecoder(delimiters, stripDelimiter, textPlain, MimeTypeUtils.ALL);
    }
}

