/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.style;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import keycloakjar.org.springframework.core.style.ValueStyler;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ClassUtils;
import keycloakjar.org.springframework.util.ObjectUtils;

public class DefaultValueStyler
implements ValueStyler {
    private static final String EMPTY = "[[empty]]";
    private static final String NULL = "[null]";
    private static final String COLLECTION = "collection";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final String MAP = "map";
    private static final String EMPTY_MAP = "map[[empty]]";
    private static final String ARRAY = "array";

    @Override
    public String style(@Nullable Object value) {
        if (value == null) {
            return this.styleNull();
        }
        if (value instanceof String) {
            String str = (String)value;
            return this.styleString(str);
        }
        if (value instanceof Class) {
            Class clazz = (Class)value;
            return this.styleClass(clazz);
        }
        if (value instanceof Method) {
            Method method = (Method)value;
            return this.styleMethod(method);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return this.styleMap(map);
        }
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            return this.styleMapEntry(entry);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return this.styleCollection(collection);
        }
        if (value.getClass().isArray()) {
            return this.styleArray(ObjectUtils.toObjectArray(value));
        }
        return this.styleObject(value);
    }

    protected String styleNull() {
        return NULL;
    }

    protected String styleString(String str) {
        return "'" + str + "'";
    }

    protected String styleClass(Class<?> clazz) {
        return ClassUtils.getShortName(clazz);
    }

    protected String styleMethod(Method method) {
        return method.getName() + "@" + ClassUtils.getShortName(method.getDeclaringClass());
    }

    protected <K, V> String styleMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return EMPTY_MAP;
        }
        StringJoiner result = new StringJoiner(", ", "[", "]");
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.add(this.styleMapEntry(entry));
        }
        return MAP + result;
    }

    protected String styleMapEntry(Map.Entry<?, ?> entry) {
        return this.style(entry.getKey()) + " -> " + this.style(entry.getValue());
    }

    protected String styleCollection(Collection<?> collection) {
        String collectionType = DefaultValueStyler.getCollectionTypeString(collection);
        if (collection.isEmpty()) {
            return collectionType + EMPTY;
        }
        StringJoiner result = new StringJoiner(", ", "[", "]");
        for (Object element : collection) {
            result.add(this.style(element));
        }
        return collectionType + result;
    }

    protected String styleArray(Object[] array) {
        if (array.length == 0) {
            return "array<" + ClassUtils.getShortName(array.getClass().componentType()) + ">[[empty]]";
        }
        StringJoiner result = new StringJoiner(", ", "[", "]");
        for (Object element : array) {
            result.add(this.style(element));
        }
        return "array<" + ClassUtils.getShortName(array.getClass().componentType()) + ">" + result;
    }

    protected String styleObject(Object obj) {
        return String.valueOf(obj);
    }

    private static String getCollectionTypeString(Collection<?> collection) {
        if (collection instanceof List) {
            return LIST;
        }
        if (collection instanceof Set) {
            return SET;
        }
        return COLLECTION;
    }
}

