/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.type.classreading;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import keycloakjar.org.springframework.core.annotation.MergedAnnotations;
import keycloakjar.org.springframework.core.type.AnnotationMetadata;
import keycloakjar.org.springframework.core.type.MethodMetadata;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.StringUtils;

final class SimpleAnnotationMetadata
implements AnnotationMetadata {
    private final String className;
    private final int access;
    @Nullable
    private final String enclosingClassName;
    @Nullable
    private final String superClassName;
    private final boolean independentInnerClass;
    private final Set<String> interfaceNames;
    private final Set<String> memberClassNames;
    private final Set<MethodMetadata> declaredMethods;
    private final MergedAnnotations mergedAnnotations;
    @Nullable
    private Set<String> annotationTypes;

    SimpleAnnotationMetadata(String className, int access, @Nullable String enclosingClassName, @Nullable String superClassName, boolean independentInnerClass, Set<String> interfaceNames, Set<String> memberClassNames, Set<MethodMetadata> declaredMethods, MergedAnnotations mergedAnnotations) {
        this.className = className;
        this.access = access;
        this.enclosingClassName = enclosingClassName;
        this.superClassName = superClassName;
        this.independentInnerClass = independentInnerClass;
        this.interfaceNames = interfaceNames;
        this.memberClassNames = memberClassNames;
        this.declaredMethods = declaredMethods;
        this.mergedAnnotations = mergedAnnotations;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.access & 0x2000) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.access & 0x10) != 0;
    }

    @Override
    public boolean isIndependent() {
        return this.enclosingClassName == null || this.independentInnerClass;
    }

    @Override
    @Nullable
    public String getEnclosingClassName() {
        return this.enclosingClassName;
    }

    @Override
    @Nullable
    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public String[] getInterfaceNames() {
        return StringUtils.toStringArray(this.interfaceNames);
    }

    @Override
    public String[] getMemberClassNames() {
        return StringUtils.toStringArray(this.memberClassNames);
    }

    @Override
    public MergedAnnotations getAnnotations() {
        return this.mergedAnnotations;
    }

    @Override
    public Set<String> getAnnotationTypes() {
        Set<String> annotationTypes = this.annotationTypes;
        if (annotationTypes == null) {
            this.annotationTypes = annotationTypes = Collections.unmodifiableSet(AnnotationMetadata.super.getAnnotationTypes());
        }
        return annotationTypes;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationName) {
        LinkedHashSet<MethodMetadata> result = new LinkedHashSet<MethodMetadata>(4);
        for (MethodMetadata annotatedMethod : this.declaredMethods) {
            if (!annotatedMethod.isAnnotated(annotationName)) continue;
            result.add(annotatedMethod);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<MethodMetadata> getDeclaredMethods() {
        return Collections.unmodifiableSet(this.declaredMethods);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof SimpleAnnotationMetadata)) return false;
        SimpleAnnotationMetadata that = (SimpleAnnotationMetadata)other;
        if (!this.className.equals(that.className)) return false;
        return true;
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public String toString() {
        return this.className;
    }
}

