/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.client.ClientHttpResponse;
import keycloakjar.org.springframework.util.CollectionUtils;
import keycloakjar.org.springframework.util.LinkedCaseInsensitiveMap;
import keycloakjar.org.springframework.util.MultiValueMap;
import keycloakjar.org.springframework.util.StreamUtils;

class JdkClientHttpResponse
implements ClientHttpResponse {
    private final HttpResponse<InputStream> response;
    private final HttpHeaders headers;
    private final InputStream body;

    public JdkClientHttpResponse(HttpResponse<InputStream> response) {
        this.response = response;
        this.headers = JdkClientHttpResponse.adaptHeaders(response);
        InputStream inputStream = response.body();
        this.body = inputStream != null ? inputStream : InputStream.nullInputStream();
    }

    private static HttpHeaders adaptHeaders(HttpResponse<?> response) {
        Map<String, List<String>> rawHeaders = response.headers().map();
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap(rawHeaders.size(), Locale.ENGLISH);
        MultiValueMap<String, String> multiValueMap = CollectionUtils.toMultiValueMap(map);
        multiValueMap.putAll(rawHeaders);
        return HttpHeaders.readOnlyHttpHeaders(multiValueMap);
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf(this.response.statusCode());
    }

    @Override
    public String getStatusText() {
        HttpStatusCode httpStatusCode = this.getStatusCode();
        if (httpStatusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)httpStatusCode;
            return status.getReasonPhrase();
        }
        return "";
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public InputStream getBody() throws IOException {
        return this.body;
    }

    @Override
    public void close() {
        try {
            try {
                StreamUtils.drain(this.body);
            }
            finally {
                this.body.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

