/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client.reactive;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import keycloakjar.org.springframework.beans.factory.DisposableBean;
import keycloakjar.org.springframework.beans.factory.InitializingBean;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import keycloakjar.org.springframework.util.Assert;

public class JdkHttpClientResourceFactory
implements InitializingBean,
DisposableBean {
    @Nullable
    private Executor executor;
    private String threadPrefix = "jdk-http";

    public void setExecutor(@Nullable Executor executor) {
        this.executor = executor;
    }

    @Nullable
    public Executor getExecutor() {
        return this.executor;
    }

    public void setThreadPrefix(String threadPrefix) {
        Assert.notNull((Object)threadPrefix, "Thread prefix is required");
        this.threadPrefix = threadPrefix;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.executor == null) {
            String name = this.threadPrefix + "@" + Integer.toHexString(this.hashCode());
            this.executor = Executors.newCachedThreadPool((ThreadFactory)new CustomizableThreadFactory(name));
        }
    }

    @Override
    public void destroy() throws Exception {
        Executor executor = this.executor;
        if (executor instanceof ExecutorService) {
            ExecutorService executorService = (ExecutorService)executor;
            executorService.shutdown();
        }
    }
}

