/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec.multipart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.ResolvableTypeProvider;
import keycloakjar.org.springframework.core.codec.CharSequenceEncoder;
import keycloakjar.org.springframework.core.codec.CodecException;
import keycloakjar.org.springframework.core.codec.Hints;
import keycloakjar.org.springframework.core.io.Resource;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.core.io.buffer.DataBufferUtils;
import keycloakjar.org.springframework.core.log.LogFormatUtils;
import keycloakjar.org.springframework.http.HttpEntity;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.ReactiveHttpOutputMessage;
import keycloakjar.org.springframework.http.codec.EncoderHttpMessageWriter;
import keycloakjar.org.springframework.http.codec.FormHttpMessageWriter;
import keycloakjar.org.springframework.http.codec.HttpMessageWriter;
import keycloakjar.org.springframework.http.codec.ResourceHttpMessageWriter;
import keycloakjar.org.springframework.http.codec.multipart.MultipartHttpMessageReader;
import keycloakjar.org.springframework.http.codec.multipart.MultipartWriterSupport;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.MultiValueMap;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MultipartHttpMessageWriter
extends MultipartWriterSupport
implements HttpMessageWriter<MultiValueMap<String, ?>> {
    private static final Map<String, Object> DEFAULT_HINTS = Hints.from(Hints.SUPPRESS_LOGGING_HINT, true);
    private final Supplier<List<HttpMessageWriter<?>>> partWritersSupplier;
    @Nullable
    private final HttpMessageWriter<MultiValueMap<String, String>> formWriter;

    public MultipartHttpMessageWriter() {
        this(Arrays.asList(new EncoderHttpMessageWriter<CharSequence>(CharSequenceEncoder.textPlainOnly()), new ResourceHttpMessageWriter()));
    }

    public MultipartHttpMessageWriter(List<HttpMessageWriter<?>> partWriters) {
        this(partWriters, (HttpMessageWriter<MultiValueMap<String, String>>)new FormHttpMessageWriter());
    }

    public MultipartHttpMessageWriter(List<HttpMessageWriter<?>> partWriters, @Nullable HttpMessageWriter<MultiValueMap<String, String>> formWriter) {
        this(() -> partWriters, formWriter);
    }

    public MultipartHttpMessageWriter(Supplier<List<HttpMessageWriter<?>>> partWritersSupplier, @Nullable HttpMessageWriter<MultiValueMap<String, String>> formWriter) {
        super(MultipartHttpMessageWriter.initMediaTypes(formWriter));
        this.partWritersSupplier = partWritersSupplier;
        this.formWriter = formWriter;
    }

    private static List<MediaType> initMediaTypes(@Nullable HttpMessageWriter<?> formWriter) {
        ArrayList<MediaType> result = new ArrayList<MediaType>(MultipartHttpMessageReader.MIME_TYPES);
        if (formWriter != null) {
            result.addAll(formWriter.getWritableMediaTypes());
        }
        return Collections.unmodifiableList(result);
    }

    public List<HttpMessageWriter<?>> getPartWriters() {
        return Collections.unmodifiableList(this.partWritersSupplier.get());
    }

    @Nullable
    public HttpMessageWriter<MultiValueMap<String, String>> getFormWriter() {
        return this.formWriter;
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        if (MultiValueMap.class.isAssignableFrom(elementType.toClass())) {
            if (mediaType == null) {
                return true;
            }
            for (MediaType supportedMediaType : this.getWritableMediaTypes()) {
                if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Mono<Void> write(Publisher<? extends MultiValueMap<String, ?>> inputStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        return Mono.from(inputStream).flatMap(map -> {
            if (this.formWriter == null || this.isMultipart((MultiValueMap<String, ?>)map, mediaType)) {
                return this.writeMultipart((MultiValueMap<String, ?>)map, outputMessage, mediaType, hints);
            }
            Mono input = Mono.just((Object)map);
            return this.formWriter.write((Publisher<MultiValueMap<String, String>>)input, elementType, mediaType, outputMessage, hints);
        });
    }

    private boolean isMultipart(MultiValueMap<String, ?> map, @Nullable MediaType contentType) {
        if (contentType != null) {
            return contentType.getType().equalsIgnoreCase("multipart");
        }
        for (List values : map.values()) {
            for (Object value : values) {
                if (value == null || value instanceof String) continue;
                return true;
            }
        }
        return false;
    }

    private Mono<Void> writeMultipart(MultiValueMap<String, ?> map, ReactiveHttpOutputMessage outputMessage, @Nullable MediaType mediaType, Map<String, Object> hints) {
        byte[] boundary = this.generateMultipartBoundary();
        mediaType = this.getMultipartMediaType(mediaType, boundary);
        outputMessage.getHeaders().setContentType(mediaType);
        LogFormatUtils.traceDebug(this.logger, traceOn -> Hints.getLogPrefix(hints) + "Encoding " + (String)(this.isEnableLoggingRequestDetails() ? LogFormatUtils.formatValue(map, traceOn == false) : "parts " + map.keySet() + " (content masked)"));
        DataBufferFactory bufferFactory = outputMessage.bufferFactory();
        Flux body2 = Flux.fromIterable(map.entrySet()).concatMap(entry -> this.encodePartValues(boundary, (String)entry.getKey(), (List)entry.getValue(), bufferFactory)).concatWith(this.generateLastLine(boundary, bufferFactory)).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
        if (this.logger.isDebugEnabled()) {
            body2 = body2.doOnNext(buffer -> Hints.touchDataBuffer(buffer, hints, this.logger));
        }
        return outputMessage.writeWith((Publisher<? extends DataBuffer>)body2);
    }

    private Flux<DataBuffer> encodePartValues(byte[] boundary, String name, List<?> values, DataBufferFactory bufferFactory) {
        return Flux.fromIterable(values).concatMap(value -> this.encodePart(boundary, name, value, bufferFactory));
    }

    private <T> Flux<DataBuffer> encodePart(byte[] boundary, String name, T value, DataBufferFactory factory) {
        Mono mono;
        Object body2;
        MultipartHttpOutputMessage message = new MultipartHttpOutputMessage(factory);
        HttpHeaders headers = message.getHeaders();
        ResolvableType resolvableType = null;
        if (value instanceof HttpEntity) {
            HttpEntity httpEntity = (HttpEntity)value;
            headers.putAll(httpEntity.getHeaders());
            body2 = httpEntity.getBody();
            Assert.state(body2 != null, "MultipartHttpMessageWriter only supports HttpEntity with body");
            if (httpEntity instanceof ResolvableTypeProvider) {
                ResolvableTypeProvider resolvableTypeProvider = (ResolvableTypeProvider)((Object)httpEntity);
                resolvableType = resolvableTypeProvider.getResolvableType();
            }
        } else {
            body2 = value;
        }
        if (resolvableType == null) {
            resolvableType = ResolvableType.forClass(body2.getClass());
        }
        if (!headers.containsKey("Content-Disposition")) {
            if (body2 instanceof Resource) {
                Resource resource = (Resource)body2;
                headers.setContentDispositionFormData(name, resource.getFilename());
            } else if (resolvableType.resolve() == Resource.class) {
                body2 = Mono.from((Publisher)((Publisher)body2)).doOnNext(o -> headers.setContentDispositionFormData(name, ((Resource)o).getFilename()));
            } else {
                headers.setContentDispositionFormData(name, null);
            }
        }
        MediaType contentType = headers.getContentType();
        ResolvableType finalBodyType = resolvableType;
        Optional<HttpMessageWriter> writer = this.partWritersSupplier.get().stream().filter(partWriter -> partWriter.canWrite(finalBodyType, contentType)).findFirst();
        if (!writer.isPresent()) {
            return Flux.error((Throwable)new CodecException("No suitable writer found for part: " + name));
        }
        if (body2 instanceof Publisher) {
            Publisher publisher = (Publisher)body2;
            mono = publisher;
        } else {
            mono = Mono.just(body2);
        }
        Mono bodyPublisher = mono;
        Mono<Void> partContentReady = writer.get().write(bodyPublisher, resolvableType, contentType, message, DEFAULT_HINTS);
        Flux partContent = partContentReady.thenMany((Publisher)Flux.defer(message::getBody));
        return Flux.concat((Publisher[])new Publisher[]{this.generateBoundaryLine(boundary, factory), partContent, this.generateNewLine(factory)});
    }

    private class MultipartHttpOutputMessage
    implements ReactiveHttpOutputMessage {
        private final DataBufferFactory bufferFactory;
        private final HttpHeaders headers = new HttpHeaders();
        private final AtomicBoolean committed = new AtomicBoolean();
        @Nullable
        private Flux<DataBuffer> body;

        public MultipartHttpOutputMessage(DataBufferFactory bufferFactory) {
            this.bufferFactory = bufferFactory;
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.body != null ? HttpHeaders.readOnlyHttpHeaders(this.headers) : this.headers;
        }

        @Override
        public DataBufferFactory bufferFactory() {
            return this.bufferFactory;
        }

        @Override
        public void beforeCommit(Supplier<? extends Mono<Void>> action) {
            this.committed.set(true);
        }

        @Override
        public boolean isCommitted() {
            return this.committed.get();
        }

        @Override
        public Mono<Void> writeWith(Publisher<? extends DataBuffer> body2) {
            if (this.body != null) {
                return Mono.error((Throwable)new IllegalStateException("Multiple calls to writeWith() not supported"));
            }
            this.body = MultipartHttpMessageWriter.this.generatePartHeaders(this.headers, this.bufferFactory).concatWith(body2);
            return Mono.empty();
        }

        @Override
        public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
            return Mono.error((Throwable)new UnsupportedOperationException());
        }

        public Flux<DataBuffer> getBody() {
            return this.body != null ? this.body : Flux.error((Throwable)new IllegalStateException("Body has not been written yet"));
        }

        @Override
        public Mono<Void> setComplete() {
            return Mono.error((Throwable)new UnsupportedOperationException());
        }
    }
}

