/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.server.reactive;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.springframework.core.log.LogDelegateFactory;
import keycloakjar.org.springframework.http.server.reactive.WriteResultPublisher;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.StringUtils;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AbstractListenerWriteProcessor<T>
implements Processor<T, Void> {
    protected static final Log rsWriteLogger = LogDelegateFactory.getHiddenLog(AbstractListenerWriteProcessor.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNSUBSCRIBED);
    @Nullable
    private Subscription subscription;
    @Nullable
    private volatile T currentData;
    private volatile boolean sourceCompleted;
    private volatile boolean readyToCompleteAfterLastWrite;
    private final WriteResultPublisher resultPublisher;
    private final String logPrefix;

    public AbstractListenerWriteProcessor() {
        this("");
    }

    public AbstractListenerWriteProcessor(String logPrefix) {
        this.resultPublisher = new WriteResultPublisher(logPrefix + "[WP] ", this::cancelAndSetCompleted);
        this.logPrefix = StringUtils.hasText(logPrefix) ? logPrefix : "";
    }

    public String getLogPrefix() {
        return this.logPrefix;
    }

    public final void onSubscribe(Subscription subscription) {
        this.state.get().onSubscribe(this, subscription);
    }

    public final void onNext(T data) {
        if (rsWriteLogger.isTraceEnabled()) {
            rsWriteLogger.trace(this.getLogPrefix() + "onNext: " + data.getClass().getSimpleName());
        }
        this.state.get().onNext(this, data);
    }

    public final void onError(Throwable ex) {
        State state = this.state.get();
        if (rsWriteLogger.isTraceEnabled()) {
            rsWriteLogger.trace(this.getLogPrefix() + "onError: " + ex + " [" + state + "]");
        }
        state.onError(this, ex);
    }

    public final void onComplete() {
        State state = this.state.get();
        if (rsWriteLogger.isTraceEnabled()) {
            rsWriteLogger.trace(this.getLogPrefix() + "onComplete [" + state + "]");
        }
        state.onComplete(this);
    }

    public final void onWritePossible() {
        State state = this.state.get();
        if (rsWriteLogger.isTraceEnabled()) {
            rsWriteLogger.trace(this.getLogPrefix() + "onWritePossible [" + state + "]");
        }
        state.onWritePossible(this);
    }

    public void cancel() {
        if (rsWriteLogger.isTraceEnabled()) {
            rsWriteLogger.trace(this.getLogPrefix() + "cancel [" + this.state + "]");
        }
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    void cancelAndSetCompleted() {
        State prev;
        this.cancel();
        while ((prev = this.state.get()) != State.COMPLETED) {
            if (!this.state.compareAndSet(prev, State.COMPLETED)) continue;
            if (rsWriteLogger.isTraceEnabled()) {
                rsWriteLogger.trace(this.getLogPrefix() + prev + " -> " + this.state);
            }
            if (prev == State.WRITING) break;
            this.discardCurrentData();
            break;
        }
    }

    public final void subscribe(Subscriber<? super Void> subscriber) {
        this.resultPublisher.subscribe(subscriber);
    }

    protected abstract boolean isDataEmpty(T var1);

    protected void dataReceived(T data) {
        T prev = this.currentData;
        if (prev != null) {
            this.discardData(data);
            this.cancel();
            this.onError(new IllegalStateException("Received new data while current not processed yet."));
        }
        this.currentData = data;
    }

    protected abstract boolean isWritePossible();

    protected abstract boolean write(T var1) throws IOException;

    @Deprecated
    protected void writingPaused() {
    }

    protected void writingComplete() {
    }

    protected void writingFailed(Throwable ex) {
    }

    protected abstract void discardData(T var1);

    private boolean changeState(State oldState, State newState) {
        boolean result = this.state.compareAndSet(oldState, newState);
        if (result && rsWriteLogger.isTraceEnabled()) {
            rsWriteLogger.trace(this.getLogPrefix() + oldState + " -> " + newState);
        }
        return result;
    }

    private void changeStateToReceived(State oldState) {
        if (this.changeState(oldState, State.RECEIVED)) {
            this.writeIfPossible();
        }
    }

    private void changeStateToComplete(State oldState) {
        if (this.changeState(oldState, State.COMPLETED)) {
            this.discardCurrentData();
            this.writingComplete();
            this.resultPublisher.publishComplete();
        } else {
            this.state.get().onComplete(this);
        }
    }

    private void writeIfPossible() {
        boolean result = this.isWritePossible();
        if (!result && rsWriteLogger.isTraceEnabled()) {
            rsWriteLogger.trace(this.getLogPrefix() + "isWritePossible false");
        }
        if (result) {
            this.onWritePossible();
        }
    }

    private void discardCurrentData() {
        T data = this.currentData;
        this.currentData = null;
        if (data != null) {
            this.discardData(data);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum State {
        UNSUBSCRIBED{

            @Override
            public <T> void onSubscribe(AbstractListenerWriteProcessor<T> processor, Subscription subscription) {
                Assert.notNull((Object)subscription, "Subscription must not be null");
                if (processor.changeState(this, REQUESTED)) {
                    processor.subscription = subscription;
                    subscription.request(1L);
                } else {
                    super.onSubscribe(processor, subscription);
                }
            }

            @Override
            public <T> void onComplete(AbstractListenerWriteProcessor<T> processor) {
                processor.changeStateToComplete(this);
            }
        }
        ,
        REQUESTED{

            @Override
            public <T> void onNext(AbstractListenerWriteProcessor<T> processor, T data) {
                if (processor.isDataEmpty(data)) {
                    Assert.state(processor.subscription != null, "No subscription");
                    processor.subscription.request(1L);
                } else {
                    processor.dataReceived(data);
                    processor.changeStateToReceived(this);
                }
            }

            @Override
            public <T> void onComplete(AbstractListenerWriteProcessor<T> processor) {
                processor.readyToCompleteAfterLastWrite = true;
                processor.changeStateToReceived(this);
            }
        }
        ,
        RECEIVED{

            @Override
            public <T> void onWritePossible(AbstractListenerWriteProcessor<T> processor) {
                if (processor.readyToCompleteAfterLastWrite) {
                    processor.changeStateToComplete(RECEIVED);
                } else if (processor.changeState(this, WRITING)) {
                    Object data = processor.currentData;
                    Assert.state(data != null, "No data");
                    try {
                        if (processor.write(data)) {
                            if (processor.changeState(WRITING, REQUESTED)) {
                                processor.currentData = null;
                                if (processor.sourceCompleted) {
                                    processor.readyToCompleteAfterLastWrite = true;
                                    processor.changeStateToReceived(REQUESTED);
                                } else {
                                    processor.writingPaused();
                                    Assert.state(processor.subscription != null, "No subscription");
                                    processor.subscription.request(1L);
                                }
                            }
                        } else {
                            processor.changeStateToReceived(WRITING);
                        }
                    }
                    catch (IOException ex) {
                        processor.writingFailed(ex);
                    }
                }
            }

            @Override
            public <T> void onComplete(AbstractListenerWriteProcessor<T> processor) {
                processor.sourceCompleted = true;
                if (processor.state.get() == REQUESTED) {
                    processor.changeStateToComplete(REQUESTED);
                }
            }
        }
        ,
        WRITING{

            @Override
            public <T> void onComplete(AbstractListenerWriteProcessor<T> processor) {
                processor.sourceCompleted = true;
                if (processor.state.get() == REQUESTED) {
                    processor.changeStateToComplete(REQUESTED);
                }
            }
        }
        ,
        COMPLETED{

            @Override
            public <T> void onNext(AbstractListenerWriteProcessor<T> processor, T data) {
            }

            @Override
            public <T> void onError(AbstractListenerWriteProcessor<T> processor, Throwable ex) {
            }

            @Override
            public <T> void onComplete(AbstractListenerWriteProcessor<T> processor) {
            }
        };


        public <T> void onSubscribe(AbstractListenerWriteProcessor<T> processor, Subscription subscription) {
            subscription.cancel();
        }

        public <T> void onNext(AbstractListenerWriteProcessor<T> processor, T data) {
            processor.discardData(data);
            processor.cancel();
            processor.onError(new IllegalStateException("Illegal onNext without demand"));
        }

        public <T> void onError(AbstractListenerWriteProcessor<T> processor, Throwable ex) {
            if (processor.changeState(this, COMPLETED)) {
                processor.discardCurrentData();
                processor.writingComplete();
                processor.resultPublisher.publishError(ex);
            } else {
                processor.state.get().onError(processor, ex);
            }
        }

        public <T> void onComplete(AbstractListenerWriteProcessor<T> processor) {
            throw new IllegalStateException(this.toString());
        }

        public <T> void onWritePossible(AbstractListenerWriteProcessor<T> processor) {
        }
    }
}

