/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.bind.support;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import keycloakjar.org.springframework.beans.MutablePropertyValues;
import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.validation.BindException;
import keycloakjar.org.springframework.web.bind.ServletRequestDataBinder;
import keycloakjar.org.springframework.web.bind.WebDataBinder;
import keycloakjar.org.springframework.web.context.request.NativeWebRequest;
import keycloakjar.org.springframework.web.context.request.WebRequest;
import keycloakjar.org.springframework.web.multipart.MultipartFile;
import keycloakjar.org.springframework.web.multipart.MultipartRequest;
import keycloakjar.org.springframework.web.multipart.support.StandardServletPartUtils;

public class WebRequestDataBinder
extends WebDataBinder {
    public WebRequestDataBinder(@Nullable Object target) {
        super(target);
    }

    public WebRequestDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public void construct(WebRequest request) {
        NativeWebRequest nativeRequest;
        ServletRequest servletRequest;
        if (request instanceof NativeWebRequest && (servletRequest = (nativeRequest = (NativeWebRequest)request).getNativeRequest(ServletRequest.class)) != null) {
            this.construct(ServletRequestDataBinder.valueResolver(servletRequest, this));
        }
    }

    protected boolean shouldConstructArgument(MethodParameter param) {
        Class<?> type = param.nestedIfOptional().getNestedParameterType();
        return super.shouldConstructArgument(param) && !MultipartFile.class.isAssignableFrom(type) && !Part.class.isAssignableFrom(type);
    }

    public void bind(WebRequest request) {
        if (this.shouldNotBindPropertyValues()) {
            return;
        }
        MutablePropertyValues mpvs = new MutablePropertyValues(request.getParameterMap());
        if (request instanceof NativeWebRequest) {
            HttpServletRequest servletRequest;
            NativeWebRequest nativeRequest = (NativeWebRequest)request;
            MultipartRequest multipartRequest = nativeRequest.getNativeRequest(MultipartRequest.class);
            if (multipartRequest != null) {
                this.bindMultipart(multipartRequest.getMultiFileMap(), mpvs);
            } else if (StringUtils.startsWithIgnoreCase(request.getHeader("Content-Type"), "multipart/form-data") && (servletRequest = nativeRequest.getNativeRequest(HttpServletRequest.class)) != null && HttpMethod.POST.matches(servletRequest.getMethod())) {
                StandardServletPartUtils.bindParts(servletRequest, mpvs, this.isBindEmptyMultipartFiles());
            }
        }
        this.doBind(mpvs);
    }

    public void closeNoCatch() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
    }
}

