/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import keycloakjar.com.google.gson.JsonArray;
import keycloakjar.com.google.gson.JsonObject;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.ResponseEntity;
import keycloakjar.org.springframework.util.MultiValueMap;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.web.client.HttpClientErrorException;
import keycloakjar.org.springframework.web.client.RestClientException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.GroupQueryProperty;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.extension.keycloak.CacheableKeycloakGroupQuery;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.KeycloakGroupQuery;
import org.camunda.bpm.extension.keycloak.KeycloakServiceBase;
import org.camunda.bpm.extension.keycloak.KeycloakUserNotFoundException;
import org.camunda.bpm.extension.keycloak.json.JsonException;
import org.camunda.bpm.extension.keycloak.json.JsonUtil;
import org.camunda.bpm.extension.keycloak.rest.KeycloakRestTemplate;
import org.camunda.bpm.extension.keycloak.util.KeycloakPluginLogger;

public class KeycloakGroupService
extends KeycloakServiceBase {
    public KeycloakGroupService(KeycloakConfiguration keycloakConfiguration, KeycloakRestTemplate restTemplate, KeycloakContextProvider keycloakContextProvider) {
        super(keycloakConfiguration, restTemplate, keycloakContextProvider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getKeycloakAdminGroupId(String configuredAdminGroupName) {
        try {
            ResponseEntity<String> response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/group-by-path/" + configuredAdminGroupName, HttpMethod.GET, String.class, new Object[0]);
            if (!this.keycloakConfiguration.isUseGroupPathAsCamundaGroupId()) return JsonUtil.parseAsJsonObjectAndGetMemberAsString((String)response.getBody(), "id");
            return JsonUtil.parseAsJsonObjectAndGetMemberAsString((String)response.getBody(), "path").substring(1);
        }
        catch (RestClientException | JsonException response) {
            try {
                try {
                    ResponseEntity<String> response2 = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/groups?search=" + configuredAdminGroupName, HttpMethod.GET, String.class, new Object[0]);
                    JsonArray result = this.flattenSubGroups(JsonUtil.parseAsJsonArray((String)response2.getBody()), new JsonArray());
                    JsonArray groups = new JsonArray();
                    for (int i = 0; i < result.size(); ++i) {
                        JsonObject keycloakGroup = JsonUtil.getJsonObjectAtIndex(result, i);
                        if (!JsonUtil.getOptJsonString(keycloakGroup, "name").equals(configuredAdminGroupName)) continue;
                        groups.add(keycloakGroup);
                    }
                    if (groups.size() == 1) {
                        if (!this.keycloakConfiguration.isUseGroupPathAsCamundaGroupId()) return JsonUtil.getJsonString(JsonUtil.getJsonObjectAtIndex(groups, 0), "id");
                        return JsonUtil.getJsonString(JsonUtil.getJsonObjectAtIndex(groups, 0), "path").substring(1);
                    }
                    if (groups.size() <= 0) throw new IdentityProviderException("Configured administratorGroupName " + configuredAdminGroupName + " does not exist.");
                    throw new IdentityProviderException("Configured administratorGroupName " + configuredAdminGroupName + " is not unique. Please configure exact group path.");
                }
                catch (JsonException response2) {
                    // empty catch block
                }
                throw new IdentityProviderException("Configured administratorGroupName " + configuredAdminGroupName + " does not exist.");
            }
            catch (RestClientException rce) {
                throw new IdentityProviderException("Unable to read data of configured administratorGroupName " + configuredAdminGroupName, (Throwable)rce);
            }
        }
    }

    public List<Group> requestGroupsByUserId(CacheableKeycloakGroupQuery query) {
        String userId = query.getUserId();
        ArrayList<Group> groupList = new ArrayList<Group>();
        try {
            String keyCloakID;
            try {
                keyCloakID = this.getKeycloakUserID(userId);
            }
            catch (KeycloakUserNotFoundException e) {
                return Collections.emptyList();
            }
            ResponseEntity<String> response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/users/" + keyCloakID + "/groups?max=" + this.getMaxQueryResultSize(), HttpMethod.GET, String.class, new Object[0]);
            if (!response.getStatusCode().equals(HttpStatus.OK)) {
                throw new IdentityProviderException("Unable to read user groups from " + this.keycloakConfiguration.getKeycloakAdminUrl() + ": HTTP status code " + response.getStatusCodeValue());
            }
            JsonArray searchResult = JsonUtil.parseAsJsonArray((String)response.getBody());
            for (int i = 0; i < searchResult.size(); ++i) {
                groupList.add((Group)this.transformGroup(JsonUtil.getJsonObjectAtIndex(searchResult, i)));
            }
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode().equals(HttpStatus.NOT_FOUND)) {
                return Collections.emptyList();
            }
            throw hcee;
        }
        catch (RestClientException | JsonException rce) {
            throw new IdentityProviderException("Unable to query groups of user " + userId, (Throwable)rce);
        }
        return groupList;
    }

    public List<Group> requestGroupsWithoutUserId(CacheableKeycloakGroupQuery query) {
        ArrayList<Group> groupList = new ArrayList<Group>();
        try {
            ResponseEntity<String> response;
            if (StringUtils.hasLength(query.getId())) {
                response = this.requestGroupById(query.getId());
            } else if (query.getIds() != null && query.getIds().length == 1) {
                response = this.requestGroupById(query.getIds()[0]);
            } else {
                String groupFilter = this.createGroupSearchFilter(query);
                response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/groups" + groupFilter, HttpMethod.GET, String.class, new Object[0]);
            }
            if (!response.getStatusCode().equals(HttpStatus.OK)) {
                throw new IdentityProviderException("Unable to read groups from " + this.keycloakConfiguration.getKeycloakAdminUrl() + ": HTTP status code " + response.getStatusCodeValue());
            }
            JsonArray searchResult = StringUtils.hasLength(query.getId()) ? JsonUtil.parseAsJsonArray((String)response.getBody()) : this.flattenSubGroups(JsonUtil.parseAsJsonArray((String)response.getBody()), new JsonArray());
            for (int i = 0; i < searchResult.size(); ++i) {
                groupList.add((Group)this.transformGroup(JsonUtil.getJsonObjectAtIndex(searchResult, i)));
            }
        }
        catch (RestClientException | JsonException rce) {
            throw new IdentityProviderException("Unable to query groups", (Throwable)rce);
        }
        return groupList;
    }

    public List<Group> postProcessResults(KeycloakGroupQuery query, List<Group> groupList, StringBuilder resultLogger) {
        Stream<Group> processed = groupList.stream().filter(group -> this.isValid(query, (Group)group, resultLogger));
        if (query.getOrderingProperties().size() > 0) {
            processed = processed.sorted(new GroupComparator(query.getOrderingProperties()));
        }
        if (query.getFirstResult() > 0 || query.getMaxResults() < Integer.MAX_VALUE) {
            processed = processed.skip(query.getFirstResult()).limit(query.getMaxResults());
        }
        return processed.limit(this.keycloakConfiguration.getMaxResultSize().intValue()).collect(Collectors.toList());
    }

    private boolean isValid(KeycloakGroupQuery query, Group group, StringBuilder resultLogger) {
        if (!this.matches(query.getId(), (Object)group.getId())) {
            return false;
        }
        if (!this.matches(query.getIds(), (Object)group.getId())) {
            return false;
        }
        if (!this.matches(query.getName(), (Object)group.getName())) {
            return false;
        }
        if (!this.matchesLike(query.getNameLike(), group.getName())) {
            return false;
        }
        if (!this.matches(query.getType(), (Object)group.getType())) {
            return false;
        }
        boolean isAuthenticatedUser = this.isAuthenticatedUser(query.getUserId());
        if (isAuthenticatedUser || this.isAuthorized((Permission)Permissions.READ, (Resource)Resources.GROUP, group.getId())) {
            if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
                resultLogger.append(group);
                resultLogger.append(", ");
            }
            return true;
        }
        return false;
    }

    private String createGroupSearchFilter(CacheableKeycloakGroupQuery query) {
        StringBuilder filter2 = new StringBuilder();
        boolean hasSearch = false;
        if (StringUtils.hasLength(query.getName())) {
            hasSearch = true;
            this.addArgument(filter2, "search", query.getName());
        }
        if (StringUtils.hasLength(query.getNameLike())) {
            hasSearch = true;
            this.addArgument(filter2, "search", query.getNameLike().replaceAll("[%,\\*]", ""));
        }
        this.addArgument(filter2, "max", this.getMaxQueryResultSize());
        if (!hasSearch && this.keycloakConfiguration.isEnforceSubgroupsInGroupQuery()) {
            this.addArgument(filter2, "q", ":");
        }
        if (filter2.length() > 0) {
            filter2.insert(0, "?");
            String result = filter2.toString();
            KeycloakPluginLogger.INSTANCE.groupQueryFilter(result);
            return result;
        }
        return "";
    }

    private JsonArray flattenSubGroups(JsonArray groups, JsonArray result) throws JsonException {
        if (groups == null) {
            return result;
        }
        for (int i = 0; i < groups.size(); ++i) {
            JsonObject group = JsonUtil.getJsonObjectAtIndex(groups, i);
            try {
                JsonArray subGroups = JsonUtil.getJsonArray(group, "subGroups");
                group.remove("subGroups");
                result.add(group);
                this.flattenSubGroups(subGroups, result);
                continue;
            }
            catch (JsonException e) {
                result.add(group);
            }
        }
        return result;
    }

    private ResponseEntity<String> requestGroupById(String groupId) throws RestClientException {
        try {
            String groupSearch = this.keycloakConfiguration.isUseGroupPathAsCamundaGroupId() ? "/group-by-path/" + groupId : "/groups/" + groupId;
            ResponseEntity<String> response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + groupSearch, HttpMethod.GET, String.class, new Object[0]);
            String result = "[" + (String)response.getBody() + "]";
            return new ResponseEntity<CallSite>((CallSite)((Object)result), (MultiValueMap<String, String>)response.getHeaders(), response.getStatusCode());
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode().equals(HttpStatus.NOT_FOUND)) {
                String result = "[]";
                return new ResponseEntity<String>(result, (HttpStatusCode)HttpStatus.OK);
            }
            throw hcee;
        }
    }

    private GroupEntity transformGroup(JsonObject result) throws JsonException {
        GroupEntity group = new GroupEntity();
        if (this.keycloakConfiguration.isUseGroupPathAsCamundaGroupId()) {
            group.setId(JsonUtil.getJsonString(result, "path").substring(1));
        } else {
            group.setId(JsonUtil.getJsonString(result, "id"));
        }
        group.setName(JsonUtil.getJsonString(result, "name"));
        if (this.isSystemGroup(result)) {
            group.setType("SYSTEM");
        } else {
            group.setType("WORKFLOW");
        }
        return group;
    }

    private boolean isSystemGroup(JsonObject result) throws JsonException {
        String name = JsonUtil.getJsonString(result, "name");
        if ("camunda-admin".equals(name) || name.equals(this.keycloakConfiguration.getAdministratorGroupName())) {
            return true;
        }
        try {
            JsonArray types = JsonUtil.getJsonArray(JsonUtil.getJsonObject(result, "attributes"), "type");
            for (int i = 0; i < types.size(); ++i) {
                if (!"SYSTEM".equals(JsonUtil.getJsonStringAtIndex(types, i).toUpperCase())) continue;
                return true;
            }
        }
        catch (JsonException ex) {
            return false;
        }
        return false;
    }

    private static class GroupComparator
    implements Comparator<Group> {
        private static final int GROUP_ID = 0;
        private static final int NAME = 1;
        private static final int TYPE = 2;
        private final int[] order;
        private final boolean[] desc;

        public GroupComparator(List<QueryOrderingProperty> orderList) {
            this.order = new int[orderList.size()];
            this.desc = new boolean[orderList.size()];
            for (int i = 0; i < orderList.size(); ++i) {
                QueryOrderingProperty qop = orderList.get(i);
                this.order[i] = qop.getQueryProperty().equals(GroupQueryProperty.GROUP_ID) ? 0 : (qop.getQueryProperty().equals(GroupQueryProperty.NAME) ? 1 : (qop.getQueryProperty().equals(GroupQueryProperty.TYPE) ? 2 : -1));
                this.desc[i] = Direction.DESCENDING.equals(qop.getDirection());
            }
        }

        @Override
        public int compare(Group g1, Group g2) {
            int c = 0;
            for (int i = 0; i < this.order.length; ++i) {
                switch (this.order[i]) {
                    case 0: {
                        c = KeycloakServiceBase.compare(g1.getId(), g2.getId());
                        break;
                    }
                    case 1: {
                        c = KeycloakServiceBase.compare(g1.getName(), g2.getName());
                        break;
                    }
                    case 2: {
                        c = KeycloakServiceBase.compare(g1.getType(), g2.getType());
                        break;
                    }
                }
                if (c == 0) continue;
                return this.desc[i] ? -c : c;
            }
            return c;
        }
    }
}

