/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.configuration.impl;

import java.util.List;
import java.util.Optional;
import org.camunda.bpm.engine.impl.jobexecutor.CallerRunsRejectedJobsHandler;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.RejectedJobsHandler;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.camunda.bpm.engine.spring.components.jobexecutor.SpringJobExecutor;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaJobConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.camunda.bpm.spring.boot.starter.event.JobExecutorStartingEventListener;
import org.camunda.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.camunda.bpm.spring.boot.starter.property.JobExecutionProperty;
import org.camunda.bpm.spring.boot.starter.util.CamundaSpringBootUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DefaultJobConfiguration
extends AbstractCamundaConfiguration
implements CamundaJobConfiguration {
    @Autowired
    protected JobExecutor jobExecutor;
    @Autowired(required=false)
    protected List<JobHandler<?>> customJobHandlers;

    @Override
    public void preInit(SpringProcessEngineConfiguration configuration) {
        this.configureJobExecutor(configuration);
        this.registerCustomJobHandlers(configuration);
    }

    protected void registerCustomJobHandlers(SpringProcessEngineConfiguration configuration) {
        configuration.setCustomJobHandlers(CamundaSpringBootUtil.join(configuration.getCustomJobHandlers(), this.customJobHandlers));
        for (JobHandler jobHandler : configuration.getCustomJobHandlers()) {
            this.logger.info("Register Custom JobHandler: '{}'", (Object)jobHandler.getType());
        }
    }

    protected void configureJobExecutor(SpringProcessEngineConfiguration configuration) {
        configuration.setJobExecutorActivate(false);
        configuration.setJobExecutorDeploymentAware(this.camundaBpmProperties.getJobExecution().isDeploymentAware());
        configuration.setJobExecutor(this.jobExecutor);
    }

    public static class JobConfiguration {
        public static final String CAMUNDA_TASK_EXECUTOR_QUALIFIER = "camundaTaskExecutor";

        @Bean(name={"camundaTaskExecutor"})
        @ConditionalOnMissingBean(name={"camundaTaskExecutor"})
        @ConditionalOnProperty(prefix="camunda.bpm.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public static TaskExecutor camundaTaskExecutor(CamundaBpmProperties properties) {
            int corePoolSize = properties.getJobExecution().getCorePoolSize();
            int maxPoolSize = properties.getJobExecution().getMaxPoolSize();
            int queueCapacity = properties.getJobExecution().getQueueCapacity();
            ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
            threadPoolTaskExecutor.setCorePoolSize(corePoolSize);
            threadPoolTaskExecutor.setMaxPoolSize(maxPoolSize);
            threadPoolTaskExecutor.setQueueCapacity(queueCapacity);
            Optional.ofNullable(properties.getJobExecution().getKeepAliveSeconds()).ifPresent(arg_0 -> ((ThreadPoolTaskExecutor)threadPoolTaskExecutor).setKeepAliveSeconds(arg_0));
            AbstractCamundaConfiguration.LOG.configureJobExecutorPool(corePoolSize, maxPoolSize);
            return threadPoolTaskExecutor;
        }

        @Bean
        @ConditionalOnMissingBean(value={JobExecutor.class})
        @ConditionalOnProperty(prefix="camunda.bpm.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public static JobExecutor jobExecutor(@Qualifier(value="camundaTaskExecutor") TaskExecutor taskExecutor, CamundaBpmProperties properties) {
            SpringJobExecutor springJobExecutor = new SpringJobExecutor();
            springJobExecutor.setTaskExecutor(taskExecutor);
            springJobExecutor.setRejectedJobsHandler((RejectedJobsHandler)new CallerRunsRejectedJobsHandler());
            JobExecutionProperty jobExecution = properties.getJobExecution();
            Optional.ofNullable(jobExecution.getLockTimeInMillis()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setLockTimeInMillis(arg_0));
            Optional.ofNullable(jobExecution.getMaxJobsPerAcquisition()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setMaxJobsPerAcquisition(arg_0));
            Optional.ofNullable(jobExecution.getWaitTimeInMillis()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setWaitTimeInMillis(arg_0));
            Optional.ofNullable(jobExecution.getMaxWait()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setMaxWait(arg_0));
            Optional.ofNullable(jobExecution.getBackoffTimeInMillis()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setBackoffTimeInMillis(arg_0));
            Optional.ofNullable(jobExecution.getMaxBackoff()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setMaxBackoff(arg_0));
            Optional.ofNullable(jobExecution.getBackoffDecreaseThreshold()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setBackoffDecreaseThreshold(arg_0));
            Optional.ofNullable(jobExecution.getWaitIncreaseFactor()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setWaitIncreaseFactor(arg_0));
            return springJobExecutor;
        }

        @Bean
        @ConditionalOnProperty(prefix="camunda.bpm.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnBean(value={JobExecutor.class})
        public static JobExecutorStartingEventListener jobExecutorStartingEventListener() {
            return new JobExecutorStartingEventListener();
        }
    }
}

