/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.util;

import java.net.URL;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.spring.boot.starter.property.GenericProperties;
import org.camunda.bpm.spring.boot.starter.util.SpringBootStarterException;
import org.camunda.commons.logging.BaseLogger;
import org.springframework.core.io.Resource;

public class SpringBootProcessEngineLogger
extends BaseLogger {
    public static final String PROJECT_CODE = "STARTER";
    public static final String PROJECT_ID = "SB";
    public static final String PACKAGE = "org.camunda.bpm.spring.boot";
    public static final SpringBootProcessEngineLogger LOG = (SpringBootProcessEngineLogger)SpringBootProcessEngineLogger.createLogger(SpringBootProcessEngineLogger.class, (String)"STARTER", (String)"org.camunda.bpm.spring.boot", (String)"SB");

    public void creatingInitialAdminUser(User adminUser) {
        this.logDebug("010", "Creating initial Admin User: {}", new Object[]{adminUser});
    }

    public void skipAdminUserCreation(User existingUser) {
        this.logDebug("011", "Skip creating initial Admin User, user does exist: {}", new Object[]{existingUser});
    }

    public void createInitialFilter(Filter filter) {
        this.logInfo("015", "Create initial filter: id={} name={}", new Object[]{filter.getId(), filter.getName()});
    }

    public void skipCreateInitialFilter(String filterName) {
        this.logInfo("016", "Skip initial filter creation, the filter with this name already exists: {}", new Object[]{filterName});
    }

    public void skipAutoDeployment() {
        this.logInfo("020", "ProcessApplication enabled: autoDeployment via springConfiguration#deploymentResourcePattern is disabled", new Object[0]);
    }

    public void autoDeployResources(Set<Resource> resources) {
        Set resourceDescriptions = resources.stream().filter(Objects::nonNull).map(Resource::getDescription).filter(Objects::nonNull).collect(Collectors.toSet());
        this.logInfo("021", "Auto-Deploying resources: {}", new Object[]{resourceDescriptions});
    }

    public void enterLicenseKey(String licenseKeySource) {
        this.logInfo("030", "Setting up license key: {}", new Object[]{licenseKeySource});
    }

    public void enterLicenseKeyFailed(URL licenseKeyFile, Exception e) {
        this.logWarn("031", "Failed setting up license key: {}", new Object[]{licenseKeyFile, e});
    }

    public void configureJobExecutorPool(Integer corePoolSize, Integer maxPoolSize) {
        this.logInfo("040", "Setting up jobExecutor with corePoolSize={}, maxPoolSize:{}", new Object[]{corePoolSize, maxPoolSize});
    }

    public SpringBootStarterException exceptionDuringBinding(String message) {
        return new SpringBootStarterException(this.exceptionMessage("050", message, new Object[0]));
    }

    public void propertiesApplied(GenericProperties genericProperties) {
        this.logDebug("051", "Properties bound to configuration: {}", new Object[]{genericProperties});
    }
}

