/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.AnnotationDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import java.util.Date;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.UserOperationLogEntryDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricUserOperationLogApi {
    private ApiClient localVarApiClient;

    public HistoricUserOperationLogApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricUserOperationLogApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for clearAnnotationUserOperationLog
     * @param operationId The operation id of the operation log to be updated. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the &#x60;operationId&#x60; path parameter value does not exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call clearAnnotationUserOperationLogCall(String operationId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/user-operation/{operationId}/clear-annotation"
            .replaceAll("\\{" + "operationId" + "\\}", localVarApiClient.escapeString(operationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call clearAnnotationUserOperationLogValidateBeforeCall(String operationId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'operationId' is set
        if (operationId == null) {
            throw new ApiException("Missing the required parameter 'operationId' when calling clearAnnotationUserOperationLog(Async)");
        }
        

        okhttp3.Call localVarCall = clearAnnotationUserOperationLogCall(operationId, _callback);
        return localVarCall;

    }

    /**
     * Clear Annotation of an User Operation Log (Historic)
     * Clear the annotation which was previously set for auditing reasons.
     * @param operationId The operation id of the operation log to be updated. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the &#x60;operationId&#x60; path parameter value does not exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void clearAnnotationUserOperationLog(String operationId) throws ApiException {
        clearAnnotationUserOperationLogWithHttpInfo(operationId);
    }

    /**
     * Clear Annotation of an User Operation Log (Historic)
     * Clear the annotation which was previously set for auditing reasons.
     * @param operationId The operation id of the operation log to be updated. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the &#x60;operationId&#x60; path parameter value does not exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> clearAnnotationUserOperationLogWithHttpInfo(String operationId) throws ApiException {
        okhttp3.Call localVarCall = clearAnnotationUserOperationLogValidateBeforeCall(operationId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Clear Annotation of an User Operation Log (Historic) (asynchronously)
     * Clear the annotation which was previously set for auditing reasons.
     * @param operationId The operation id of the operation log to be updated. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the &#x60;operationId&#x60; path parameter value does not exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call clearAnnotationUserOperationLogAsync(String operationId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = clearAnnotationUserOperationLogValidateBeforeCall(operationId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryUserOperationCount
     * @param deploymentId Filter by deployment id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param taskId Only include operations on this task. (optional)
     * @param externalTaskId Only include operations on this external task. (optional)
     * @param batchId Only include operations on this batch. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param userId Only include operations of this user. (optional)
     * @param operationId Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation. (optional)
     * @param operationType Filter by the type of the operation like &#x60;Claim&#x60; or &#x60;Delegate&#x60;. See the [Javadoc](https://docs.camunda.org/manual/7.17/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types. (optional)
     * @param entityType Filter by the type of the entity that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param entityTypeIn Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param category Filter by the category that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param categoryIn Filter by a comma-separated list of categories that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param property Only include operations that changed this property, e.g., &#x60;owner&#x60; or &#x60;assignee&#x60;. (optional)
     * @param afterTimestamp Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param beforeTimestamp Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryUserOperationCountCall(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, Date afterTimestamp, Date beforeTimestamp, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/user-operation/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (deploymentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (caseDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (caseExecutionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseExecutionId", caseExecutionId));
        }

        if (taskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskId", taskId));
        }

        if (externalTaskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("externalTaskId", externalTaskId));
        }

        if (batchId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("batchId", batchId));
        }

        if (jobId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobId", jobId));
        }

        if (jobDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        }

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userId", userId));
        }

        if (operationId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("operationId", operationId));
        }

        if (operationType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("operationType", operationType));
        }

        if (entityType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("entityType", entityType));
        }

        if (entityTypeIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("entityTypeIn", entityTypeIn));
        }

        if (category != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("category", category));
        }

        if (categoryIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("categoryIn", categoryIn));
        }

        if (property != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("property", property));
        }

        if (afterTimestamp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("afterTimestamp", afterTimestamp));
        }

        if (beforeTimestamp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("beforeTimestamp", beforeTimestamp));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryUserOperationCountValidateBeforeCall(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, Date afterTimestamp, Date beforeTimestamp, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryUserOperationCountCall(deploymentId, processDefinitionId, processDefinitionKey, processInstanceId, executionId, caseDefinitionId, caseInstanceId, caseExecutionId, taskId, externalTaskId, batchId, jobId, jobDefinitionId, userId, operationId, operationType, entityType, entityTypeIn, category, categoryIn, property, afterTimestamp, beforeTimestamp, _callback);
        return localVarCall;

    }

    /**
     * Get User Operation Log Count
     * Queries for the number of user operation log entries that fulfill the given parameters. Takes the same parameters as the [Get User Operation Log (Historic)](https://docs.camunda.org/manual/7.17/reference/rest/history/user-operation-log/get-user-operation-log-query/) method.
     * @param deploymentId Filter by deployment id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param taskId Only include operations on this task. (optional)
     * @param externalTaskId Only include operations on this external task. (optional)
     * @param batchId Only include operations on this batch. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param userId Only include operations of this user. (optional)
     * @param operationId Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation. (optional)
     * @param operationType Filter by the type of the operation like &#x60;Claim&#x60; or &#x60;Delegate&#x60;. See the [Javadoc](https://docs.camunda.org/manual/7.17/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types. (optional)
     * @param entityType Filter by the type of the entity that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param entityTypeIn Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param category Filter by the category that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param categoryIn Filter by a comma-separated list of categories that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param property Only include operations that changed this property, e.g., &#x60;owner&#x60; or &#x60;assignee&#x60;. (optional)
     * @param afterTimestamp Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param beforeTimestamp Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto queryUserOperationCount(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, Date afterTimestamp, Date beforeTimestamp) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = queryUserOperationCountWithHttpInfo(deploymentId, processDefinitionId, processDefinitionKey, processInstanceId, executionId, caseDefinitionId, caseInstanceId, caseExecutionId, taskId, externalTaskId, batchId, jobId, jobDefinitionId, userId, operationId, operationType, entityType, entityTypeIn, category, categoryIn, property, afterTimestamp, beforeTimestamp);
        return localVarResp.getData();
    }

    /**
     * Get User Operation Log Count
     * Queries for the number of user operation log entries that fulfill the given parameters. Takes the same parameters as the [Get User Operation Log (Historic)](https://docs.camunda.org/manual/7.17/reference/rest/history/user-operation-log/get-user-operation-log-query/) method.
     * @param deploymentId Filter by deployment id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param taskId Only include operations on this task. (optional)
     * @param externalTaskId Only include operations on this external task. (optional)
     * @param batchId Only include operations on this batch. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param userId Only include operations of this user. (optional)
     * @param operationId Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation. (optional)
     * @param operationType Filter by the type of the operation like &#x60;Claim&#x60; or &#x60;Delegate&#x60;. See the [Javadoc](https://docs.camunda.org/manual/7.17/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types. (optional)
     * @param entityType Filter by the type of the entity that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param entityTypeIn Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param category Filter by the category that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param categoryIn Filter by a comma-separated list of categories that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param property Only include operations that changed this property, e.g., &#x60;owner&#x60; or &#x60;assignee&#x60;. (optional)
     * @param afterTimestamp Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param beforeTimestamp Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> queryUserOperationCountWithHttpInfo(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, Date afterTimestamp, Date beforeTimestamp) throws ApiException {
        okhttp3.Call localVarCall = queryUserOperationCountValidateBeforeCall(deploymentId, processDefinitionId, processDefinitionKey, processInstanceId, executionId, caseDefinitionId, caseInstanceId, caseExecutionId, taskId, externalTaskId, batchId, jobId, jobDefinitionId, userId, operationId, operationType, entityType, entityTypeIn, category, categoryIn, property, afterTimestamp, beforeTimestamp, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get User Operation Log Count (asynchronously)
     * Queries for the number of user operation log entries that fulfill the given parameters. Takes the same parameters as the [Get User Operation Log (Historic)](https://docs.camunda.org/manual/7.17/reference/rest/history/user-operation-log/get-user-operation-log-query/) method.
     * @param deploymentId Filter by deployment id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param taskId Only include operations on this task. (optional)
     * @param externalTaskId Only include operations on this external task. (optional)
     * @param batchId Only include operations on this batch. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param userId Only include operations of this user. (optional)
     * @param operationId Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation. (optional)
     * @param operationType Filter by the type of the operation like &#x60;Claim&#x60; or &#x60;Delegate&#x60;. See the [Javadoc](https://docs.camunda.org/manual/7.17/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types. (optional)
     * @param entityType Filter by the type of the entity that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param entityTypeIn Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param category Filter by the category that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param categoryIn Filter by a comma-separated list of categories that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param property Only include operations that changed this property, e.g., &#x60;owner&#x60; or &#x60;assignee&#x60;. (optional)
     * @param afterTimestamp Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param beforeTimestamp Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryUserOperationCountAsync(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, Date afterTimestamp, Date beforeTimestamp, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryUserOperationCountValidateBeforeCall(deploymentId, processDefinitionId, processDefinitionKey, processInstanceId, executionId, caseDefinitionId, caseInstanceId, caseExecutionId, taskId, externalTaskId, batchId, jobId, jobDefinitionId, userId, operationId, operationType, entityType, entityTypeIn, category, categoryIn, property, afterTimestamp, beforeTimestamp, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryUserOperationEntries
     * @param deploymentId Filter by deployment id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param taskId Only include operations on this task. (optional)
     * @param externalTaskId Only include operations on this external task. (optional)
     * @param batchId Only include operations on this batch. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param userId Only include operations of this user. (optional)
     * @param operationId Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation. (optional)
     * @param operationType Filter by the type of the operation like &#x60;Claim&#x60; or &#x60;Delegate&#x60;. See the [Javadoc](https://docs.camunda.org/manual/7.17/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types. (optional)
     * @param entityType Filter by the type of the entity that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param entityTypeIn Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param category Filter by the category that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param categoryIn Filter by a comma-separated list of categories that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param property Only include operations that changed this property, e.g., &#x60;owner&#x60; or &#x60;assignee&#x60;. (optional)
     * @param afterTimestamp Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param beforeTimestamp Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryUserOperationEntriesCall(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, Date afterTimestamp, Date beforeTimestamp, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/user-operation";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (deploymentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (caseDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseDefinitionId", caseDefinitionId));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (caseExecutionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseExecutionId", caseExecutionId));
        }

        if (taskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskId", taskId));
        }

        if (externalTaskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("externalTaskId", externalTaskId));
        }

        if (batchId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("batchId", batchId));
        }

        if (jobId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobId", jobId));
        }

        if (jobDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        }

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userId", userId));
        }

        if (operationId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("operationId", operationId));
        }

        if (operationType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("operationType", operationType));
        }

        if (entityType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("entityType", entityType));
        }

        if (entityTypeIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("entityTypeIn", entityTypeIn));
        }

        if (category != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("category", category));
        }

        if (categoryIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("categoryIn", categoryIn));
        }

        if (property != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("property", property));
        }

        if (afterTimestamp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("afterTimestamp", afterTimestamp));
        }

        if (beforeTimestamp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("beforeTimestamp", beforeTimestamp));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryUserOperationEntriesValidateBeforeCall(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, Date afterTimestamp, Date beforeTimestamp, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryUserOperationEntriesCall(deploymentId, processDefinitionId, processDefinitionKey, processInstanceId, executionId, caseDefinitionId, caseInstanceId, caseExecutionId, taskId, externalTaskId, batchId, jobId, jobDefinitionId, userId, operationId, operationType, entityType, entityTypeIn, category, categoryIn, property, afterTimestamp, beforeTimestamp, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get User Operation Log (Historic)
     * Queries for user operation log entries that fulfill the given parameters. The size of the result set can be retrieved by using the [Get User Operation Log Count](https://docs.camunda.org/manual/7.17/reference/rest/history/user-operation-log/get-user-operation-log-query-count/) method.  Note that the properties of operation log entries are interpreted as restrictions on the entities they apply to. That means, if a single process instance is updated, the field &#x60;processInstanceId&#x60; is populated. If a single operation updates all process instances of the same process definition, the field &#x60;processInstanceId&#x60; is &#x60;null&#x60; (a &#x60;null&#x60; restriction is viewed as a wildcard, i.e., matches a process instance with any id) and the field &#x60;processDefinitionId&#x60; is populated. This way, which entities were changed by a user operation can easily be reconstructed.
     * @param deploymentId Filter by deployment id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param taskId Only include operations on this task. (optional)
     * @param externalTaskId Only include operations on this external task. (optional)
     * @param batchId Only include operations on this batch. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param userId Only include operations of this user. (optional)
     * @param operationId Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation. (optional)
     * @param operationType Filter by the type of the operation like &#x60;Claim&#x60; or &#x60;Delegate&#x60;. See the [Javadoc](https://docs.camunda.org/manual/7.17/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types. (optional)
     * @param entityType Filter by the type of the entity that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param entityTypeIn Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param category Filter by the category that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param categoryIn Filter by a comma-separated list of categories that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param property Only include operations that changed this property, e.g., &#x60;owner&#x60; or &#x60;assignee&#x60;. (optional)
     * @param afterTimestamp Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param beforeTimestamp Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;UserOperationLogEntryDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<UserOperationLogEntryDto> queryUserOperationEntries(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, Date afterTimestamp, Date beforeTimestamp, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<UserOperationLogEntryDto>> localVarResp = queryUserOperationEntriesWithHttpInfo(deploymentId, processDefinitionId, processDefinitionKey, processInstanceId, executionId, caseDefinitionId, caseInstanceId, caseExecutionId, taskId, externalTaskId, batchId, jobId, jobDefinitionId, userId, operationId, operationType, entityType, entityTypeIn, category, categoryIn, property, afterTimestamp, beforeTimestamp, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get User Operation Log (Historic)
     * Queries for user operation log entries that fulfill the given parameters. The size of the result set can be retrieved by using the [Get User Operation Log Count](https://docs.camunda.org/manual/7.17/reference/rest/history/user-operation-log/get-user-operation-log-query-count/) method.  Note that the properties of operation log entries are interpreted as restrictions on the entities they apply to. That means, if a single process instance is updated, the field &#x60;processInstanceId&#x60; is populated. If a single operation updates all process instances of the same process definition, the field &#x60;processInstanceId&#x60; is &#x60;null&#x60; (a &#x60;null&#x60; restriction is viewed as a wildcard, i.e., matches a process instance with any id) and the field &#x60;processDefinitionId&#x60; is populated. This way, which entities were changed by a user operation can easily be reconstructed.
     * @param deploymentId Filter by deployment id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param taskId Only include operations on this task. (optional)
     * @param externalTaskId Only include operations on this external task. (optional)
     * @param batchId Only include operations on this batch. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param userId Only include operations of this user. (optional)
     * @param operationId Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation. (optional)
     * @param operationType Filter by the type of the operation like &#x60;Claim&#x60; or &#x60;Delegate&#x60;. See the [Javadoc](https://docs.camunda.org/manual/7.17/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types. (optional)
     * @param entityType Filter by the type of the entity that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param entityTypeIn Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param category Filter by the category that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param categoryIn Filter by a comma-separated list of categories that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param property Only include operations that changed this property, e.g., &#x60;owner&#x60; or &#x60;assignee&#x60;. (optional)
     * @param afterTimestamp Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param beforeTimestamp Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;UserOperationLogEntryDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<UserOperationLogEntryDto>> queryUserOperationEntriesWithHttpInfo(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, Date afterTimestamp, Date beforeTimestamp, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = queryUserOperationEntriesValidateBeforeCall(deploymentId, processDefinitionId, processDefinitionKey, processInstanceId, executionId, caseDefinitionId, caseInstanceId, caseExecutionId, taskId, externalTaskId, batchId, jobId, jobDefinitionId, userId, operationId, operationType, entityType, entityTypeIn, category, categoryIn, property, afterTimestamp, beforeTimestamp, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<UserOperationLogEntryDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get User Operation Log (Historic) (asynchronously)
     * Queries for user operation log entries that fulfill the given parameters. The size of the result set can be retrieved by using the [Get User Operation Log Count](https://docs.camunda.org/manual/7.17/reference/rest/history/user-operation-log/get-user-operation-log-query-count/) method.  Note that the properties of operation log entries are interpreted as restrictions on the entities they apply to. That means, if a single process instance is updated, the field &#x60;processInstanceId&#x60; is populated. If a single operation updates all process instances of the same process definition, the field &#x60;processInstanceId&#x60; is &#x60;null&#x60; (a &#x60;null&#x60; restriction is viewed as a wildcard, i.e., matches a process instance with any id) and the field &#x60;processDefinitionId&#x60; is populated. This way, which entities were changed by a user operation can easily be reconstructed.
     * @param deploymentId Filter by deployment id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param caseDefinitionId Filter by case definition id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param taskId Only include operations on this task. (optional)
     * @param externalTaskId Only include operations on this external task. (optional)
     * @param batchId Only include operations on this batch. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param userId Only include operations of this user. (optional)
     * @param operationId Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation. (optional)
     * @param operationType Filter by the type of the operation like &#x60;Claim&#x60; or &#x60;Delegate&#x60;. See the [Javadoc](https://docs.camunda.org/manual/7.17/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types. (optional)
     * @param entityType Filter by the type of the entity that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param entityTypeIn Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are &#x60;Task&#x60;, &#x60;Attachment&#x60; or &#x60;IdentityLink&#x60;. (optional)
     * @param category Filter by the category that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param categoryIn Filter by a comma-separated list of categories that this operation is associated with, possible values are &#x60;TaskWorker&#x60;, &#x60;Admin&#x60; or &#x60;Operator&#x60;. (optional)
     * @param property Only include operations that changed this property, e.g., &#x60;owner&#x60; or &#x60;assignee&#x60;. (optional)
     * @param afterTimestamp Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param beforeTimestamp Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the timestamp must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryUserOperationEntriesAsync(String deploymentId, String processDefinitionId, String processDefinitionKey, String processInstanceId, String executionId, String caseDefinitionId, String caseInstanceId, String caseExecutionId, String taskId, String externalTaskId, String batchId, String jobId, String jobDefinitionId, String userId, String operationId, String operationType, String entityType, String entityTypeIn, String category, String categoryIn, String property, Date afterTimestamp, Date beforeTimestamp, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<UserOperationLogEntryDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryUserOperationEntriesValidateBeforeCall(deploymentId, processDefinitionId, processDefinitionKey, processInstanceId, executionId, caseDefinitionId, caseInstanceId, caseExecutionId, taskId, externalTaskId, batchId, jobId, jobDefinitionId, userId, operationId, operationType, entityType, entityTypeIn, category, categoryIn, property, afterTimestamp, beforeTimestamp, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<UserOperationLogEntryDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for setAnnotationUserOperationLog
     * @param operationId The operation id of the operation log to be updated. (required)
     * @param annotationDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the &#x60;operationId&#x60; path parameter value does not exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setAnnotationUserOperationLogCall(String operationId, AnnotationDto annotationDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = annotationDto;

        // create path and map variables
        String localVarPath = "/history/user-operation/{operationId}/set-annotation"
            .replaceAll("\\{" + "operationId" + "\\}", localVarApiClient.escapeString(operationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setAnnotationUserOperationLogValidateBeforeCall(String operationId, AnnotationDto annotationDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'operationId' is set
        if (operationId == null) {
            throw new ApiException("Missing the required parameter 'operationId' when calling setAnnotationUserOperationLog(Async)");
        }
        

        okhttp3.Call localVarCall = setAnnotationUserOperationLogCall(operationId, annotationDto, _callback);
        return localVarCall;

    }

    /**
     * Set Annotation to an User Operation Log (Historic)
     * Set an annotation for auditing reasons.
     * @param operationId The operation id of the operation log to be updated. (required)
     * @param annotationDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the &#x60;operationId&#x60; path parameter value does not exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void setAnnotationUserOperationLog(String operationId, AnnotationDto annotationDto) throws ApiException {
        setAnnotationUserOperationLogWithHttpInfo(operationId, annotationDto);
    }

    /**
     * Set Annotation to an User Operation Log (Historic)
     * Set an annotation for auditing reasons.
     * @param operationId The operation id of the operation log to be updated. (required)
     * @param annotationDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the &#x60;operationId&#x60; path parameter value does not exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> setAnnotationUserOperationLogWithHttpInfo(String operationId, AnnotationDto annotationDto) throws ApiException {
        okhttp3.Call localVarCall = setAnnotationUserOperationLogValidateBeforeCall(operationId, annotationDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Set Annotation to an User Operation Log (Historic) (asynchronously)
     * Set an annotation for auditing reasons.
     * @param operationId The operation id of the operation log to be updated. (required)
     * @param annotationDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the request parameters are invalid, for example if the &#x60;operationId&#x60; path parameter value does not exists. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setAnnotationUserOperationLogAsync(String operationId, AnnotationDto annotationDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = setAnnotationUserOperationLogValidateBeforeCall(operationId, annotationDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
