/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * MultipleProcessInstanceModificationInstructionDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-23T14:22:53.022768Z[Etc/UTC]")
public class MultipleProcessInstanceModificationInstructionDto {
  /**
   * **Mandatory**. One of the following values: &#x60;cancel&#x60;, &#x60;startBeforeActivity&#x60;, &#x60;startAfterActivity&#x60;, &#x60;startTransition&#x60;.  * A cancel instruction requests cancellation of a single activity instance or all instances of one activity. * A startBeforeActivity instruction requests to enter a given activity. * A startAfterActivity instruction requests to execute the single outgoing sequence flow of a given activity. * A startTransition instruction requests to execute a specific sequence flow.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    CANCEL("cancel"),
    
    STARTBEFOREACTIVITY("startBeforeActivity"),
    
    STARTAFTERACTIVITY("startAfterActivity"),
    
    STARTTRANSITION("startTransition");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_ID)
  private String activityId;

  public static final String SERIALIZED_NAME_TRANSITION_ID = "transitionId";
  @SerializedName(SERIALIZED_NAME_TRANSITION_ID)
  private String transitionId;

  public static final String SERIALIZED_NAME_CANCEL_CURRENT_ACTIVE_ACTIVITY_INSTANCES = "cancelCurrentActiveActivityInstances";
  @SerializedName(SERIALIZED_NAME_CANCEL_CURRENT_ACTIVE_ACTIVITY_INSTANCES)
  private Boolean cancelCurrentActiveActivityInstances;


  public MultipleProcessInstanceModificationInstructionDto type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * **Mandatory**. One of the following values: &#x60;cancel&#x60;, &#x60;startBeforeActivity&#x60;, &#x60;startAfterActivity&#x60;, &#x60;startTransition&#x60;.  * A cancel instruction requests cancellation of a single activity instance or all instances of one activity. * A startBeforeActivity instruction requests to enter a given activity. * A startAfterActivity instruction requests to execute the single outgoing sequence flow of a given activity. * A startTransition instruction requests to execute a specific sequence flow.
   * @return type
  **/
  @ApiModelProperty(required = true, value = "**Mandatory**. One of the following values: `cancel`, `startBeforeActivity`, `startAfterActivity`, `startTransition`.  * A cancel instruction requests cancellation of a single activity instance or all instances of one activity. * A startBeforeActivity instruction requests to enter a given activity. * A startAfterActivity instruction requests to execute the single outgoing sequence flow of a given activity. * A startTransition instruction requests to execute a specific sequence flow.")

  public TypeEnum getType() {
    return type;
  }


  public void setType(TypeEnum type) {
    this.type = type;
  }


  public MultipleProcessInstanceModificationInstructionDto activityId(String activityId) {
    
    this.activityId = activityId;
    return this;
  }

   /**
   * Can be used with instructions of types &#x60;startTransition&#x60;. Specifies the sequence flow to start.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Can be used with instructions of types `startTransition`. Specifies the sequence flow to start.")

  public String getActivityId() {
    return activityId;
  }


  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }


  public MultipleProcessInstanceModificationInstructionDto transitionId(String transitionId) {
    
    this.transitionId = transitionId;
    return this;
  }

   /**
   * Can be used with instructions of types &#x60;startTransition&#x60;. Specifies the sequence flow to start.
   * @return transitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Can be used with instructions of types `startTransition`. Specifies the sequence flow to start.")

  public String getTransitionId() {
    return transitionId;
  }


  public void setTransitionId(String transitionId) {
    this.transitionId = transitionId;
  }


  public MultipleProcessInstanceModificationInstructionDto cancelCurrentActiveActivityInstances(Boolean cancelCurrentActiveActivityInstances) {
    
    this.cancelCurrentActiveActivityInstances = cancelCurrentActiveActivityInstances;
    return this;
  }

   /**
   * Can be used with instructions of type cancel. Prevents the deletion of new created activity instances.
   * @return cancelCurrentActiveActivityInstances
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Can be used with instructions of type cancel. Prevents the deletion of new created activity instances.")

  public Boolean getCancelCurrentActiveActivityInstances() {
    return cancelCurrentActiveActivityInstances;
  }


  public void setCancelCurrentActiveActivityInstances(Boolean cancelCurrentActiveActivityInstances) {
    this.cancelCurrentActiveActivityInstances = cancelCurrentActiveActivityInstances;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MultipleProcessInstanceModificationInstructionDto multipleProcessInstanceModificationInstructionDto = (MultipleProcessInstanceModificationInstructionDto) o;
    return Objects.equals(this.type, multipleProcessInstanceModificationInstructionDto.type) &&
        Objects.equals(this.activityId, multipleProcessInstanceModificationInstructionDto.activityId) &&
        Objects.equals(this.transitionId, multipleProcessInstanceModificationInstructionDto.transitionId) &&
        Objects.equals(this.cancelCurrentActiveActivityInstances, multipleProcessInstanceModificationInstructionDto.cancelCurrentActiveActivityInstances);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, activityId, transitionId, cancelCurrentActiveActivityInstances);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MultipleProcessInstanceModificationInstructionDto {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    transitionId: ").append(toIndentedString(transitionId)).append("\n");
    sb.append("    cancelCurrentActiveActivityInstances: ").append(toIndentedString(cancelCurrentActiveActivityInstances)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

