/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.AnnotationDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.IncidentDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class IncidentApi {
    private ApiClient localVarApiClient;

    public IncidentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IncidentApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call clearIncidentAnnotationCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/incident/{id}/annotation".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call clearIncidentAnnotationValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling clearIncidentAnnotation(Async)");
        }
        Call localVarCall = this.clearIncidentAnnotationCall(id, _callback);
        return localVarCall;
    }

    public void clearIncidentAnnotation(String id) throws ApiException {
        this.clearIncidentAnnotationWithHttpInfo(id);
    }

    public ApiResponse<Void> clearIncidentAnnotationWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.clearIncidentAnnotationValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call clearIncidentAnnotationAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.clearIncidentAnnotationValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getIncidentCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/incident/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getIncidentValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getIncident(Async)");
        }
        Call localVarCall = this.getIncidentCall(id, _callback);
        return localVarCall;
    }

    public IncidentDto getIncident(String id) throws ApiException {
        ApiResponse<IncidentDto> localVarResp = this.getIncidentWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<IncidentDto> getIncidentWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getIncidentValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<IncidentDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIncidentAsync(String id, ApiCallback<IncidentDto> _callback) throws ApiException {
        Call localVarCall = this.getIncidentValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<IncidentDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getIncidentsCall(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/incident";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (incidentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentId", incidentId));
        }
        if (incidentType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentType", incidentType));
        }
        if (incidentMessage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }
        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }
        if (processInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }
        if (executionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executionId", executionId));
        }
        if (incidentTimestampBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentTimestampBefore", incidentTimestampBefore));
        }
        if (incidentTimestampAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentTimestampAfter", incidentTimestampAfter));
        }
        if (activityId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityId", activityId));
        }
        if (failedActivityId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("failedActivityId", failedActivityId));
        }
        if (causeIncidentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("causeIncidentId", causeIncidentId));
        }
        if (rootCauseIncidentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rootCauseIncidentId", rootCauseIncidentId));
        }
        if (_configuration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("configuration", _configuration));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (jobDefinitionIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobDefinitionIdIn", jobDefinitionIdIn));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getIncidentsValidateBeforeCall(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getIncidentsCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<IncidentDto> getIncidents(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<IncidentDto>> localVarResp = this.getIncidentsWithHttpInfo(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<IncidentDto>> getIncidentsWithHttpInfo(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getIncidentsValidateBeforeCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<IncidentDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIncidentsAsync(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<IncidentDto>> _callback) throws ApiException {
        Call localVarCall = this.getIncidentsValidateBeforeCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<IncidentDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getIncidentsCountCall(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/incident/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (incidentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentId", incidentId));
        }
        if (incidentType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentType", incidentType));
        }
        if (incidentMessage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }
        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }
        if (processInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }
        if (executionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executionId", executionId));
        }
        if (incidentTimestampBefore != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentTimestampBefore", incidentTimestampBefore));
        }
        if (incidentTimestampAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentTimestampAfter", incidentTimestampAfter));
        }
        if (activityId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityId", activityId));
        }
        if (failedActivityId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("failedActivityId", failedActivityId));
        }
        if (causeIncidentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("causeIncidentId", causeIncidentId));
        }
        if (rootCauseIncidentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rootCauseIncidentId", rootCauseIncidentId));
        }
        if (_configuration != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("configuration", _configuration));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (jobDefinitionIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobDefinitionIdIn", jobDefinitionIdIn));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getIncidentsCountValidateBeforeCall(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getIncidentsCountCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, _callback);
        return localVarCall;
    }

    public CountResultDto getIncidentsCount(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getIncidentsCountWithHttpInfo(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getIncidentsCountWithHttpInfo(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn) throws ApiException {
        Call localVarCall = this.getIncidentsCountValidateBeforeCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIncidentsCountAsync(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getIncidentsCountValidateBeforeCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resolveIncidentCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/incident/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resolveIncidentValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling resolveIncident(Async)");
        }
        Call localVarCall = this.resolveIncidentCall(id, _callback);
        return localVarCall;
    }

    public void resolveIncident(String id) throws ApiException {
        this.resolveIncidentWithHttpInfo(id);
    }

    public ApiResponse<Void> resolveIncidentWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.resolveIncidentValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call resolveIncidentAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.resolveIncidentValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setIncidentAnnotationCall(String id, AnnotationDto annotationDto, ApiCallback _callback) throws ApiException {
        AnnotationDto localVarPostBody = annotationDto;
        String localVarPath = "/incident/{id}/annotation".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setIncidentAnnotationValidateBeforeCall(String id, AnnotationDto annotationDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setIncidentAnnotation(Async)");
        }
        Call localVarCall = this.setIncidentAnnotationCall(id, annotationDto, _callback);
        return localVarCall;
    }

    public void setIncidentAnnotation(String id, AnnotationDto annotationDto) throws ApiException {
        this.setIncidentAnnotationWithHttpInfo(id, annotationDto);
    }

    public ApiResponse<Void> setIncidentAnnotationWithHttpInfo(String id, AnnotationDto annotationDto) throws ApiException {
        Call localVarCall = this.setIncidentAnnotationValidateBeforeCall(id, annotationDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setIncidentAnnotationAsync(String id, AnnotationDto annotationDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setIncidentAnnotationValidateBeforeCall(id, annotationDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

