/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.AtomLink;

public class DeploymentDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_DEPLOYMENT_TIME = "deploymentTime";
    @SerializedName(value="deploymentTime")
    private Date deploymentTime;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private String source;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private List<AtomLink> links = null;

    public DeploymentDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the deployment.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DeploymentDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tenant id of the deployment.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public DeploymentDto deploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when the deployment was created.")
    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public DeploymentDto source(String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source of the deployment.")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public DeploymentDto name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the deployment.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeploymentDto links(List<AtomLink> links) {
        this.links = links;
        return this;
    }

    public DeploymentDto addLinksItem(AtomLink linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<AtomLink>();
        }
        this.links.add(linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The links associated to this resource, with `method`, `href` and `rel`.")
    public List<AtomLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<AtomLink> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentDto deploymentDto = (DeploymentDto)o;
        return Objects.equals(this.id, deploymentDto.id) && Objects.equals(this.tenantId, deploymentDto.tenantId) && Objects.equals(this.deploymentTime, deploymentDto.deploymentTime) && Objects.equals(this.source, deploymentDto.source) && Objects.equals(this.name, deploymentDto.name) && Objects.equals(this.links, deploymentDto.links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tenantId, this.deploymentTime, this.source, this.name, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeploymentDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    deploymentTime: ").append(this.toIndentedString(this.deploymentTime)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

