/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class HistoricActivityStatisticsDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_INSTANCES = "instances";
    @SerializedName(value="instances")
    private Long instances;
    public static final String SERIALIZED_NAME_CANCELED = "canceled";
    @SerializedName(value="canceled")
    private Long canceled;
    public static final String SERIALIZED_NAME_FINISHED = "finished";
    @SerializedName(value="finished")
    private Long finished;
    public static final String SERIALIZED_NAME_COMPLETE_SCOPE = "completeScope";
    @SerializedName(value="completeScope")
    private Long completeScope;
    public static final String SERIALIZED_NAME_OPEN_INCIDENTS = "openIncidents";
    @SerializedName(value="openIncidents")
    private Long openIncidents;
    public static final String SERIALIZED_NAME_RESOLVED_INCIDENTS = "resolvedIncidents";
    @SerializedName(value="resolvedIncidents")
    private Long resolvedIncidents;
    public static final String SERIALIZED_NAME_DELETED_INCIDENTS = "deletedIncidents";
    @SerializedName(value="deletedIncidents")
    private Long deletedIncidents;

    public HistoricActivityStatisticsDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity the results are aggregated for.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HistoricActivityStatisticsDto instances(Long instances) {
        this.instances = instances;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of all running instances of the activity.")
    public Long getInstances() {
        return this.instances;
    }

    public void setInstances(Long instances) {
        this.instances = instances;
    }

    public HistoricActivityStatisticsDto canceled(Long canceled) {
        this.canceled = canceled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of all canceled instances of the activity. **Note:** Will be `0` (not `null`), if canceled activity instances were excluded.")
    public Long getCanceled() {
        return this.canceled;
    }

    public void setCanceled(Long canceled) {
        this.canceled = canceled;
    }

    public HistoricActivityStatisticsDto finished(Long finished) {
        this.finished = finished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of all finished instances of the activity. **Note:** Will be `0` (not `null`), if finished activity instances were excluded.")
    public Long getFinished() {
        return this.finished;
    }

    public void setFinished(Long finished) {
        this.finished = finished;
    }

    public HistoricActivityStatisticsDto completeScope(Long completeScope) {
        this.completeScope = completeScope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of all instances which completed a scope of the activity. **Note:** Will be `0` (not `null`), if activity instances which completed a scope were excluded.")
    public Long getCompleteScope() {
        return this.completeScope;
    }

    public void setCompleteScope(Long completeScope) {
        this.completeScope = completeScope;
    }

    public HistoricActivityStatisticsDto openIncidents(Long openIncidents) {
        this.openIncidents = openIncidents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of open incidents for the activity. **Note:** Will be `0` (not `null`), if `incidents` is set to `false`.")
    public Long getOpenIncidents() {
        return this.openIncidents;
    }

    public void setOpenIncidents(Long openIncidents) {
        this.openIncidents = openIncidents;
    }

    public HistoricActivityStatisticsDto resolvedIncidents(Long resolvedIncidents) {
        this.resolvedIncidents = resolvedIncidents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of resolved incidents for the activity. **Note:** Will be `0` (not `null`), if `incidents` is set to `false`.")
    public Long getResolvedIncidents() {
        return this.resolvedIncidents;
    }

    public void setResolvedIncidents(Long resolvedIncidents) {
        this.resolvedIncidents = resolvedIncidents;
    }

    public HistoricActivityStatisticsDto deletedIncidents(Long deletedIncidents) {
        this.deletedIncidents = deletedIncidents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of deleted incidents for the activity. **Note:** Will be `0` (not `null`), if `incidents` is set to `false`.")
    public Long getDeletedIncidents() {
        return this.deletedIncidents;
    }

    public void setDeletedIncidents(Long deletedIncidents) {
        this.deletedIncidents = deletedIncidents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricActivityStatisticsDto historicActivityStatisticsDto = (HistoricActivityStatisticsDto)o;
        return Objects.equals(this.id, historicActivityStatisticsDto.id) && Objects.equals(this.instances, historicActivityStatisticsDto.instances) && Objects.equals(this.canceled, historicActivityStatisticsDto.canceled) && Objects.equals(this.finished, historicActivityStatisticsDto.finished) && Objects.equals(this.completeScope, historicActivityStatisticsDto.completeScope) && Objects.equals(this.openIncidents, historicActivityStatisticsDto.openIncidents) && Objects.equals(this.resolvedIncidents, historicActivityStatisticsDto.resolvedIncidents) && Objects.equals(this.deletedIncidents, historicActivityStatisticsDto.deletedIncidents);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.instances, this.canceled, this.finished, this.completeScope, this.openIncidents, this.resolvedIncidents, this.deletedIncidents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricActivityStatisticsDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    instances: ").append(this.toIndentedString(this.instances)).append("\n");
        sb.append("    canceled: ").append(this.toIndentedString(this.canceled)).append("\n");
        sb.append("    finished: ").append(this.toIndentedString(this.finished)).append("\n");
        sb.append("    completeScope: ").append(this.toIndentedString(this.completeScope)).append("\n");
        sb.append("    openIncidents: ").append(this.toIndentedString(this.openIncidents)).append("\n");
        sb.append("    resolvedIncidents: ").append(this.toIndentedString(this.resolvedIncidents)).append("\n");
        sb.append("    deletedIncidents: ").append(this.toIndentedString(this.deletedIncidents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

