/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDtoSorting;
import org.camunda.community.rest.client.dto.VariableQueryParameterDto;

@ApiModel(description="A process instance query which defines a group of process instances")
public class ProcessInstanceQueryDto {
    public static final String SERIALIZED_NAME_DEPLOYMENT_ID = "deploymentId";
    @SerializedName(value="deploymentId")
    private String deploymentId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY_IN = "processDefinitionKeyIn";
    @SerializedName(value="processDefinitionKeyIn")
    private List<String> processDefinitionKeyIn = null;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY_NOT_IN = "processDefinitionKeyNotIn";
    @SerializedName(value="processDefinitionKeyNotIn")
    private List<String> processDefinitionKeyNotIn = null;
    public static final String SERIALIZED_NAME_BUSINESS_KEY = "businessKey";
    @SerializedName(value="businessKey")
    private String businessKey;
    public static final String SERIALIZED_NAME_BUSINESS_KEY_LIKE = "businessKeyLike";
    @SerializedName(value="businessKeyLike")
    private String businessKeyLike;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_SUPER_PROCESS_INSTANCE = "superProcessInstance";
    @SerializedName(value="superProcessInstance")
    private String superProcessInstance;
    public static final String SERIALIZED_NAME_SUB_PROCESS_INSTANCE = "subProcessInstance";
    @SerializedName(value="subProcessInstance")
    private String subProcessInstance;
    public static final String SERIALIZED_NAME_SUPER_CASE_INSTANCE = "superCaseInstance";
    @SerializedName(value="superCaseInstance")
    private String superCaseInstance;
    public static final String SERIALIZED_NAME_SUB_CASE_INSTANCE = "subCaseInstance";
    @SerializedName(value="subCaseInstance")
    private String subCaseInstance;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_IDS = "processInstanceIds";
    @SerializedName(value="processInstanceIds")
    private List<String> processInstanceIds = null;
    public static final String SERIALIZED_NAME_WITH_INCIDENT = "withIncident";
    @SerializedName(value="withIncident")
    private Boolean withIncident;
    public static final String SERIALIZED_NAME_INCIDENT_ID = "incidentId";
    @SerializedName(value="incidentId")
    private String incidentId;
    public static final String SERIALIZED_NAME_INCIDENT_TYPE = "incidentType";
    @SerializedName(value="incidentType")
    private String incidentType;
    public static final String SERIALIZED_NAME_INCIDENT_MESSAGE = "incidentMessage";
    @SerializedName(value="incidentMessage")
    private String incidentMessage;
    public static final String SERIALIZED_NAME_INCIDENT_MESSAGE_LIKE = "incidentMessageLike";
    @SerializedName(value="incidentMessageLike")
    private String incidentMessageLike;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_WITHOUT_TENANT_ID = "processDefinitionWithoutTenantId";
    @SerializedName(value="processDefinitionWithoutTenantId")
    private Boolean processDefinitionWithoutTenantId;
    public static final String SERIALIZED_NAME_ACTIVITY_ID_IN = "activityIdIn";
    @SerializedName(value="activityIdIn")
    private List<String> activityIdIn = null;
    public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCES = "rootProcessInstances";
    @SerializedName(value="rootProcessInstances")
    private Boolean rootProcessInstances;
    public static final String SERIALIZED_NAME_LEAF_PROCESS_INSTANCES = "leafProcessInstances";
    @SerializedName(value="leafProcessInstances")
    private Boolean leafProcessInstances;
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private List<VariableQueryParameterDto> variables = null;
    public static final String SERIALIZED_NAME_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
    @SerializedName(value="variableNamesIgnoreCase")
    private Boolean variableNamesIgnoreCase;
    public static final String SERIALIZED_NAME_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
    @SerializedName(value="variableValuesIgnoreCase")
    private Boolean variableValuesIgnoreCase;
    public static final String SERIALIZED_NAME_OR_QUERIES = "orQueries";
    @SerializedName(value="orQueries")
    private List<ProcessInstanceQueryDto> orQueries = null;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<ProcessInstanceQueryDtoSorting> sorting = null;

    public ProcessInstanceQueryDto deploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the deployment the id belongs to.")
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public ProcessInstanceQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the process definition the instances run on.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ProcessInstanceQueryDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the key of the process definition the instances run on.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public ProcessInstanceQueryDto processDefinitionKeyIn(List<String> processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
        return this;
    }

    public ProcessInstanceQueryDto addProcessDefinitionKeyInItem(String processDefinitionKeyInItem) {
        if (this.processDefinitionKeyIn == null) {
            this.processDefinitionKeyIn = new ArrayList<String>();
        }
        this.processDefinitionKeyIn.add(processDefinitionKeyInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Must be a JSON array of Strings.")
    public List<String> getProcessDefinitionKeyIn() {
        return this.processDefinitionKeyIn;
    }

    public void setProcessDefinitionKeyIn(List<String> processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
    }

    public ProcessInstanceQueryDto processDefinitionKeyNotIn(List<String> processDefinitionKeyNotIn) {
        this.processDefinitionKeyNotIn = processDefinitionKeyNotIn;
        return this;
    }

    public ProcessInstanceQueryDto addProcessDefinitionKeyNotInItem(String processDefinitionKeyNotInItem) {
        if (this.processDefinitionKeyNotIn == null) {
            this.processDefinitionKeyNotIn = new ArrayList<String>();
        }
        this.processDefinitionKeyNotIn.add(processDefinitionKeyNotInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Exclude instances by a list of process definition keys. A process instance must not have one of the given process definition keys. Must be a JSON array of Strings.")
    public List<String> getProcessDefinitionKeyNotIn() {
        return this.processDefinitionKeyNotIn;
    }

    public void setProcessDefinitionKeyNotIn(List<String> processDefinitionKeyNotIn) {
        this.processDefinitionKeyNotIn = processDefinitionKeyNotIn;
    }

    public ProcessInstanceQueryDto businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instance business key.")
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public ProcessInstanceQueryDto businessKeyLike(String businessKeyLike) {
        this.businessKeyLike = businessKeyLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instance business key that the parameter is a substring of.")
    public String getBusinessKeyLike() {
        return this.businessKeyLike;
    }

    public void setBusinessKeyLike(String businessKeyLike) {
        this.businessKeyLike = businessKeyLike;
    }

    public ProcessInstanceQueryDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by case instance id.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public ProcessInstanceQueryDto superProcessInstance(String superProcessInstance) {
        this.superProcessInstance = superProcessInstance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.")
    public String getSuperProcessInstance() {
        return this.superProcessInstance;
    }

    public void setSuperProcessInstance(String superProcessInstance) {
        this.superProcessInstance = superProcessInstance;
    }

    public ProcessInstanceQueryDto subProcessInstance(String subProcessInstance) {
        this.subProcessInstance = subProcessInstance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict query to all process instances that have the given process instance as a sub process instance. Takes a process instance id.")
    public String getSubProcessInstance() {
        return this.subProcessInstance;
    }

    public void setSubProcessInstance(String subProcessInstance) {
        this.subProcessInstance = subProcessInstance;
    }

    public ProcessInstanceQueryDto superCaseInstance(String superCaseInstance) {
        this.superCaseInstance = superCaseInstance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.")
    public String getSuperCaseInstance() {
        return this.superCaseInstance;
    }

    public void setSuperCaseInstance(String superCaseInstance) {
        this.superCaseInstance = superCaseInstance;
    }

    public ProcessInstanceQueryDto subCaseInstance(String subCaseInstance) {
        this.subCaseInstance = subCaseInstance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict query to all process instances that have the given case instance as a sub case instance. Takes a case instance id.")
    public String getSubCaseInstance() {
        return this.subCaseInstance;
    }

    public void setSubCaseInstance(String subCaseInstance) {
        this.subCaseInstance = subCaseInstance;
    }

    public ProcessInstanceQueryDto active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include active process instances. Value may only be true, as false is the default behavior.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ProcessInstanceQueryDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include suspended process instances. Value may only be true, as false is the default behavior.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public ProcessInstanceQueryDto processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    public ProcessInstanceQueryDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
        if (this.processInstanceIds == null) {
            this.processInstanceIds = new ArrayList<String>();
        }
        this.processInstanceIds.add(processInstanceIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a list of process instance ids. Must be a JSON array of Strings.")
    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public ProcessInstanceQueryDto withIncident(Boolean withIncident) {
        this.withIncident = withIncident;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by presence of incidents. Selects only process instances that have an incident.")
    public Boolean getWithIncident() {
        return this.withIncident;
    }

    public void setWithIncident(Boolean withIncident) {
        this.withIncident = withIncident;
    }

    public ProcessInstanceQueryDto incidentId(String incidentId) {
        this.incidentId = incidentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the incident id.")
    public String getIncidentId() {
        return this.incidentId;
    }

    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    public ProcessInstanceQueryDto incidentType(String incidentType) {
        this.incidentType = incidentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the incident type. See the User Guide for a list of incident types.")
    public String getIncidentType() {
        return this.incidentType;
    }

    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    public ProcessInstanceQueryDto incidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the incident message. Exact match.")
    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    public ProcessInstanceQueryDto incidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the incident message that the parameter is a substring of.")
    public String getIncidentMessageLike() {
        return this.incidentMessageLike;
    }

    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    public ProcessInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public ProcessInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Must be a JSON array of Strings.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public ProcessInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include process instances which belong to no tenant. Value may only be true, as false is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public ProcessInstanceQueryDto processDefinitionWithoutTenantId(Boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include process instances which process definition has no tenant id.")
    public Boolean getProcessDefinitionWithoutTenantId() {
        return this.processDefinitionWithoutTenantId;
    }

    public void setProcessDefinitionWithoutTenantId(Boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
    }

    public ProcessInstanceQueryDto activityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
        return this;
    }

    public ProcessInstanceQueryDto addActivityIdInItem(String activityIdInItem) {
        if (this.activityIdIn == null) {
            this.activityIdIn = new ArrayList<String>();
        }
        this.activityIdIn.add(activityIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a list of activity ids. A process instance must currently wait in a leaf activity with one of the given activity ids.")
    public List<String> getActivityIdIn() {
        return this.activityIdIn;
    }

    public void setActivityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    public ProcessInstanceQueryDto rootProcessInstances(Boolean rootProcessInstances) {
        this.rootProcessInstances = rootProcessInstances;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict the query to all process instances that are top level process instances.")
    public Boolean getRootProcessInstances() {
        return this.rootProcessInstances;
    }

    public void setRootProcessInstances(Boolean rootProcessInstances) {
        this.rootProcessInstances = rootProcessInstances;
    }

    public ProcessInstanceQueryDto leafProcessInstances(Boolean leafProcessInstances) {
        this.leafProcessInstances = leafProcessInstances;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict the query to all process instances that are leaf instances. (i.e. don't have any sub instances)")
    public Boolean getLeafProcessInstances() {
        return this.leafProcessInstances;
    }

    public void setLeafProcessInstances(Boolean leafProcessInstances) {
        this.leafProcessInstances = leafProcessInstances;
    }

    public ProcessInstanceQueryDto variables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
        return this;
    }

    public ProcessInstanceQueryDto addVariablesItem(VariableQueryParameterDto variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<VariableQueryParameterDto>();
        }
        this.variables.add(variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array to only include process instances that have variables with certain values. The array consists of objects with the three properties `name`, `operator` and `value`. `name` (String) is the variable name, `operator` (String) is the comparison operator to be used and `value` the variable value. The `value` may be String, Number or Boolean.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.")
    public List<VariableQueryParameterDto> getVariables() {
        return this.variables;
    }

    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    public ProcessInstanceQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match all variable names in this query case-insensitively. If set to true variableName and variablename are treated as equal.")
    public Boolean getVariableNamesIgnoreCase() {
        return this.variableNamesIgnoreCase;
    }

    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    public ProcessInstanceQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match all variable values in this query case-insensitively. If set to true variableValue and variablevalue are treated as equal.")
    public Boolean getVariableValuesIgnoreCase() {
        return this.variableValuesIgnoreCase;
    }

    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    public ProcessInstanceQueryDto orQueries(List<ProcessInstanceQueryDto> orQueries) {
        this.orQueries = orQueries;
        return this;
    }

    public ProcessInstanceQueryDto addOrQueriesItem(ProcessInstanceQueryDto orQueriesItem) {
        if (this.orQueries == null) {
            this.orQueries = new ArrayList<ProcessInstanceQueryDto>();
        }
        this.orQueries.add(orQueriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array of nested process instance queries with OR semantics. A process instance matches a nested query if it fulfills at least one of the query's predicates. With multiple nested queries, a process instance must fulfill at least one predicate of each query (Conjunctive Normal Form). All process instance query properties can be used except for: `sorting` See the [User guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.")
    public List<ProcessInstanceQueryDto> getOrQueries() {
        return this.orQueries;
    }

    public void setOrQueries(List<ProcessInstanceQueryDto> orQueries) {
        this.orQueries = orQueries;
    }

    public ProcessInstanceQueryDto sorting(List<ProcessInstanceQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public ProcessInstanceQueryDto addSortingItem(ProcessInstanceQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<ProcessInstanceQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply sorting of the result")
    public List<ProcessInstanceQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<ProcessInstanceQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceQueryDto processInstanceQueryDto = (ProcessInstanceQueryDto)o;
        return Objects.equals(this.deploymentId, processInstanceQueryDto.deploymentId) && Objects.equals(this.processDefinitionId, processInstanceQueryDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, processInstanceQueryDto.processDefinitionKey) && Objects.equals(this.processDefinitionKeyIn, processInstanceQueryDto.processDefinitionKeyIn) && Objects.equals(this.processDefinitionKeyNotIn, processInstanceQueryDto.processDefinitionKeyNotIn) && Objects.equals(this.businessKey, processInstanceQueryDto.businessKey) && Objects.equals(this.businessKeyLike, processInstanceQueryDto.businessKeyLike) && Objects.equals(this.caseInstanceId, processInstanceQueryDto.caseInstanceId) && Objects.equals(this.superProcessInstance, processInstanceQueryDto.superProcessInstance) && Objects.equals(this.subProcessInstance, processInstanceQueryDto.subProcessInstance) && Objects.equals(this.superCaseInstance, processInstanceQueryDto.superCaseInstance) && Objects.equals(this.subCaseInstance, processInstanceQueryDto.subCaseInstance) && Objects.equals(this.active, processInstanceQueryDto.active) && Objects.equals(this.suspended, processInstanceQueryDto.suspended) && Objects.equals(this.processInstanceIds, processInstanceQueryDto.processInstanceIds) && Objects.equals(this.withIncident, processInstanceQueryDto.withIncident) && Objects.equals(this.incidentId, processInstanceQueryDto.incidentId) && Objects.equals(this.incidentType, processInstanceQueryDto.incidentType) && Objects.equals(this.incidentMessage, processInstanceQueryDto.incidentMessage) && Objects.equals(this.incidentMessageLike, processInstanceQueryDto.incidentMessageLike) && Objects.equals(this.tenantIdIn, processInstanceQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, processInstanceQueryDto.withoutTenantId) && Objects.equals(this.processDefinitionWithoutTenantId, processInstanceQueryDto.processDefinitionWithoutTenantId) && Objects.equals(this.activityIdIn, processInstanceQueryDto.activityIdIn) && Objects.equals(this.rootProcessInstances, processInstanceQueryDto.rootProcessInstances) && Objects.equals(this.leafProcessInstances, processInstanceQueryDto.leafProcessInstances) && Objects.equals(this.variables, processInstanceQueryDto.variables) && Objects.equals(this.variableNamesIgnoreCase, processInstanceQueryDto.variableNamesIgnoreCase) && Objects.equals(this.variableValuesIgnoreCase, processInstanceQueryDto.variableValuesIgnoreCase) && Objects.equals(this.orQueries, processInstanceQueryDto.orQueries) && Objects.equals(this.sorting, processInstanceQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.deploymentId, this.processDefinitionId, this.processDefinitionKey, this.processDefinitionKeyIn, this.processDefinitionKeyNotIn, this.businessKey, this.businessKeyLike, this.caseInstanceId, this.superProcessInstance, this.subProcessInstance, this.superCaseInstance, this.subCaseInstance, this.active, this.suspended, this.processInstanceIds, this.withIncident, this.incidentId, this.incidentType, this.incidentMessage, this.incidentMessageLike, this.tenantIdIn, this.withoutTenantId, this.processDefinitionWithoutTenantId, this.activityIdIn, this.rootProcessInstances, this.leafProcessInstances, this.variables, this.variableNamesIgnoreCase, this.variableValuesIgnoreCase, this.orQueries, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceQueryDto {\n");
        sb.append("    deploymentId: ").append(this.toIndentedString(this.deploymentId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionKeyIn: ").append(this.toIndentedString(this.processDefinitionKeyIn)).append("\n");
        sb.append("    processDefinitionKeyNotIn: ").append(this.toIndentedString(this.processDefinitionKeyNotIn)).append("\n");
        sb.append("    businessKey: ").append(this.toIndentedString(this.businessKey)).append("\n");
        sb.append("    businessKeyLike: ").append(this.toIndentedString(this.businessKeyLike)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    superProcessInstance: ").append(this.toIndentedString(this.superProcessInstance)).append("\n");
        sb.append("    subProcessInstance: ").append(this.toIndentedString(this.subProcessInstance)).append("\n");
        sb.append("    superCaseInstance: ").append(this.toIndentedString(this.superCaseInstance)).append("\n");
        sb.append("    subCaseInstance: ").append(this.toIndentedString(this.subCaseInstance)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    processInstanceIds: ").append(this.toIndentedString(this.processInstanceIds)).append("\n");
        sb.append("    withIncident: ").append(this.toIndentedString(this.withIncident)).append("\n");
        sb.append("    incidentId: ").append(this.toIndentedString(this.incidentId)).append("\n");
        sb.append("    incidentType: ").append(this.toIndentedString(this.incidentType)).append("\n");
        sb.append("    incidentMessage: ").append(this.toIndentedString(this.incidentMessage)).append("\n");
        sb.append("    incidentMessageLike: ").append(this.toIndentedString(this.incidentMessageLike)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    processDefinitionWithoutTenantId: ").append(this.toIndentedString(this.processDefinitionWithoutTenantId)).append("\n");
        sb.append("    activityIdIn: ").append(this.toIndentedString(this.activityIdIn)).append("\n");
        sb.append("    rootProcessInstances: ").append(this.toIndentedString(this.rootProcessInstances)).append("\n");
        sb.append("    leafProcessInstances: ").append(this.toIndentedString(this.leafProcessInstances)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    variableNamesIgnoreCase: ").append(this.toIndentedString(this.variableNamesIgnoreCase)).append("\n");
        sb.append("    variableValuesIgnoreCase: ").append(this.toIndentedString(this.variableValuesIgnoreCase)).append("\n");
        sb.append("    orQueries: ").append(this.toIndentedString(this.orQueries)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

