/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.TaskQueryDtoSorting;
import org.camunda.community.rest.client.dto.VariableQueryParameterDto;

@ApiModel(description="A Task query which defines a group of Tasks.")
public class TaskQueryDto {
    public static final String SERIALIZED_NAME_TASK_ID = "taskId";
    @SerializedName(value="taskId")
    private String taskId;
    public static final String SERIALIZED_NAME_TASK_ID_IN = "taskIdIn";
    @SerializedName(value="taskIdIn")
    private List<String> taskIdIn = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID_IN = "processInstanceIdIn";
    @SerializedName(value="processInstanceIdIn")
    private List<String> processInstanceIdIn = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY = "processInstanceBusinessKey";
    @SerializedName(value="processInstanceBusinessKey")
    private String processInstanceBusinessKey;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_EXPRESSION = "processInstanceBusinessKeyExpression";
    @SerializedName(value="processInstanceBusinessKeyExpression")
    private String processInstanceBusinessKeyExpression;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_IN = "processInstanceBusinessKeyIn";
    @SerializedName(value="processInstanceBusinessKeyIn")
    private List<String> processInstanceBusinessKeyIn = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_LIKE = "processInstanceBusinessKeyLike";
    @SerializedName(value="processInstanceBusinessKeyLike")
    private String processInstanceBusinessKeyLike;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_LIKE_EXPRESSION = "processInstanceBusinessKeyLikeExpression";
    @SerializedName(value="processInstanceBusinessKeyLikeExpression")
    private String processInstanceBusinessKeyLikeExpression;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY_IN = "processDefinitionKeyIn";
    @SerializedName(value="processDefinitionKeyIn")
    private List<String> processDefinitionKeyIn = null;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_NAME = "processDefinitionName";
    @SerializedName(value="processDefinitionName")
    private String processDefinitionName;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_NAME_LIKE = "processDefinitionNameLike";
    @SerializedName(value="processDefinitionNameLike")
    private String processDefinitionNameLike;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_BUSINESS_KEY = "caseInstanceBusinessKey";
    @SerializedName(value="caseInstanceBusinessKey")
    private String caseInstanceBusinessKey;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_BUSINESS_KEY_LIKE = "caseInstanceBusinessKeyLike";
    @SerializedName(value="caseInstanceBusinessKeyLike")
    private String caseInstanceBusinessKeyLike;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_ID = "caseDefinitionId";
    @SerializedName(value="caseDefinitionId")
    private String caseDefinitionId;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_KEY = "caseDefinitionKey";
    @SerializedName(value="caseDefinitionKey")
    private String caseDefinitionKey;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_NAME = "caseDefinitionName";
    @SerializedName(value="caseDefinitionName")
    private String caseDefinitionName;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_NAME_LIKE = "caseDefinitionNameLike";
    @SerializedName(value="caseDefinitionNameLike")
    private String caseDefinitionNameLike;
    public static final String SERIALIZED_NAME_CASE_EXECUTION_ID = "caseExecutionId";
    @SerializedName(value="caseExecutionId")
    private String caseExecutionId;
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID_IN = "activityInstanceIdIn";
    @SerializedName(value="activityInstanceIdIn")
    private List<String> activityInstanceIdIn = null;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId = false;
    public static final String SERIALIZED_NAME_ASSIGNEE = "assignee";
    @SerializedName(value="assignee")
    private String assignee;
    public static final String SERIALIZED_NAME_ASSIGNEE_EXPRESSION = "assigneeExpression";
    @SerializedName(value="assigneeExpression")
    private String assigneeExpression;
    public static final String SERIALIZED_NAME_ASSIGNEE_LIKE = "assigneeLike";
    @SerializedName(value="assigneeLike")
    private String assigneeLike;
    public static final String SERIALIZED_NAME_ASSIGNEE_LIKE_EXPRESSION = "assigneeLikeExpression";
    @SerializedName(value="assigneeLikeExpression")
    private String assigneeLikeExpression;
    public static final String SERIALIZED_NAME_ASSIGNEE_IN = "assigneeIn";
    @SerializedName(value="assigneeIn")
    private List<String> assigneeIn = null;
    public static final String SERIALIZED_NAME_ASSIGNEE_NOT_IN = "assigneeNotIn";
    @SerializedName(value="assigneeNotIn")
    private List<String> assigneeNotIn = null;
    public static final String SERIALIZED_NAME_OWNER = "owner";
    @SerializedName(value="owner")
    private String owner;
    public static final String SERIALIZED_NAME_OWNER_EXPRESSION = "ownerExpression";
    @SerializedName(value="ownerExpression")
    private String ownerExpression;
    public static final String SERIALIZED_NAME_CANDIDATE_GROUP = "candidateGroup";
    @SerializedName(value="candidateGroup")
    private String candidateGroup;
    public static final String SERIALIZED_NAME_CANDIDATE_GROUP_EXPRESSION = "candidateGroupExpression";
    @SerializedName(value="candidateGroupExpression")
    private String candidateGroupExpression;
    public static final String SERIALIZED_NAME_CANDIDATE_USER = "candidateUser";
    @SerializedName(value="candidateUser")
    private String candidateUser;
    public static final String SERIALIZED_NAME_CANDIDATE_USER_EXPRESSION = "candidateUserExpression";
    @SerializedName(value="candidateUserExpression")
    private String candidateUserExpression;
    public static final String SERIALIZED_NAME_INCLUDE_ASSIGNED_TASKS = "includeAssignedTasks";
    @SerializedName(value="includeAssignedTasks")
    private Boolean includeAssignedTasks = false;
    public static final String SERIALIZED_NAME_INVOLVED_USER = "involvedUser";
    @SerializedName(value="involvedUser")
    private String involvedUser;
    public static final String SERIALIZED_NAME_INVOLVED_USER_EXPRESSION = "involvedUserExpression";
    @SerializedName(value="involvedUserExpression")
    private String involvedUserExpression;
    public static final String SERIALIZED_NAME_ASSIGNED = "assigned";
    @SerializedName(value="assigned")
    private Boolean assigned = false;
    public static final String SERIALIZED_NAME_UNASSIGNED = "unassigned";
    @SerializedName(value="unassigned")
    private Boolean unassigned = false;
    public static final String SERIALIZED_NAME_TASK_DEFINITION_KEY = "taskDefinitionKey";
    @SerializedName(value="taskDefinitionKey")
    private String taskDefinitionKey;
    public static final String SERIALIZED_NAME_TASK_DEFINITION_KEY_IN = "taskDefinitionKeyIn";
    @SerializedName(value="taskDefinitionKeyIn")
    private List<String> taskDefinitionKeyIn = null;
    public static final String SERIALIZED_NAME_TASK_DEFINITION_KEY_LIKE = "taskDefinitionKeyLike";
    @SerializedName(value="taskDefinitionKeyLike")
    private String taskDefinitionKeyLike;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NAME_NOT_EQUAL = "nameNotEqual";
    @SerializedName(value="nameNotEqual")
    private String nameNotEqual;
    public static final String SERIALIZED_NAME_NAME_LIKE = "nameLike";
    @SerializedName(value="nameLike")
    private String nameLike;
    public static final String SERIALIZED_NAME_NAME_NOT_LIKE = "nameNotLike";
    @SerializedName(value="nameNotLike")
    private String nameNotLike;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DESCRIPTION_LIKE = "descriptionLike";
    @SerializedName(value="descriptionLike")
    private String descriptionLike;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private Integer priority;
    public static final String SERIALIZED_NAME_MAX_PRIORITY = "maxPriority";
    @SerializedName(value="maxPriority")
    private Integer maxPriority;
    public static final String SERIALIZED_NAME_MIN_PRIORITY = "minPriority";
    @SerializedName(value="minPriority")
    private Integer minPriority;
    public static final String SERIALIZED_NAME_DUE_DATE = "dueDate";
    @SerializedName(value="dueDate")
    private Date dueDate;
    public static final String SERIALIZED_NAME_DUE_DATE_EXPRESSION = "dueDateExpression";
    @SerializedName(value="dueDateExpression")
    private String dueDateExpression;
    public static final String SERIALIZED_NAME_DUE_AFTER = "dueAfter";
    @SerializedName(value="dueAfter")
    private Date dueAfter;
    public static final String SERIALIZED_NAME_DUE_AFTER_EXPRESSION = "dueAfterExpression";
    @SerializedName(value="dueAfterExpression")
    private String dueAfterExpression;
    public static final String SERIALIZED_NAME_DUE_BEFORE = "dueBefore";
    @SerializedName(value="dueBefore")
    private Date dueBefore;
    public static final String SERIALIZED_NAME_DUE_BEFORE_EXPRESSION = "dueBeforeExpression";
    @SerializedName(value="dueBeforeExpression")
    private String dueBeforeExpression;
    public static final String SERIALIZED_NAME_WITHOUT_DUE_DATE = "withoutDueDate";
    @SerializedName(value="withoutDueDate")
    private Boolean withoutDueDate = false;
    public static final String SERIALIZED_NAME_FOLLOW_UP_DATE = "followUpDate";
    @SerializedName(value="followUpDate")
    private Date followUpDate;
    public static final String SERIALIZED_NAME_FOLLOW_UP_DATE_EXPRESSION = "followUpDateExpression";
    @SerializedName(value="followUpDateExpression")
    private String followUpDateExpression;
    public static final String SERIALIZED_NAME_FOLLOW_UP_AFTER = "followUpAfter";
    @SerializedName(value="followUpAfter")
    private Date followUpAfter;
    public static final String SERIALIZED_NAME_FOLLOW_UP_AFTER_EXPRESSION = "followUpAfterExpression";
    @SerializedName(value="followUpAfterExpression")
    private String followUpAfterExpression;
    public static final String SERIALIZED_NAME_FOLLOW_UP_BEFORE = "followUpBefore";
    @SerializedName(value="followUpBefore")
    private String followUpBefore;
    public static final String SERIALIZED_NAME_FOLLOW_UP_BEFORE_EXPRESSION = "followUpBeforeExpression";
    @SerializedName(value="followUpBeforeExpression")
    private String followUpBeforeExpression;
    public static final String SERIALIZED_NAME_FOLLOW_UP_BEFORE_OR_NOT_EXISTENT = "followUpBeforeOrNotExistent";
    @SerializedName(value="followUpBeforeOrNotExistent")
    private Date followUpBeforeOrNotExistent;
    public static final String SERIALIZED_NAME_FOLLOW_UP_BEFORE_OR_NOT_EXISTENT_EXPRESSION = "followUpBeforeOrNotExistentExpression";
    @SerializedName(value="followUpBeforeOrNotExistentExpression")
    private String followUpBeforeOrNotExistentExpression;
    public static final String SERIALIZED_NAME_CREATED_ON = "createdOn";
    @SerializedName(value="createdOn")
    private Date createdOn;
    public static final String SERIALIZED_NAME_CREATED_ON_EXPRESSION = "createdOnExpression";
    @SerializedName(value="createdOnExpression")
    private String createdOnExpression;
    public static final String SERIALIZED_NAME_CREATED_AFTER = "createdAfter";
    @SerializedName(value="createdAfter")
    private Date createdAfter;
    public static final String SERIALIZED_NAME_CREATED_AFTER_EXPRESSION = "createdAfterExpression";
    @SerializedName(value="createdAfterExpression")
    private String createdAfterExpression;
    public static final String SERIALIZED_NAME_CREATED_BEFORE = "createdBefore";
    @SerializedName(value="createdBefore")
    private Date createdBefore;
    public static final String SERIALIZED_NAME_CREATED_BEFORE_EXPRESSION = "createdBeforeExpression";
    @SerializedName(value="createdBeforeExpression")
    private String createdBeforeExpression;
    public static final String SERIALIZED_NAME_UPDATED_AFTER = "updatedAfter";
    @SerializedName(value="updatedAfter")
    private Date updatedAfter;
    public static final String SERIALIZED_NAME_UPDATED_AFTER_EXPRESSION = "updatedAfterExpression";
    @SerializedName(value="updatedAfterExpression")
    private String updatedAfterExpression;
    public static final String SERIALIZED_NAME_DELEGATION_STATE = "delegationState";
    @SerializedName(value="delegationState")
    private DelegationStateEnum delegationState;
    public static final String SERIALIZED_NAME_CANDIDATE_GROUPS = "candidateGroups";
    @SerializedName(value="candidateGroups")
    private List<String> candidateGroups = null;
    public static final String SERIALIZED_NAME_CANDIDATE_GROUPS_EXPRESSION = "candidateGroupsExpression";
    @SerializedName(value="candidateGroupsExpression")
    private String candidateGroupsExpression;
    public static final String SERIALIZED_NAME_WITH_CANDIDATE_GROUPS = "withCandidateGroups";
    @SerializedName(value="withCandidateGroups")
    private Boolean withCandidateGroups = false;
    public static final String SERIALIZED_NAME_WITHOUT_CANDIDATE_GROUPS = "withoutCandidateGroups";
    @SerializedName(value="withoutCandidateGroups")
    private Boolean withoutCandidateGroups = false;
    public static final String SERIALIZED_NAME_WITH_CANDIDATE_USERS = "withCandidateUsers";
    @SerializedName(value="withCandidateUsers")
    private Boolean withCandidateUsers = false;
    public static final String SERIALIZED_NAME_WITHOUT_CANDIDATE_USERS = "withoutCandidateUsers";
    @SerializedName(value="withoutCandidateUsers")
    private Boolean withoutCandidateUsers = false;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active = false;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended = false;
    public static final String SERIALIZED_NAME_TASK_VARIABLES = "taskVariables";
    @SerializedName(value="taskVariables")
    private List<VariableQueryParameterDto> taskVariables = null;
    public static final String SERIALIZED_NAME_PROCESS_VARIABLES = "processVariables";
    @SerializedName(value="processVariables")
    private List<VariableQueryParameterDto> processVariables = null;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_VARIABLES = "caseInstanceVariables";
    @SerializedName(value="caseInstanceVariables")
    private List<VariableQueryParameterDto> caseInstanceVariables = null;
    public static final String SERIALIZED_NAME_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
    @SerializedName(value="variableNamesIgnoreCase")
    private Boolean variableNamesIgnoreCase = false;
    public static final String SERIALIZED_NAME_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
    @SerializedName(value="variableValuesIgnoreCase")
    private Boolean variableValuesIgnoreCase = false;
    public static final String SERIALIZED_NAME_PARENT_TASK_ID = "parentTaskId";
    @SerializedName(value="parentTaskId")
    private String parentTaskId;
    public static final String SERIALIZED_NAME_OR_QUERIES = "orQueries";
    @SerializedName(value="orQueries")
    private List<TaskQueryDto> orQueries = null;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<TaskQueryDtoSorting> sorting = null;

    public TaskQueryDto taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to task with the given id.")
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public TaskQueryDto taskIdIn(List<String> taskIdIn) {
        this.taskIdIn = taskIdIn;
        return this;
    }

    public TaskQueryDto addTaskIdInItem(String taskIdInItem) {
        if (this.taskIdIn == null) {
            this.taskIdIn = new ArrayList<String>();
        }
        this.taskIdIn.add(taskIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks with any of the given ids.")
    public List<String> getTaskIdIn() {
        return this.taskIdIn;
    }

    public void setTaskIdIn(List<String> taskIdIn) {
        this.taskIdIn = taskIdIn;
    }

    public TaskQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to process instances with the given id.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public TaskQueryDto processInstanceIdIn(List<String> processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
        return this;
    }

    public TaskQueryDto addProcessInstanceIdInItem(String processInstanceIdInItem) {
        if (this.processInstanceIdIn == null) {
            this.processInstanceIdIn = new ArrayList<String>();
        }
        this.processInstanceIdIn.add(processInstanceIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to process instances with the given ids.")
    public List<String> getProcessInstanceIdIn() {
        return this.processInstanceIdIn;
    }

    public void setProcessInstanceIdIn(List<String> processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    public TaskQueryDto processInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to process instances with the given business key.")
    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    public void setProcessInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
    }

    public TaskQueryDto processInstanceBusinessKeyExpression(String processInstanceBusinessKeyExpression) {
        this.processInstanceBusinessKeyExpression = processInstanceBusinessKeyExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to process instances with the given business key which  is described by an expression. See the  [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.")
    public String getProcessInstanceBusinessKeyExpression() {
        return this.processInstanceBusinessKeyExpression;
    }

    public void setProcessInstanceBusinessKeyExpression(String processInstanceBusinessKeyExpression) {
        this.processInstanceBusinessKeyExpression = processInstanceBusinessKeyExpression;
    }

    public TaskQueryDto processInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
        this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
        return this;
    }

    public TaskQueryDto addProcessInstanceBusinessKeyInItem(String processInstanceBusinessKeyInItem) {
        if (this.processInstanceBusinessKeyIn == null) {
            this.processInstanceBusinessKeyIn = new ArrayList<String>();
        }
        this.processInstanceBusinessKeyIn.add(processInstanceBusinessKeyInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to process instances with one of the give business keys.  The keys need to be in a comma-separated list.")
    public List<String> getProcessInstanceBusinessKeyIn() {
        return this.processInstanceBusinessKeyIn;
    }

    public void setProcessInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
        this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
    }

    public TaskQueryDto processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a process instance business key that has the parameter  value as a substring.")
    public String getProcessInstanceBusinessKeyLike() {
        return this.processInstanceBusinessKeyLike;
    }

    public void setProcessInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
    }

    public TaskQueryDto processInstanceBusinessKeyLikeExpression(String processInstanceBusinessKeyLikeExpression) {
        this.processInstanceBusinessKeyLikeExpression = processInstanceBusinessKeyLikeExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a process instance business key that has the parameter  value as a substring and is described by an expression. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.")
    public String getProcessInstanceBusinessKeyLikeExpression() {
        return this.processInstanceBusinessKeyLikeExpression;
    }

    public void setProcessInstanceBusinessKeyLikeExpression(String processInstanceBusinessKeyLikeExpression) {
        this.processInstanceBusinessKeyLikeExpression = processInstanceBusinessKeyLikeExpression;
    }

    public TaskQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to a process definition with the given id.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public TaskQueryDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to a process definition with the given key.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public TaskQueryDto processDefinitionKeyIn(List<String> processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
        return this;
    }

    public TaskQueryDto addProcessDefinitionKeyInItem(String processDefinitionKeyInItem) {
        if (this.processDefinitionKeyIn == null) {
            this.processDefinitionKeyIn = new ArrayList<String>();
        }
        this.processDefinitionKeyIn.add(processDefinitionKeyInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to a process definition with one of the given keys. The  keys need to be in a comma-separated list.")
    public List<String> getProcessDefinitionKeyIn() {
        return this.processDefinitionKeyIn;
    }

    public void setProcessDefinitionKeyIn(List<String> processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
    }

    public TaskQueryDto processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to a process definition with the given name.")
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    public TaskQueryDto processDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a process definition name that has the parameter value as  a substring.")
    public String getProcessDefinitionNameLike() {
        return this.processDefinitionNameLike;
    }

    public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
    }

    public TaskQueryDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to an execution with the given id.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public TaskQueryDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to case instances with the given id.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public TaskQueryDto caseInstanceBusinessKey(String caseInstanceBusinessKey) {
        this.caseInstanceBusinessKey = caseInstanceBusinessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to case instances with the given business key.")
    public String getCaseInstanceBusinessKey() {
        return this.caseInstanceBusinessKey;
    }

    public void setCaseInstanceBusinessKey(String caseInstanceBusinessKey) {
        this.caseInstanceBusinessKey = caseInstanceBusinessKey;
    }

    public TaskQueryDto caseInstanceBusinessKeyLike(String caseInstanceBusinessKeyLike) {
        this.caseInstanceBusinessKeyLike = caseInstanceBusinessKeyLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a case instance business key that has the parameter value  as a substring.")
    public String getCaseInstanceBusinessKeyLike() {
        return this.caseInstanceBusinessKeyLike;
    }

    public void setCaseInstanceBusinessKeyLike(String caseInstanceBusinessKeyLike) {
        this.caseInstanceBusinessKeyLike = caseInstanceBusinessKeyLike;
    }

    public TaskQueryDto caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to a case definition with the given id.")
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public TaskQueryDto caseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to a case definition with the given key.")
    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    public TaskQueryDto caseDefinitionName(String caseDefinitionName) {
        this.caseDefinitionName = caseDefinitionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to a case definition with the given name.")
    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    public void setCaseDefinitionName(String caseDefinitionName) {
        this.caseDefinitionName = caseDefinitionName;
    }

    public TaskQueryDto caseDefinitionNameLike(String caseDefinitionNameLike) {
        this.caseDefinitionNameLike = caseDefinitionNameLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a case definition name that has the parameter value as a  substring.")
    public String getCaseDefinitionNameLike() {
        return this.caseDefinitionNameLike;
    }

    public void setCaseDefinitionNameLike(String caseDefinitionNameLike) {
        this.caseDefinitionNameLike = caseDefinitionNameLike;
    }

    public TaskQueryDto caseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that belong to a case execution with the given id.")
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    public TaskQueryDto activityInstanceIdIn(List<String> activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
        return this;
    }

    public TaskQueryDto addActivityInstanceIdInItem(String activityInstanceIdInItem) {
        if (this.activityInstanceIdIn == null) {
            this.activityInstanceIdIn = new ArrayList<String>();
        }
        this.activityInstanceIdIn.add(activityInstanceIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which belong to one of the passed and comma-separated activity  instance ids.")
    public List<String> getActivityInstanceIdIn() {
        return this.activityInstanceIdIn;
    }

    public void setActivityInstanceIdIn(List<String> activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    public TaskQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public TaskQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which belong to one of the passed and comma-separated  tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public TaskQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which belong to no tenant. Value may only be `true`,  as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public TaskQueryDto assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that the given user is assigned to.")
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public TaskQueryDto assigneeExpression(String assigneeExpression) {
        this.assigneeExpression = assigneeExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that the user described by the given expression is assigned to. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.")
    public String getAssigneeExpression() {
        return this.assigneeExpression;
    }

    public void setAssigneeExpression(String assigneeExpression) {
        this.assigneeExpression = assigneeExpression;
    }

    public TaskQueryDto assigneeLike(String assigneeLike) {
        this.assigneeLike = assigneeLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have an assignee that has the parameter  value as a substring.")
    public String getAssigneeLike() {
        return this.assigneeLike;
    }

    public void setAssigneeLike(String assigneeLike) {
        this.assigneeLike = assigneeLike;
    }

    public TaskQueryDto assigneeLikeExpression(String assigneeLikeExpression) {
        this.assigneeLikeExpression = assigneeLikeExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have an assignee that has the parameter value described by the  given expression as a substring. See the  [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.")
    public String getAssigneeLikeExpression() {
        return this.assigneeLikeExpression;
    }

    public void setAssigneeLikeExpression(String assigneeLikeExpression) {
        this.assigneeLikeExpression = assigneeLikeExpression;
    }

    public TaskQueryDto assigneeIn(List<String> assigneeIn) {
        this.assigneeIn = assigneeIn;
        return this;
    }

    public TaskQueryDto addAssigneeInItem(String assigneeInItem) {
        if (this.assigneeIn == null) {
            this.assigneeIn = new ArrayList<String>();
        }
        this.assigneeIn.add(assigneeInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which are assigned to one of the passed and comma-separated user ids.")
    public List<String> getAssigneeIn() {
        return this.assigneeIn;
    }

    public void setAssigneeIn(List<String> assigneeIn) {
        this.assigneeIn = assigneeIn;
    }

    public TaskQueryDto assigneeNotIn(List<String> assigneeNotIn) {
        this.assigneeNotIn = assigneeNotIn;
        return this;
    }

    public TaskQueryDto addAssigneeNotInItem(String assigneeNotInItem) {
        if (this.assigneeNotIn == null) {
            this.assigneeNotIn = new ArrayList<String>();
        }
        this.assigneeNotIn.add(assigneeNotInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which are not assigned to one of the passed and comma-separated user ids.")
    public List<String> getAssigneeNotIn() {
        return this.assigneeNotIn;
    }

    public void setAssigneeNotIn(List<String> assigneeNotIn) {
        this.assigneeNotIn = assigneeNotIn;
    }

    public TaskQueryDto owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that the given user owns.")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public TaskQueryDto ownerExpression(String ownerExpression) {
        this.ownerExpression = ownerExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that the user described by the given expression owns. See the  [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.")
    public String getOwnerExpression() {
        return this.ownerExpression;
    }

    public void setOwnerExpression(String ownerExpression) {
        this.ownerExpression = ownerExpression;
    }

    public TaskQueryDto candidateGroup(String candidateGroup) {
        this.candidateGroup = candidateGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks that are offered to the given group.")
    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public void setCandidateGroup(String candidateGroup) {
        this.candidateGroup = candidateGroup;
    }

    public TaskQueryDto candidateGroupExpression(String candidateGroupExpression) {
        this.candidateGroupExpression = candidateGroupExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks that are offered to the group described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.")
    public String getCandidateGroupExpression() {
        return this.candidateGroupExpression;
    }

    public void setCandidateGroupExpression(String candidateGroupExpression) {
        this.candidateGroupExpression = candidateGroupExpression;
    }

    public TaskQueryDto candidateUser(String candidateUser) {
        this.candidateUser = candidateUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks that are offered to the given user or to one of his groups.")
    public String getCandidateUser() {
        return this.candidateUser;
    }

    public void setCandidateUser(String candidateUser) {
        this.candidateUser = candidateUser;
    }

    public TaskQueryDto candidateUserExpression(String candidateUserExpression) {
        this.candidateUserExpression = candidateUserExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks that are offered to the user described by the given expression.  See the  [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions)  for more information on available functions.")
    public String getCandidateUserExpression() {
        return this.candidateUserExpression;
    }

    public void setCandidateUserExpression(String candidateUserExpression) {
        this.candidateUserExpression = candidateUserExpression;
    }

    public TaskQueryDto includeAssignedTasks(Boolean includeAssignedTasks) {
        this.includeAssignedTasks = includeAssignedTasks;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Also include tasks that are assigned to users in candidate queries. Default is to only  include tasks that are not assigned to any user if you query by candidate user or group(s).")
    public Boolean getIncludeAssignedTasks() {
        return this.includeAssignedTasks;
    }

    public void setIncludeAssignedTasks(Boolean includeAssignedTasks) {
        this.includeAssignedTasks = includeAssignedTasks;
    }

    public TaskQueryDto involvedUser(String involvedUser) {
        this.involvedUser = involvedUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks that the given user is involved in. A user is involved in a task if  an identity link exists between task and user (e.g., the user is the assignee).")
    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public void setInvolvedUser(String involvedUser) {
        this.involvedUser = involvedUser;
    }

    public TaskQueryDto involvedUserExpression(String involvedUserExpression) {
        this.involvedUserExpression = involvedUserExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks that the user described by the given expression is involved in. A user is involved in a task if an identity link exists between task and user (e.g., the user is the assignee). See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions.")
    public String getInvolvedUserExpression() {
        return this.involvedUserExpression;
    }

    public void setInvolvedUserExpression(String involvedUserExpression) {
        this.involvedUserExpression = involvedUserExpression;
    }

    public TaskQueryDto assigned(Boolean assigned) {
        this.assigned = assigned;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, restricts the query to all tasks that are assigned.")
    public Boolean getAssigned() {
        return this.assigned;
    }

    public void setAssigned(Boolean assigned) {
        this.assigned = assigned;
    }

    public TaskQueryDto unassigned(Boolean unassigned) {
        this.unassigned = unassigned;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, restricts the query to all tasks that are unassigned.")
    public Boolean getUnassigned() {
        return this.unassigned;
    }

    public void setUnassigned(Boolean unassigned) {
        this.unassigned = unassigned;
    }

    public TaskQueryDto taskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have the given key.")
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    public TaskQueryDto taskDefinitionKeyIn(List<String> taskDefinitionKeyIn) {
        this.taskDefinitionKeyIn = taskDefinitionKeyIn;
        return this;
    }

    public TaskQueryDto addTaskDefinitionKeyInItem(String taskDefinitionKeyInItem) {
        if (this.taskDefinitionKeyIn == null) {
            this.taskDefinitionKeyIn = new ArrayList<String>();
        }
        this.taskDefinitionKeyIn.add(taskDefinitionKeyInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have one of the given keys. The keys need to be in a comma-separated list.")
    public List<String> getTaskDefinitionKeyIn() {
        return this.taskDefinitionKeyIn;
    }

    public void setTaskDefinitionKeyIn(List<String> taskDefinitionKeyIn) {
        this.taskDefinitionKeyIn = taskDefinitionKeyIn;
    }

    public TaskQueryDto taskDefinitionKeyLike(String taskDefinitionKeyLike) {
        this.taskDefinitionKeyLike = taskDefinitionKeyLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a key that has the parameter value as a substring.")
    public String getTaskDefinitionKeyLike() {
        return this.taskDefinitionKeyLike;
    }

    public void setTaskDefinitionKeyLike(String taskDefinitionKeyLike) {
        this.taskDefinitionKeyLike = taskDefinitionKeyLike;
    }

    public TaskQueryDto name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have the given name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TaskQueryDto nameNotEqual(String nameNotEqual) {
        this.nameNotEqual = nameNotEqual;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that do not have the given name.")
    public String getNameNotEqual() {
        return this.nameNotEqual;
    }

    public void setNameNotEqual(String nameNotEqual) {
        this.nameNotEqual = nameNotEqual;
    }

    public TaskQueryDto nameLike(String nameLike) {
        this.nameLike = nameLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a name with the given parameter value as substring.")
    public String getNameLike() {
        return this.nameLike;
    }

    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    public TaskQueryDto nameNotLike(String nameNotLike) {
        this.nameNotLike = nameNotLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that do not have a name with the given parameter value as substring.")
    public String getNameNotLike() {
        return this.nameNotLike;
    }

    public void setNameNotLike(String nameNotLike) {
        this.nameNotLike = nameNotLike;
    }

    public TaskQueryDto description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have the given description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TaskQueryDto descriptionLike(String descriptionLike) {
        this.descriptionLike = descriptionLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a description that has the parameter value as a substring.")
    public String getDescriptionLike() {
        return this.descriptionLike;
    }

    public void setDescriptionLike(String descriptionLike) {
        this.descriptionLike = descriptionLike;
    }

    public TaskQueryDto priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have the given priority.")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public TaskQueryDto maxPriority(Integer maxPriority) {
        this.maxPriority = maxPriority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a lower or equal priority.")
    public Integer getMaxPriority() {
        return this.maxPriority;
    }

    public void setMaxPriority(Integer maxPriority) {
        this.maxPriority = maxPriority;
    }

    public TaskQueryDto minPriority(Integer minPriority) {
        this.minPriority = minPriority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a higher or equal priority.")
    public Integer getMinPriority() {
        return this.minPriority;
    }

    public void setMinPriority(Integer minPriority) {
        this.minPriority = minPriority;
    }

    public TaskQueryDto dueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.546+0200`.")
    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public TaskQueryDto dueDateExpression(String dueDateExpression) {
        this.dueDateExpression = dueDateExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are due on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.")
    public String getDueDateExpression() {
        return this.dueDateExpression;
    }

    public void setDueDateExpression(String dueDateExpression) {
        this.dueDateExpression = dueDateExpression;
    }

    public TaskQueryDto dueAfter(Date dueAfter) {
        this.dueAfter = dueAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.435+0200`.")
    public Date getDueAfter() {
        return this.dueAfter;
    }

    public void setDueAfter(Date dueAfter) {
        this.dueAfter = dueAfter;
    }

    public TaskQueryDto dueAfterExpression(String dueAfterExpression) {
        this.dueAfterExpression = dueAfterExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are due after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.")
    public String getDueAfterExpression() {
        return this.dueAfterExpression;
    }

    public void setDueAfterExpression(String dueAfterExpression) {
        this.dueAfterExpression = dueAfterExpression;
    }

    public TaskQueryDto dueBefore(Date dueBefore) {
        this.dueBefore = dueBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.243+0200`.")
    public Date getDueBefore() {
        return this.dueBefore;
    }

    public void setDueBefore(Date dueBefore) {
        this.dueBefore = dueBefore;
    }

    public TaskQueryDto dueBeforeExpression(String dueBeforeExpression) {
        this.dueBeforeExpression = dueBeforeExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are due before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.")
    public String getDueBeforeExpression() {
        return this.dueBeforeExpression;
    }

    public void setDueBeforeExpression(String dueBeforeExpression) {
        this.dueBeforeExpression = dueBeforeExpression;
    }

    public TaskQueryDto withoutDueDate(Boolean withoutDueDate) {
        this.withoutDueDate = withoutDueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which have no due date. Value may only be `true`,  as `false` is the default behavior.")
    public Boolean getWithoutDueDate() {
        return this.withoutDueDate;
    }

    public void setWithoutDueDate(Boolean withoutDueDate) {
        this.withoutDueDate = withoutDueDate;
    }

    public TaskQueryDto followUpDate(Date followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.")
    public Date getFollowUpDate() {
        return this.followUpDate;
    }

    public void setFollowUpDate(Date followUpDate) {
        this.followUpDate = followUpDate;
    }

    public TaskQueryDto followUpDateExpression(String followUpDateExpression) {
        this.followUpDateExpression = followUpDateExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a followUp date on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.")
    public String getFollowUpDateExpression() {
        return this.followUpDateExpression;
    }

    public void setFollowUpDateExpression(String followUpDateExpression) {
        this.followUpDateExpression = followUpDateExpression;
    }

    public TaskQueryDto followUpAfter(Date followUpAfter) {
        this.followUpAfter = followUpAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.542+0200`.")
    public Date getFollowUpAfter() {
        return this.followUpAfter;
    }

    public void setFollowUpAfter(Date followUpAfter) {
        this.followUpAfter = followUpAfter;
    }

    public TaskQueryDto followUpAfterExpression(String followUpAfterExpression) {
        this.followUpAfterExpression = followUpAfterExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a followUp date after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.")
    public String getFollowUpAfterExpression() {
        return this.followUpAfterExpression;
    }

    public void setFollowUpAfterExpression(String followUpAfterExpression) {
        this.followUpAfterExpression = followUpAfterExpression;
    }

    public TaskQueryDto followUpBefore(String followUpBefore) {
        this.followUpBefore = followUpBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.234+0200`.")
    public String getFollowUpBefore() {
        return this.followUpBefore;
    }

    public void setFollowUpBefore(String followUpBefore) {
        this.followUpBefore = followUpBefore;
    }

    public TaskQueryDto followUpBeforeExpression(String followUpBeforeExpression) {
        this.followUpBeforeExpression = followUpBeforeExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.")
    public String getFollowUpBeforeExpression() {
        return this.followUpBeforeExpression;
    }

    public void setFollowUpBeforeExpression(String followUpBeforeExpression) {
        this.followUpBeforeExpression = followUpBeforeExpression;
    }

    public TaskQueryDto followUpBeforeOrNotExistent(Date followUpBeforeOrNotExistent) {
        this.followUpBeforeOrNotExistent = followUpBeforeOrNotExistent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have no followUp date or a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.432+0200`. The typical use case is to query all `active` tasks for a user for a given date.")
    public Date getFollowUpBeforeOrNotExistent() {
        return this.followUpBeforeOrNotExistent;
    }

    public void setFollowUpBeforeOrNotExistent(Date followUpBeforeOrNotExistent) {
        this.followUpBeforeOrNotExistent = followUpBeforeOrNotExistent;
    }

    public TaskQueryDto followUpBeforeOrNotExistentExpression(String followUpBeforeOrNotExistentExpression) {
        this.followUpBeforeOrNotExistentExpression = followUpBeforeOrNotExistentExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that have no followUp date or a followUp date before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.")
    public String getFollowUpBeforeOrNotExistentExpression() {
        return this.followUpBeforeOrNotExistentExpression;
    }

    public void setFollowUpBeforeOrNotExistentExpression(String followUpBeforeOrNotExistentExpression) {
        this.followUpBeforeOrNotExistentExpression = followUpBeforeOrNotExistentExpression;
    }

    public TaskQueryDto createdOn(Date createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that were created on the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.324+0200`.")
    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public TaskQueryDto createdOnExpression(String createdOnExpression) {
        this.createdOnExpression = createdOnExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that were created on the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.")
    public String getCreatedOnExpression() {
        return this.createdOnExpression;
    }

    public void setCreatedOnExpression(String createdOnExpression) {
        this.createdOnExpression = createdOnExpression;
    }

    public TaskQueryDto createdAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that were created after the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.342+0200`.")
    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public TaskQueryDto createdAfterExpression(String createdAfterExpression) {
        this.createdAfterExpression = createdAfterExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that were created after the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.")
    public String getCreatedAfterExpression() {
        return this.createdAfterExpression;
    }

    public void setCreatedAfterExpression(String createdAfterExpression) {
        this.createdAfterExpression = createdAfterExpression;
    }

    public TaskQueryDto createdBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that were created before the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.332+0200`.")
    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public TaskQueryDto createdBeforeExpression(String createdBeforeExpression) {
        this.createdBeforeExpression = createdBeforeExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that were created before the date described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.")
    public String getCreatedBeforeExpression() {
        return this.createdBeforeExpression;
    }

    public void setCreatedBeforeExpression(String createdBeforeExpression) {
        this.createdBeforeExpression = createdBeforeExpression;
    }

    public TaskQueryDto updatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that were updated after the given date. Every action that fires  a [task update event](https://docs.camunda.org/manual/7.19/user-guide/process-engine/delegation-code/#task-listener-event-lifecycle) is considered as updating the task. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.332+0200`.")
    public Date getUpdatedAfter() {
        return this.updatedAfter;
    }

    public void setUpdatedAfter(Date updatedAfter) {
        this.updatedAfter = updatedAfter;
    }

    public TaskQueryDto updatedAfterExpression(String updatedAfterExpression) {
        this.updatedAfterExpression = updatedAfterExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that were updated after the date described by the given expression. Every action that fires  a [task update event](https://docs.camunda.org/manual/7.19/user-guide/process-engine/delegation-code/#task-listener-event-lifecycle) is considered as updating the task. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to a `java.util.Date` or `org.joda.time.DateTime` object.")
    public String getUpdatedAfterExpression() {
        return this.updatedAfterExpression;
    }

    public void setUpdatedAfterExpression(String updatedAfterExpression) {
        this.updatedAfterExpression = updatedAfterExpression;
    }

    public TaskQueryDto delegationState(DelegationStateEnum delegationState) {
        this.delegationState = delegationState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are in the given delegation state. Valid values are `PENDING` and `RESOLVED`.")
    public DelegationStateEnum getDelegationState() {
        return this.delegationState;
    }

    public void setDelegationState(DelegationStateEnum delegationState) {
        this.delegationState = delegationState;
    }

    public TaskQueryDto candidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public TaskQueryDto addCandidateGroupsItem(String candidateGroupsItem) {
        if (this.candidateGroups == null) {
            this.candidateGroups = new ArrayList<String>();
        }
        this.candidateGroups.add(candidateGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are offered to any of the given candidate groups. Takes a comma-separated list of group names, so for example `developers,support,sales`.")
    public List<String> getCandidateGroups() {
        return this.candidateGroups;
    }

    public void setCandidateGroups(List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
    }

    public TaskQueryDto candidateGroupsExpression(String candidateGroupsExpression) {
        this.candidateGroupsExpression = candidateGroupsExpression;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to tasks that are offered to any of the candidate groups described by the given expression. See the [user guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/expression-language/#internal-context-functions) for more information on available functions. The expression must evaluate to `java.util.List` of Strings.")
    public String getCandidateGroupsExpression() {
        return this.candidateGroupsExpression;
    }

    public void setCandidateGroupsExpression(String candidateGroupsExpression) {
        this.candidateGroupsExpression = candidateGroupsExpression;
    }

    public TaskQueryDto withCandidateGroups(Boolean withCandidateGroups) {
        this.withCandidateGroups = withCandidateGroups;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithCandidateGroups() {
        return this.withCandidateGroups;
    }

    public void setWithCandidateGroups(Boolean withCandidateGroups) {
        this.withCandidateGroups = withCandidateGroups;
    }

    public TaskQueryDto withoutCandidateGroups(Boolean withoutCandidateGroups) {
        this.withoutCandidateGroups = withoutCandidateGroups;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutCandidateGroups() {
        return this.withoutCandidateGroups;
    }

    public void setWithoutCandidateGroups(Boolean withoutCandidateGroups) {
        this.withoutCandidateGroups = withoutCandidateGroups;
    }

    public TaskQueryDto withCandidateUsers(Boolean withCandidateUsers) {
        this.withCandidateUsers = withCandidateUsers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which have a candidate user. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithCandidateUsers() {
        return this.withCandidateUsers;
    }

    public void setWithCandidateUsers(Boolean withCandidateUsers) {
        this.withCandidateUsers = withCandidateUsers;
    }

    public TaskQueryDto withoutCandidateUsers(Boolean withoutCandidateUsers) {
        this.withoutCandidateUsers = withoutCandidateUsers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include tasks which have no candidate users. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutCandidateUsers() {
        return this.withoutCandidateUsers;
    }

    public void setWithoutCandidateUsers(Boolean withoutCandidateUsers) {
        this.withoutCandidateUsers = withoutCandidateUsers;
    }

    public TaskQueryDto active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include active tasks. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public TaskQueryDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include suspended tasks. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public TaskQueryDto taskVariables(List<VariableQueryParameterDto> taskVariables) {
        this.taskVariables = taskVariables;
        return this;
    }

    public TaskQueryDto addTaskVariablesItem(VariableQueryParameterDto taskVariablesItem) {
        if (this.taskVariables == null) {
            this.taskVariables = new ArrayList<VariableQueryParameterDto>();
        }
        this.taskVariables.add(taskVariablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array to only include tasks that have variables with certain values. The array consists of JSON objects with three properties `name`, `operator` and `value`. `name` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. `value` may be of type `String`, `Number` or `Boolean`.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.")
    public List<VariableQueryParameterDto> getTaskVariables() {
        return this.taskVariables;
    }

    public void setTaskVariables(List<VariableQueryParameterDto> taskVariables) {
        this.taskVariables = taskVariables;
    }

    public TaskQueryDto processVariables(List<VariableQueryParameterDto> processVariables) {
        this.processVariables = processVariables;
        return this;
    }

    public TaskQueryDto addProcessVariablesItem(VariableQueryParameterDto processVariablesItem) {
        if (this.processVariables == null) {
            this.processVariables = new ArrayList<VariableQueryParameterDto>();
        }
        this.processVariables.add(processVariablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array to only include tasks that belong to a process instance with variables with certain values. The array consists of JSON objects with three properties `name`, `operator` and `value`. `name` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. `value` may be of type `String`, `Number` or `Boolean`.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`; `notLike`. `key` and `value` may not contain underscore or comma characters.")
    public List<VariableQueryParameterDto> getProcessVariables() {
        return this.processVariables;
    }

    public void setProcessVariables(List<VariableQueryParameterDto> processVariables) {
        this.processVariables = processVariables;
    }

    public TaskQueryDto caseInstanceVariables(List<VariableQueryParameterDto> caseInstanceVariables) {
        this.caseInstanceVariables = caseInstanceVariables;
        return this;
    }

    public TaskQueryDto addCaseInstanceVariablesItem(VariableQueryParameterDto caseInstanceVariablesItem) {
        if (this.caseInstanceVariables == null) {
            this.caseInstanceVariables = new ArrayList<VariableQueryParameterDto>();
        }
        this.caseInstanceVariables.add(caseInstanceVariablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array to only include tasks that belong to a case instance with variables with certain values. The array consists of JSON objects with three properties `name`, `operator` and `value`. `name` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. `value` may be of type `String`, `Number` or `Boolean`.  Valid `operator` values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. `key` and `value` may not contain underscore or comma characters.")
    public List<VariableQueryParameterDto> getCaseInstanceVariables() {
        return this.caseInstanceVariables;
    }

    public void setCaseInstanceVariables(List<VariableQueryParameterDto> caseInstanceVariables) {
        this.caseInstanceVariables = caseInstanceVariables;
    }

    public TaskQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match all variable names in this query case-insensitively. If set `variableName` and `variablename` are treated as equal.")
    public Boolean getVariableNamesIgnoreCase() {
        return this.variableNamesIgnoreCase;
    }

    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    public TaskQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match all variable values in this query case-insensitively. If set `variableValue` and `variablevalue` are treated as equal.")
    public Boolean getVariableValuesIgnoreCase() {
        return this.variableValuesIgnoreCase;
    }

    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    public TaskQueryDto parentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict query to all tasks that are sub tasks of the given task. Takes a task id.")
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public TaskQueryDto orQueries(List<TaskQueryDto> orQueries) {
        this.orQueries = orQueries;
        return this;
    }

    public TaskQueryDto addOrQueriesItem(TaskQueryDto orQueriesItem) {
        if (this.orQueries == null) {
            this.orQueries = new ArrayList<TaskQueryDto>();
        }
        this.orQueries.add(orQueriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array of nested task queries with OR semantics. A task matches a nested query if it fulfills *at least one* of the query's predicates. With multiple nested queries, a task must fulfill at least one predicate of *each* query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All task query properties can be used except for: `sorting`, `withCandidateGroups`, `withoutCandidateGroups`, `withCandidateUsers`, `withoutCandidateUsers`  See the [User guide](https://docs.camunda.org/manual/7.19/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.")
    public List<TaskQueryDto> getOrQueries() {
        return this.orQueries;
    }

    public void setOrQueries(List<TaskQueryDto> orQueries) {
        this.orQueries = orQueries;
    }

    public TaskQueryDto sorting(List<TaskQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public TaskQueryDto addSortingItem(TaskQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<TaskQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply sorting of the result")
    public List<TaskQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<TaskQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskQueryDto taskQueryDto = (TaskQueryDto)o;
        return Objects.equals(this.taskId, taskQueryDto.taskId) && Objects.equals(this.taskIdIn, taskQueryDto.taskIdIn) && Objects.equals(this.processInstanceId, taskQueryDto.processInstanceId) && Objects.equals(this.processInstanceIdIn, taskQueryDto.processInstanceIdIn) && Objects.equals(this.processInstanceBusinessKey, taskQueryDto.processInstanceBusinessKey) && Objects.equals(this.processInstanceBusinessKeyExpression, taskQueryDto.processInstanceBusinessKeyExpression) && Objects.equals(this.processInstanceBusinessKeyIn, taskQueryDto.processInstanceBusinessKeyIn) && Objects.equals(this.processInstanceBusinessKeyLike, taskQueryDto.processInstanceBusinessKeyLike) && Objects.equals(this.processInstanceBusinessKeyLikeExpression, taskQueryDto.processInstanceBusinessKeyLikeExpression) && Objects.equals(this.processDefinitionId, taskQueryDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, taskQueryDto.processDefinitionKey) && Objects.equals(this.processDefinitionKeyIn, taskQueryDto.processDefinitionKeyIn) && Objects.equals(this.processDefinitionName, taskQueryDto.processDefinitionName) && Objects.equals(this.processDefinitionNameLike, taskQueryDto.processDefinitionNameLike) && Objects.equals(this.executionId, taskQueryDto.executionId) && Objects.equals(this.caseInstanceId, taskQueryDto.caseInstanceId) && Objects.equals(this.caseInstanceBusinessKey, taskQueryDto.caseInstanceBusinessKey) && Objects.equals(this.caseInstanceBusinessKeyLike, taskQueryDto.caseInstanceBusinessKeyLike) && Objects.equals(this.caseDefinitionId, taskQueryDto.caseDefinitionId) && Objects.equals(this.caseDefinitionKey, taskQueryDto.caseDefinitionKey) && Objects.equals(this.caseDefinitionName, taskQueryDto.caseDefinitionName) && Objects.equals(this.caseDefinitionNameLike, taskQueryDto.caseDefinitionNameLike) && Objects.equals(this.caseExecutionId, taskQueryDto.caseExecutionId) && Objects.equals(this.activityInstanceIdIn, taskQueryDto.activityInstanceIdIn) && Objects.equals(this.tenantIdIn, taskQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, taskQueryDto.withoutTenantId) && Objects.equals(this.assignee, taskQueryDto.assignee) && Objects.equals(this.assigneeExpression, taskQueryDto.assigneeExpression) && Objects.equals(this.assigneeLike, taskQueryDto.assigneeLike) && Objects.equals(this.assigneeLikeExpression, taskQueryDto.assigneeLikeExpression) && Objects.equals(this.assigneeIn, taskQueryDto.assigneeIn) && Objects.equals(this.assigneeNotIn, taskQueryDto.assigneeNotIn) && Objects.equals(this.owner, taskQueryDto.owner) && Objects.equals(this.ownerExpression, taskQueryDto.ownerExpression) && Objects.equals(this.candidateGroup, taskQueryDto.candidateGroup) && Objects.equals(this.candidateGroupExpression, taskQueryDto.candidateGroupExpression) && Objects.equals(this.candidateUser, taskQueryDto.candidateUser) && Objects.equals(this.candidateUserExpression, taskQueryDto.candidateUserExpression) && Objects.equals(this.includeAssignedTasks, taskQueryDto.includeAssignedTasks) && Objects.equals(this.involvedUser, taskQueryDto.involvedUser) && Objects.equals(this.involvedUserExpression, taskQueryDto.involvedUserExpression) && Objects.equals(this.assigned, taskQueryDto.assigned) && Objects.equals(this.unassigned, taskQueryDto.unassigned) && Objects.equals(this.taskDefinitionKey, taskQueryDto.taskDefinitionKey) && Objects.equals(this.taskDefinitionKeyIn, taskQueryDto.taskDefinitionKeyIn) && Objects.equals(this.taskDefinitionKeyLike, taskQueryDto.taskDefinitionKeyLike) && Objects.equals(this.name, taskQueryDto.name) && Objects.equals(this.nameNotEqual, taskQueryDto.nameNotEqual) && Objects.equals(this.nameLike, taskQueryDto.nameLike) && Objects.equals(this.nameNotLike, taskQueryDto.nameNotLike) && Objects.equals(this.description, taskQueryDto.description) && Objects.equals(this.descriptionLike, taskQueryDto.descriptionLike) && Objects.equals(this.priority, taskQueryDto.priority) && Objects.equals(this.maxPriority, taskQueryDto.maxPriority) && Objects.equals(this.minPriority, taskQueryDto.minPriority) && Objects.equals(this.dueDate, taskQueryDto.dueDate) && Objects.equals(this.dueDateExpression, taskQueryDto.dueDateExpression) && Objects.equals(this.dueAfter, taskQueryDto.dueAfter) && Objects.equals(this.dueAfterExpression, taskQueryDto.dueAfterExpression) && Objects.equals(this.dueBefore, taskQueryDto.dueBefore) && Objects.equals(this.dueBeforeExpression, taskQueryDto.dueBeforeExpression) && Objects.equals(this.withoutDueDate, taskQueryDto.withoutDueDate) && Objects.equals(this.followUpDate, taskQueryDto.followUpDate) && Objects.equals(this.followUpDateExpression, taskQueryDto.followUpDateExpression) && Objects.equals(this.followUpAfter, taskQueryDto.followUpAfter) && Objects.equals(this.followUpAfterExpression, taskQueryDto.followUpAfterExpression) && Objects.equals(this.followUpBefore, taskQueryDto.followUpBefore) && Objects.equals(this.followUpBeforeExpression, taskQueryDto.followUpBeforeExpression) && Objects.equals(this.followUpBeforeOrNotExistent, taskQueryDto.followUpBeforeOrNotExistent) && Objects.equals(this.followUpBeforeOrNotExistentExpression, taskQueryDto.followUpBeforeOrNotExistentExpression) && Objects.equals(this.createdOn, taskQueryDto.createdOn) && Objects.equals(this.createdOnExpression, taskQueryDto.createdOnExpression) && Objects.equals(this.createdAfter, taskQueryDto.createdAfter) && Objects.equals(this.createdAfterExpression, taskQueryDto.createdAfterExpression) && Objects.equals(this.createdBefore, taskQueryDto.createdBefore) && Objects.equals(this.createdBeforeExpression, taskQueryDto.createdBeforeExpression) && Objects.equals(this.updatedAfter, taskQueryDto.updatedAfter) && Objects.equals(this.updatedAfterExpression, taskQueryDto.updatedAfterExpression) && Objects.equals((Object)this.delegationState, (Object)taskQueryDto.delegationState) && Objects.equals(this.candidateGroups, taskQueryDto.candidateGroups) && Objects.equals(this.candidateGroupsExpression, taskQueryDto.candidateGroupsExpression) && Objects.equals(this.withCandidateGroups, taskQueryDto.withCandidateGroups) && Objects.equals(this.withoutCandidateGroups, taskQueryDto.withoutCandidateGroups) && Objects.equals(this.withCandidateUsers, taskQueryDto.withCandidateUsers) && Objects.equals(this.withoutCandidateUsers, taskQueryDto.withoutCandidateUsers) && Objects.equals(this.active, taskQueryDto.active) && Objects.equals(this.suspended, taskQueryDto.suspended) && Objects.equals(this.taskVariables, taskQueryDto.taskVariables) && Objects.equals(this.processVariables, taskQueryDto.processVariables) && Objects.equals(this.caseInstanceVariables, taskQueryDto.caseInstanceVariables) && Objects.equals(this.variableNamesIgnoreCase, taskQueryDto.variableNamesIgnoreCase) && Objects.equals(this.variableValuesIgnoreCase, taskQueryDto.variableValuesIgnoreCase) && Objects.equals(this.parentTaskId, taskQueryDto.parentTaskId) && Objects.equals(this.orQueries, taskQueryDto.orQueries) && Objects.equals(this.sorting, taskQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taskId, this.taskIdIn, this.processInstanceId, this.processInstanceIdIn, this.processInstanceBusinessKey, this.processInstanceBusinessKeyExpression, this.processInstanceBusinessKeyIn, this.processInstanceBusinessKeyLike, this.processInstanceBusinessKeyLikeExpression, this.processDefinitionId, this.processDefinitionKey, this.processDefinitionKeyIn, this.processDefinitionName, this.processDefinitionNameLike, this.executionId, this.caseInstanceId, this.caseInstanceBusinessKey, this.caseInstanceBusinessKeyLike, this.caseDefinitionId, this.caseDefinitionKey, this.caseDefinitionName, this.caseDefinitionNameLike, this.caseExecutionId, this.activityInstanceIdIn, this.tenantIdIn, this.withoutTenantId, this.assignee, this.assigneeExpression, this.assigneeLike, this.assigneeLikeExpression, this.assigneeIn, this.assigneeNotIn, this.owner, this.ownerExpression, this.candidateGroup, this.candidateGroupExpression, this.candidateUser, this.candidateUserExpression, this.includeAssignedTasks, this.involvedUser, this.involvedUserExpression, this.assigned, this.unassigned, this.taskDefinitionKey, this.taskDefinitionKeyIn, this.taskDefinitionKeyLike, this.name, this.nameNotEqual, this.nameLike, this.nameNotLike, this.description, this.descriptionLike, this.priority, this.maxPriority, this.minPriority, this.dueDate, this.dueDateExpression, this.dueAfter, this.dueAfterExpression, this.dueBefore, this.dueBeforeExpression, this.withoutDueDate, this.followUpDate, this.followUpDateExpression, this.followUpAfter, this.followUpAfterExpression, this.followUpBefore, this.followUpBeforeExpression, this.followUpBeforeOrNotExistent, this.followUpBeforeOrNotExistentExpression, this.createdOn, this.createdOnExpression, this.createdAfter, this.createdAfterExpression, this.createdBefore, this.createdBeforeExpression, this.updatedAfter, this.updatedAfterExpression, this.delegationState, this.candidateGroups, this.candidateGroupsExpression, this.withCandidateGroups, this.withoutCandidateGroups, this.withCandidateUsers, this.withoutCandidateUsers, this.active, this.suspended, this.taskVariables, this.processVariables, this.caseInstanceVariables, this.variableNamesIgnoreCase, this.variableValuesIgnoreCase, this.parentTaskId, this.orQueries, this.sorting});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskQueryDto {\n");
        sb.append("    taskId: ").append(this.toIndentedString(this.taskId)).append("\n");
        sb.append("    taskIdIn: ").append(this.toIndentedString(this.taskIdIn)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processInstanceIdIn: ").append(this.toIndentedString(this.processInstanceIdIn)).append("\n");
        sb.append("    processInstanceBusinessKey: ").append(this.toIndentedString(this.processInstanceBusinessKey)).append("\n");
        sb.append("    processInstanceBusinessKeyExpression: ").append(this.toIndentedString(this.processInstanceBusinessKeyExpression)).append("\n");
        sb.append("    processInstanceBusinessKeyIn: ").append(this.toIndentedString(this.processInstanceBusinessKeyIn)).append("\n");
        sb.append("    processInstanceBusinessKeyLike: ").append(this.toIndentedString(this.processInstanceBusinessKeyLike)).append("\n");
        sb.append("    processInstanceBusinessKeyLikeExpression: ").append(this.toIndentedString(this.processInstanceBusinessKeyLikeExpression)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionKeyIn: ").append(this.toIndentedString(this.processDefinitionKeyIn)).append("\n");
        sb.append("    processDefinitionName: ").append(this.toIndentedString(this.processDefinitionName)).append("\n");
        sb.append("    processDefinitionNameLike: ").append(this.toIndentedString(this.processDefinitionNameLike)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    caseInstanceBusinessKey: ").append(this.toIndentedString(this.caseInstanceBusinessKey)).append("\n");
        sb.append("    caseInstanceBusinessKeyLike: ").append(this.toIndentedString(this.caseInstanceBusinessKeyLike)).append("\n");
        sb.append("    caseDefinitionId: ").append(this.toIndentedString(this.caseDefinitionId)).append("\n");
        sb.append("    caseDefinitionKey: ").append(this.toIndentedString(this.caseDefinitionKey)).append("\n");
        sb.append("    caseDefinitionName: ").append(this.toIndentedString(this.caseDefinitionName)).append("\n");
        sb.append("    caseDefinitionNameLike: ").append(this.toIndentedString(this.caseDefinitionNameLike)).append("\n");
        sb.append("    caseExecutionId: ").append(this.toIndentedString(this.caseExecutionId)).append("\n");
        sb.append("    activityInstanceIdIn: ").append(this.toIndentedString(this.activityInstanceIdIn)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    assigneeExpression: ").append(this.toIndentedString(this.assigneeExpression)).append("\n");
        sb.append("    assigneeLike: ").append(this.toIndentedString(this.assigneeLike)).append("\n");
        sb.append("    assigneeLikeExpression: ").append(this.toIndentedString(this.assigneeLikeExpression)).append("\n");
        sb.append("    assigneeIn: ").append(this.toIndentedString(this.assigneeIn)).append("\n");
        sb.append("    assigneeNotIn: ").append(this.toIndentedString(this.assigneeNotIn)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    ownerExpression: ").append(this.toIndentedString(this.ownerExpression)).append("\n");
        sb.append("    candidateGroup: ").append(this.toIndentedString(this.candidateGroup)).append("\n");
        sb.append("    candidateGroupExpression: ").append(this.toIndentedString(this.candidateGroupExpression)).append("\n");
        sb.append("    candidateUser: ").append(this.toIndentedString(this.candidateUser)).append("\n");
        sb.append("    candidateUserExpression: ").append(this.toIndentedString(this.candidateUserExpression)).append("\n");
        sb.append("    includeAssignedTasks: ").append(this.toIndentedString(this.includeAssignedTasks)).append("\n");
        sb.append("    involvedUser: ").append(this.toIndentedString(this.involvedUser)).append("\n");
        sb.append("    involvedUserExpression: ").append(this.toIndentedString(this.involvedUserExpression)).append("\n");
        sb.append("    assigned: ").append(this.toIndentedString(this.assigned)).append("\n");
        sb.append("    unassigned: ").append(this.toIndentedString(this.unassigned)).append("\n");
        sb.append("    taskDefinitionKey: ").append(this.toIndentedString(this.taskDefinitionKey)).append("\n");
        sb.append("    taskDefinitionKeyIn: ").append(this.toIndentedString(this.taskDefinitionKeyIn)).append("\n");
        sb.append("    taskDefinitionKeyLike: ").append(this.toIndentedString(this.taskDefinitionKeyLike)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nameNotEqual: ").append(this.toIndentedString(this.nameNotEqual)).append("\n");
        sb.append("    nameLike: ").append(this.toIndentedString(this.nameLike)).append("\n");
        sb.append("    nameNotLike: ").append(this.toIndentedString(this.nameNotLike)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    descriptionLike: ").append(this.toIndentedString(this.descriptionLike)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    maxPriority: ").append(this.toIndentedString(this.maxPriority)).append("\n");
        sb.append("    minPriority: ").append(this.toIndentedString(this.minPriority)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    dueDateExpression: ").append(this.toIndentedString(this.dueDateExpression)).append("\n");
        sb.append("    dueAfter: ").append(this.toIndentedString(this.dueAfter)).append("\n");
        sb.append("    dueAfterExpression: ").append(this.toIndentedString(this.dueAfterExpression)).append("\n");
        sb.append("    dueBefore: ").append(this.toIndentedString(this.dueBefore)).append("\n");
        sb.append("    dueBeforeExpression: ").append(this.toIndentedString(this.dueBeforeExpression)).append("\n");
        sb.append("    withoutDueDate: ").append(this.toIndentedString(this.withoutDueDate)).append("\n");
        sb.append("    followUpDate: ").append(this.toIndentedString(this.followUpDate)).append("\n");
        sb.append("    followUpDateExpression: ").append(this.toIndentedString(this.followUpDateExpression)).append("\n");
        sb.append("    followUpAfter: ").append(this.toIndentedString(this.followUpAfter)).append("\n");
        sb.append("    followUpAfterExpression: ").append(this.toIndentedString(this.followUpAfterExpression)).append("\n");
        sb.append("    followUpBefore: ").append(this.toIndentedString(this.followUpBefore)).append("\n");
        sb.append("    followUpBeforeExpression: ").append(this.toIndentedString(this.followUpBeforeExpression)).append("\n");
        sb.append("    followUpBeforeOrNotExistent: ").append(this.toIndentedString(this.followUpBeforeOrNotExistent)).append("\n");
        sb.append("    followUpBeforeOrNotExistentExpression: ").append(this.toIndentedString(this.followUpBeforeOrNotExistentExpression)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    createdOnExpression: ").append(this.toIndentedString(this.createdOnExpression)).append("\n");
        sb.append("    createdAfter: ").append(this.toIndentedString(this.createdAfter)).append("\n");
        sb.append("    createdAfterExpression: ").append(this.toIndentedString(this.createdAfterExpression)).append("\n");
        sb.append("    createdBefore: ").append(this.toIndentedString(this.createdBefore)).append("\n");
        sb.append("    createdBeforeExpression: ").append(this.toIndentedString(this.createdBeforeExpression)).append("\n");
        sb.append("    updatedAfter: ").append(this.toIndentedString(this.updatedAfter)).append("\n");
        sb.append("    updatedAfterExpression: ").append(this.toIndentedString(this.updatedAfterExpression)).append("\n");
        sb.append("    delegationState: ").append(this.toIndentedString((Object)this.delegationState)).append("\n");
        sb.append("    candidateGroups: ").append(this.toIndentedString(this.candidateGroups)).append("\n");
        sb.append("    candidateGroupsExpression: ").append(this.toIndentedString(this.candidateGroupsExpression)).append("\n");
        sb.append("    withCandidateGroups: ").append(this.toIndentedString(this.withCandidateGroups)).append("\n");
        sb.append("    withoutCandidateGroups: ").append(this.toIndentedString(this.withoutCandidateGroups)).append("\n");
        sb.append("    withCandidateUsers: ").append(this.toIndentedString(this.withCandidateUsers)).append("\n");
        sb.append("    withoutCandidateUsers: ").append(this.toIndentedString(this.withoutCandidateUsers)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    taskVariables: ").append(this.toIndentedString(this.taskVariables)).append("\n");
        sb.append("    processVariables: ").append(this.toIndentedString(this.processVariables)).append("\n");
        sb.append("    caseInstanceVariables: ").append(this.toIndentedString(this.caseInstanceVariables)).append("\n");
        sb.append("    variableNamesIgnoreCase: ").append(this.toIndentedString(this.variableNamesIgnoreCase)).append("\n");
        sb.append("    variableValuesIgnoreCase: ").append(this.toIndentedString(this.variableValuesIgnoreCase)).append("\n");
        sb.append("    parentTaskId: ").append(this.toIndentedString(this.parentTaskId)).append("\n");
        sb.append("    orQueries: ").append(this.toIndentedString(this.orQueries)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DelegationStateEnum {
        PENDING("PENDING"),
        RESOLVED("RESOLVED");

        private String value;

        private DelegationStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DelegationStateEnum fromValue(String value) {
            for (DelegationStateEnum b : DelegationStateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DelegationStateEnum> {
            public void write(JsonWriter jsonWriter, DelegationStateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DelegationStateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DelegationStateEnum.fromValue(value);
            }
        }
    }
}

