/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CleanableHistoricBatchReportResultDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricBatchDto;
import org.camunda.community.rest.client.dto.SetRemovalTimeToHistoricBatchesDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricBatchApi {
    private ApiClient localVarApiClient;

    public HistoricBatchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricBatchApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for deleteHistoricBatch
     * @param id The id of the batch to be deleted. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteHistoricBatchCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/batch/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteHistoricBatchValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteHistoricBatch(Async)");
        }
        

        okhttp3.Call localVarCall = deleteHistoricBatchCall(id, _callback);
        return localVarCall;

    }

    /**
     * Delete Historic Batch
     * Deletes a historic batch by id, including related historic job logs.
     * @param id The id of the batch to be deleted. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteHistoricBatch(String id) throws ApiException {
        deleteHistoricBatchWithHttpInfo(id);
    }

    /**
     * Delete Historic Batch
     * Deletes a historic batch by id, including related historic job logs.
     * @param id The id of the batch to be deleted. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteHistoricBatchWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = deleteHistoricBatchValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete Historic Batch (asynchronously)
     * Deletes a historic batch by id, including related historic job logs.
     * @param id The id of the batch to be deleted. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteHistoricBatchAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteHistoricBatchValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getCleanableHistoricBatchesReport
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCleanableHistoricBatchesReportCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/batch/cleanable-batch-report";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCleanableHistoricBatchesReportValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getCleanableHistoricBatchesReportCall(sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Cleanable Batch Report
     * Retrieves a report about a historic batch operations relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup) ) so that you can tune the history time to live. These reports include the count of the finished batches, cleanable batches and type of the batch. The size of the result set can be retrieved by using the [Get Cleanable Batch Report Count](https://docs.camunda.org/manual/7.20/reference/rest/history/batch/get-cleanable-batch-report-count/) method.  **Please note:** The history time to live for batch operations does not support [Multi-Tenancy](https://docs.camunda.org/manual/7.20/user-guide/process-engine/multi-tenancy.md). The report will return an information for all batch operations (for all tenants) if you have permissions to see the history. 
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;CleanableHistoricBatchReportResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<CleanableHistoricBatchReportResultDto> getCleanableHistoricBatchesReport(String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<CleanableHistoricBatchReportResultDto>> localVarResp = getCleanableHistoricBatchesReportWithHttpInfo(sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Cleanable Batch Report
     * Retrieves a report about a historic batch operations relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup) ) so that you can tune the history time to live. These reports include the count of the finished batches, cleanable batches and type of the batch. The size of the result set can be retrieved by using the [Get Cleanable Batch Report Count](https://docs.camunda.org/manual/7.20/reference/rest/history/batch/get-cleanable-batch-report-count/) method.  **Please note:** The history time to live for batch operations does not support [Multi-Tenancy](https://docs.camunda.org/manual/7.20/user-guide/process-engine/multi-tenancy.md). The report will return an information for all batch operations (for all tenants) if you have permissions to see the history. 
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;CleanableHistoricBatchReportResultDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CleanableHistoricBatchReportResultDto>> getCleanableHistoricBatchesReportWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getCleanableHistoricBatchesReportValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<CleanableHistoricBatchReportResultDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Cleanable Batch Report (asynchronously)
     * Retrieves a report about a historic batch operations relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup) ) so that you can tune the history time to live. These reports include the count of the finished batches, cleanable batches and type of the batch. The size of the result set can be retrieved by using the [Get Cleanable Batch Report Count](https://docs.camunda.org/manual/7.20/reference/rest/history/batch/get-cleanable-batch-report-count/) method.  **Please note:** The history time to live for batch operations does not support [Multi-Tenancy](https://docs.camunda.org/manual/7.20/user-guide/process-engine/multi-tenancy.md). The report will return an information for all batch operations (for all tenants) if you have permissions to see the history. 
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCleanableHistoricBatchesReportAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<CleanableHistoricBatchReportResultDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCleanableHistoricBatchesReportValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<CleanableHistoricBatchReportResultDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getCleanableHistoricBatchesReportCount
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCleanableHistoricBatchesReportCountCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/batch/cleanable-batch-report/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCleanableHistoricBatchesReportCountValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getCleanableHistoricBatchesReportCountCall(sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Cleanable Batch Report Count
     * Queries for the number of report results about a historic batch operations relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup) ). Takes the same parameters as the [Get Cleanable Batch Report](https://docs.camunda.org/manual/7.20/reference/rest/history/batch/get-cleanable-batch-report/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getCleanableHistoricBatchesReportCount(String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getCleanableHistoricBatchesReportCountWithHttpInfo(sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Cleanable Batch Report Count
     * Queries for the number of report results about a historic batch operations relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup) ). Takes the same parameters as the [Get Cleanable Batch Report](https://docs.camunda.org/manual/7.20/reference/rest/history/batch/get-cleanable-batch-report/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getCleanableHistoricBatchesReportCountWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getCleanableHistoricBatchesReportCountValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Cleanable Batch Report Count (asynchronously)
     * Queries for the number of report results about a historic batch operations relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup) ). Takes the same parameters as the [Get Cleanable Batch Report](https://docs.camunda.org/manual/7.20/reference/rest/history/batch/get-cleanable-batch-report/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCleanableHistoricBatchesReportCountAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getCleanableHistoricBatchesReportCountValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricBatch
     * @param id The id of the historic batch to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Historic batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricBatchCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/batch/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricBatchValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getHistoricBatch(Async)");
        }
        

        okhttp3.Call localVarCall = getHistoricBatchCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Historic Batch
     * Retrieves a historic batch by id, according to the &#x60;HistoricBatch&#x60; interface in the engine.
     * @param id The id of the historic batch to be retrieved. (required)
     * @return HistoricBatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Historic batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public HistoricBatchDto getHistoricBatch(String id) throws ApiException {
        ApiResponse<HistoricBatchDto> localVarResp = getHistoricBatchWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Historic Batch
     * Retrieves a historic batch by id, according to the &#x60;HistoricBatch&#x60; interface in the engine.
     * @param id The id of the historic batch to be retrieved. (required)
     * @return ApiResponse&lt;HistoricBatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Historic batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HistoricBatchDto> getHistoricBatchWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getHistoricBatchValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<HistoricBatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Historic Batch (asynchronously)
     * Retrieves a historic batch by id, according to the &#x60;HistoricBatch&#x60; interface in the engine.
     * @param id The id of the historic batch to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td>  Historic batch with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricBatchAsync(String id, final ApiCallback<HistoricBatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricBatchValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<HistoricBatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricBatches
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param completed  Filter completed or not completed batches. If the value is &#x60;true&#x60;, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is &#x60;false&#x60;, only running batches, i.e., end time is null, are returned. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricBatchesCall(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/batch";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (batchId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("batchId", batchId));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (completed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("completed", completed));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricBatchesValidateBeforeCall(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricBatchesCall(batchId, type, completed, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Historic Batches
     * Queries for historic batches that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the [Get Historic Batch Count](https://docs.camunda.org/manual/7.20/reference/rest/history/batch/get-query-count/) method.
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param completed  Filter completed or not completed batches. If the value is &#x60;true&#x60;, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is &#x60;false&#x60;, only running batches, i.e., end time is null, are returned. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;HistoricBatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricBatchDto> getHistoricBatches(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<HistoricBatchDto>> localVarResp = getHistoricBatchesWithHttpInfo(batchId, type, completed, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Historic Batches
     * Queries for historic batches that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the [Get Historic Batch Count](https://docs.camunda.org/manual/7.20/reference/rest/history/batch/get-query-count/) method.
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param completed  Filter completed or not completed batches. If the value is &#x60;true&#x60;, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is &#x60;false&#x60;, only running batches, i.e., end time is null, are returned. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;HistoricBatchDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricBatchDto>> getHistoricBatchesWithHttpInfo(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getHistoricBatchesValidateBeforeCall(batchId, type, completed, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<HistoricBatchDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Historic Batches (asynchronously)
     * Queries for historic batches that fulfill given parameters. Parameters may be the properties of batches, such as the id or type. The size of the result set can be retrieved by using the [Get Historic Batch Count](https://docs.camunda.org/manual/7.20/reference/rest/history/batch/get-query-count/) method.
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param completed  Filter completed or not completed batches. If the value is &#x60;true&#x60;, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is &#x60;false&#x60;, only running batches, i.e., end time is null, are returned. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricBatchesAsync(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<HistoricBatchDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricBatchesValidateBeforeCall(batchId, type, completed, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricBatchDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricBatchesCount
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param completed  Filter completed or not completed batches. If the value is &#x60;true&#x60;, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is &#x60;false&#x60;, only running batches, i.e., end time is null, are returned. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricBatchesCountCall(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/batch/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (batchId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("batchId", batchId));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (completed != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("completed", completed));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricBatchesCountValidateBeforeCall(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricBatchesCountCall(batchId, type, completed, tenantIdIn, withoutTenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Historic Batch Count
     * Requests the number of historic batches that fulfill the query criteria. Takes the same filtering parameters as the [Get Historic Batches](https://docs.camunda.org/manual/7.20/reference/rest/history/batch/get-query/) method.
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param completed  Filter completed or not completed batches. If the value is &#x60;true&#x60;, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is &#x60;false&#x60;, only running batches, i.e., end time is null, are returned. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getHistoricBatchesCount(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getHistoricBatchesCountWithHttpInfo(batchId, type, completed, tenantIdIn, withoutTenantId);
        return localVarResp.getData();
    }

    /**
     * Get Historic Batch Count
     * Requests the number of historic batches that fulfill the query criteria. Takes the same filtering parameters as the [Get Historic Batches](https://docs.camunda.org/manual/7.20/reference/rest/history/batch/get-query/) method.
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param completed  Filter completed or not completed batches. If the value is &#x60;true&#x60;, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is &#x60;false&#x60;, only running batches, i.e., end time is null, are returned. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getHistoricBatchesCountWithHttpInfo(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        okhttp3.Call localVarCall = getHistoricBatchesCountValidateBeforeCall(batchId, type, completed, tenantIdIn, withoutTenantId, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Historic Batch Count (asynchronously)
     * Requests the number of historic batches that fulfill the query criteria. Takes the same filtering parameters as the [Get Historic Batches](https://docs.camunda.org/manual/7.20/reference/rest/history/batch/get-query/) method.
     * @param batchId Filter by batch id. (optional)
     * @param type Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types. (optional)
     * @param completed  Filter completed or not completed batches. If the value is &#x60;true&#x60;, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is &#x60;false&#x60;, only running batches, i.e., end time is null, are returned. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids. (optional)
     * @param withoutTenantId Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricBatchesCountAsync(String batchId, String type, Boolean completed, String tenantIdIn, Boolean withoutTenantId, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricBatchesCountValidateBeforeCall(batchId, type, completed, tenantIdIn, withoutTenantId, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for setRemovalTimeAsyncHistoricBatch
     * @param setRemovalTimeToHistoricBatchesDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Request was unsuccessful due to a bad user request. This occurs if some of the query parameters are invalid, e.g. if neither historicBatchIds nor historicBatchQuery is present or if no mode is specified.  See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setRemovalTimeAsyncHistoricBatchCall(SetRemovalTimeToHistoricBatchesDto setRemovalTimeToHistoricBatchesDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = setRemovalTimeToHistoricBatchesDto;

        // create path and map variables
        String localVarPath = "/history/batch/set-removal-time";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setRemovalTimeAsyncHistoricBatchValidateBeforeCall(SetRemovalTimeToHistoricBatchesDto setRemovalTimeToHistoricBatchesDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = setRemovalTimeAsyncHistoricBatchCall(setRemovalTimeToHistoricBatchesDto, _callback);
        return localVarCall;

    }

    /**
     * Set Removal Time Async (POST)
     * Sets the removal time to multiple historic batches asynchronously (batch).  At least __historicBatchIds__ or __historicBatchQuery__ has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
     * @param setRemovalTimeToHistoricBatchesDto  (optional)
     * @return BatchDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Request was unsuccessful due to a bad user request. This occurs if some of the query parameters are invalid, e.g. if neither historicBatchIds nor historicBatchQuery is present or if no mode is specified.  See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public BatchDto setRemovalTimeAsyncHistoricBatch(SetRemovalTimeToHistoricBatchesDto setRemovalTimeToHistoricBatchesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = setRemovalTimeAsyncHistoricBatchWithHttpInfo(setRemovalTimeToHistoricBatchesDto);
        return localVarResp.getData();
    }

    /**
     * Set Removal Time Async (POST)
     * Sets the removal time to multiple historic batches asynchronously (batch).  At least __historicBatchIds__ or __historicBatchQuery__ has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
     * @param setRemovalTimeToHistoricBatchesDto  (optional)
     * @return ApiResponse&lt;BatchDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Request was unsuccessful due to a bad user request. This occurs if some of the query parameters are invalid, e.g. if neither historicBatchIds nor historicBatchQuery is present or if no mode is specified.  See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<BatchDto> setRemovalTimeAsyncHistoricBatchWithHttpInfo(SetRemovalTimeToHistoricBatchesDto setRemovalTimeToHistoricBatchesDto) throws ApiException {
        okhttp3.Call localVarCall = setRemovalTimeAsyncHistoricBatchValidateBeforeCall(setRemovalTimeToHistoricBatchesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Set Removal Time Async (POST) (asynchronously)
     * Sets the removal time to multiple historic batches asynchronously (batch).  At least __historicBatchIds__ or __historicBatchQuery__ has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.
     * @param setRemovalTimeToHistoricBatchesDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td>  Request was unsuccessful due to a bad user request. This occurs if some of the query parameters are invalid, e.g. if neither historicBatchIds nor historicBatchQuery is present or if no mode is specified.  See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format.  </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setRemovalTimeAsyncHistoricBatchAsync(SetRemovalTimeToHistoricBatchesDto setRemovalTimeToHistoricBatchesDto, final ApiCallback<BatchDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = setRemovalTimeAsyncHistoricBatchValidateBeforeCall(setRemovalTimeToHistoricBatchesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
