/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricDecisionInstanceStatisticsDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricDecisionRequirementsDefinitionApi {
    private ApiClient localVarApiClient;

    public HistoricDecisionRequirementsDefinitionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricDecisionRequirementsDefinitionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getDecisionStatistics
     * @param id The id of the decision requirements definition. (required)
     * @param decisionInstanceId Restrict query results to be based only on specific evaluation instance of a given decision requirements definition. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionStatisticsCall(String id, String decisionInstanceId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/decision-requirements-definition/{id}/statistics"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (decisionInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decisionInstanceId", decisionInstanceId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDecisionStatisticsValidateBeforeCall(String id, String decisionInstanceId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDecisionStatistics(Async)");
        }
        

        okhttp3.Call localVarCall = getDecisionStatisticsCall(id, decisionInstanceId, _callback);
        return localVarCall;

    }

    /**
     * Get DRD Statistics
     * Retrieves evaluation statistics of a given decision requirements definition.
     * @param id The id of the decision requirements definition. (required)
     * @param decisionInstanceId Restrict query results to be based only on specific evaluation instance of a given decision requirements definition. (optional)
     * @return List&lt;HistoricDecisionInstanceStatisticsDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricDecisionInstanceStatisticsDto> getDecisionStatistics(String id, String decisionInstanceId) throws ApiException {
        ApiResponse<List<HistoricDecisionInstanceStatisticsDto>> localVarResp = getDecisionStatisticsWithHttpInfo(id, decisionInstanceId);
        return localVarResp.getData();
    }

    /**
     * Get DRD Statistics
     * Retrieves evaluation statistics of a given decision requirements definition.
     * @param id The id of the decision requirements definition. (required)
     * @param decisionInstanceId Restrict query results to be based only on specific evaluation instance of a given decision requirements definition. (optional)
     * @return ApiResponse&lt;List&lt;HistoricDecisionInstanceStatisticsDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricDecisionInstanceStatisticsDto>> getDecisionStatisticsWithHttpInfo(String id, String decisionInstanceId) throws ApiException {
        okhttp3.Call localVarCall = getDecisionStatisticsValidateBeforeCall(id, decisionInstanceId, null);
        Type localVarReturnType = new TypeToken<List<HistoricDecisionInstanceStatisticsDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get DRD Statistics (asynchronously)
     * Retrieves evaluation statistics of a given decision requirements definition.
     * @param id The id of the decision requirements definition. (required)
     * @param decisionInstanceId Restrict query results to be based only on specific evaluation instance of a given decision requirements definition. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDecisionStatisticsAsync(String id, String decisionInstanceId, final ApiCallback<List<HistoricDecisionInstanceStatisticsDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getDecisionStatisticsValidateBeforeCall(id, decisionInstanceId, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricDecisionInstanceStatisticsDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
