/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.CountResultDto;
import java.util.Date;
import org.camunda.community.rest.client.dto.ExceptionDto;
import java.io.File;
import org.camunda.community.rest.client.dto.HistoricDetailDto;
import org.camunda.community.rest.client.dto.HistoricDetailQueryDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricDetailApi {
    private ApiClient localVarApiClient;

    public HistoricDetailApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricDetailApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getHistoricDetails
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIdIn Only include historic details which belong to one of the passed comma-separated process instance ids. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param taskId Filter by task id. (optional)
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param variableInstanceId Filter by variable instance id. (optional)
     * @param variableTypeIn Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.20/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param userOperationId Filter by a user operation id. (optional)
     * @param formFields Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableUpdates Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param excludeTaskDetails Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param initial Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param occurredBefore Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param occurredAfter Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricDetailsCall(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, Date occurredBefore, Date occurredAfter, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/detail";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (taskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskId", taskId));
        }

        if (activityInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceId", activityInstanceId));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (caseExecutionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseExecutionId", caseExecutionId));
        }

        if (variableInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableInstanceId", variableInstanceId));
        }

        if (variableTypeIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableTypeIn", variableTypeIn));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (userOperationId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userOperationId", userOperationId));
        }

        if (formFields != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("formFields", formFields));
        }

        if (variableUpdates != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableUpdates", variableUpdates));
        }

        if (excludeTaskDetails != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("excludeTaskDetails", excludeTaskDetails));
        }

        if (initial != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("initial", initial));
        }

        if (occurredBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("occurredBefore", occurredBefore));
        }

        if (occurredAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("occurredAfter", occurredAfter));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (deserializeValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricDetailsValidateBeforeCall(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, Date occurredBefore, Date occurredAfter, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricDetailsCall(processInstanceId, processInstanceIdIn, executionId, taskId, activityInstanceId, caseInstanceId, caseExecutionId, variableInstanceId, variableTypeIn, tenantIdIn, withoutTenantId, userOperationId, formFields, variableUpdates, excludeTaskDetails, initial, occurredBefore, occurredAfter, sortBy, sortOrder, firstResult, maxResults, deserializeValues, _callback);
        return localVarCall;

    }

    /**
     * Get Historic Details
     * Queries for historic details that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.20/reference/rest/history/detail/get-detail-query-count/) method.
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIdIn Only include historic details which belong to one of the passed comma-separated process instance ids. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param taskId Filter by task id. (optional)
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param variableInstanceId Filter by variable instance id. (optional)
     * @param variableTypeIn Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.20/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param userOperationId Filter by a user operation id. (optional)
     * @param formFields Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableUpdates Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param excludeTaskDetails Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param initial Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param occurredBefore Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param occurredAfter Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @return List&lt;HistoricDetailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricDetailDto> getHistoricDetails(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, Date occurredBefore, Date occurredAfter, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues) throws ApiException {
        ApiResponse<List<HistoricDetailDto>> localVarResp = getHistoricDetailsWithHttpInfo(processInstanceId, processInstanceIdIn, executionId, taskId, activityInstanceId, caseInstanceId, caseExecutionId, variableInstanceId, variableTypeIn, tenantIdIn, withoutTenantId, userOperationId, formFields, variableUpdates, excludeTaskDetails, initial, occurredBefore, occurredAfter, sortBy, sortOrder, firstResult, maxResults, deserializeValues);
        return localVarResp.getData();
    }

    /**
     * Get Historic Details
     * Queries for historic details that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.20/reference/rest/history/detail/get-detail-query-count/) method.
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIdIn Only include historic details which belong to one of the passed comma-separated process instance ids. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param taskId Filter by task id. (optional)
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param variableInstanceId Filter by variable instance id. (optional)
     * @param variableTypeIn Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.20/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param userOperationId Filter by a user operation id. (optional)
     * @param formFields Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableUpdates Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param excludeTaskDetails Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param initial Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param occurredBefore Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param occurredAfter Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @return ApiResponse&lt;List&lt;HistoricDetailDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricDetailDto>> getHistoricDetailsWithHttpInfo(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, Date occurredBefore, Date occurredAfter, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues) throws ApiException {
        okhttp3.Call localVarCall = getHistoricDetailsValidateBeforeCall(processInstanceId, processInstanceIdIn, executionId, taskId, activityInstanceId, caseInstanceId, caseExecutionId, variableInstanceId, variableTypeIn, tenantIdIn, withoutTenantId, userOperationId, formFields, variableUpdates, excludeTaskDetails, initial, occurredBefore, occurredAfter, sortBy, sortOrder, firstResult, maxResults, deserializeValues, null);
        Type localVarReturnType = new TypeToken<List<HistoricDetailDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Historic Details (asynchronously)
     * Queries for historic details that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.20/reference/rest/history/detail/get-detail-query-count/) method.
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIdIn Only include historic details which belong to one of the passed comma-separated process instance ids. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param taskId Filter by task id. (optional)
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param variableInstanceId Filter by variable instance id. (optional)
     * @param variableTypeIn Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.20/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param userOperationId Filter by a user operation id. (optional)
     * @param formFields Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableUpdates Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param excludeTaskDetails Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param initial Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param occurredBefore Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param occurredAfter Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricDetailsAsync(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, Date occurredBefore, Date occurredAfter, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues, final ApiCallback<List<HistoricDetailDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricDetailsValidateBeforeCall(processInstanceId, processInstanceIdIn, executionId, taskId, activityInstanceId, caseInstanceId, caseExecutionId, variableInstanceId, variableTypeIn, tenantIdIn, withoutTenantId, userOperationId, formFields, variableUpdates, excludeTaskDetails, initial, occurredBefore, occurredAfter, sortBy, sortOrder, firstResult, maxResults, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricDetailDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricDetailsCount
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIdIn Only include historic details which belong to one of the passed comma-separated process instance ids. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param taskId Filter by task id. (optional)
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param variableInstanceId Filter by variable instance id. (optional)
     * @param variableTypeIn Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.20/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param userOperationId Filter by a user operation id. (optional)
     * @param formFields Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableUpdates Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param excludeTaskDetails Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param initial Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param occurredBefore Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param occurredAfter Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricDetailsCountCall(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, Date occurredBefore, Date occurredAfter, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/detail/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (taskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskId", taskId));
        }

        if (activityInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceId", activityInstanceId));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (caseExecutionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseExecutionId", caseExecutionId));
        }

        if (variableInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableInstanceId", variableInstanceId));
        }

        if (variableTypeIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableTypeIn", variableTypeIn));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (userOperationId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userOperationId", userOperationId));
        }

        if (formFields != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("formFields", formFields));
        }

        if (variableUpdates != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableUpdates", variableUpdates));
        }

        if (excludeTaskDetails != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("excludeTaskDetails", excludeTaskDetails));
        }

        if (initial != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("initial", initial));
        }

        if (occurredBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("occurredBefore", occurredBefore));
        }

        if (occurredAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("occurredAfter", occurredAfter));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricDetailsCountValidateBeforeCall(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, Date occurredBefore, Date occurredAfter, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricDetailsCountCall(processInstanceId, processInstanceIdIn, executionId, taskId, activityInstanceId, caseInstanceId, caseExecutionId, variableInstanceId, variableTypeIn, tenantIdIn, withoutTenantId, userOperationId, formFields, variableUpdates, excludeTaskDetails, initial, occurredBefore, occurredAfter, _callback);
        return localVarCall;

    }

    /**
     * Get Historic Detail Count
     * Queries for the number of historic details that fulfill the given parameters. Takes the same parameters as the [Get Historic Details](https://docs.camunda.org/manual/7.20/reference/rest/history/detail/get-detail-query/) method.
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIdIn Only include historic details which belong to one of the passed comma-separated process instance ids. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param taskId Filter by task id. (optional)
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param variableInstanceId Filter by variable instance id. (optional)
     * @param variableTypeIn Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.20/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param userOperationId Filter by a user operation id. (optional)
     * @param formFields Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableUpdates Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param excludeTaskDetails Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param initial Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param occurredBefore Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param occurredAfter Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getHistoricDetailsCount(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, Date occurredBefore, Date occurredAfter) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getHistoricDetailsCountWithHttpInfo(processInstanceId, processInstanceIdIn, executionId, taskId, activityInstanceId, caseInstanceId, caseExecutionId, variableInstanceId, variableTypeIn, tenantIdIn, withoutTenantId, userOperationId, formFields, variableUpdates, excludeTaskDetails, initial, occurredBefore, occurredAfter);
        return localVarResp.getData();
    }

    /**
     * Get Historic Detail Count
     * Queries for the number of historic details that fulfill the given parameters. Takes the same parameters as the [Get Historic Details](https://docs.camunda.org/manual/7.20/reference/rest/history/detail/get-detail-query/) method.
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIdIn Only include historic details which belong to one of the passed comma-separated process instance ids. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param taskId Filter by task id. (optional)
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param variableInstanceId Filter by variable instance id. (optional)
     * @param variableTypeIn Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.20/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param userOperationId Filter by a user operation id. (optional)
     * @param formFields Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableUpdates Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param excludeTaskDetails Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param initial Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param occurredBefore Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param occurredAfter Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getHistoricDetailsCountWithHttpInfo(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, Date occurredBefore, Date occurredAfter) throws ApiException {
        okhttp3.Call localVarCall = getHistoricDetailsCountValidateBeforeCall(processInstanceId, processInstanceIdIn, executionId, taskId, activityInstanceId, caseInstanceId, caseExecutionId, variableInstanceId, variableTypeIn, tenantIdIn, withoutTenantId, userOperationId, formFields, variableUpdates, excludeTaskDetails, initial, occurredBefore, occurredAfter, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Historic Detail Count (asynchronously)
     * Queries for the number of historic details that fulfill the given parameters. Takes the same parameters as the [Get Historic Details](https://docs.camunda.org/manual/7.20/reference/rest/history/detail/get-detail-query/) method.
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processInstanceIdIn Only include historic details which belong to one of the passed comma-separated process instance ids. (optional)
     * @param executionId Filter by execution id. (optional)
     * @param taskId Filter by task id. (optional)
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param caseInstanceId Filter by case instance id. (optional)
     * @param caseExecutionId Filter by case execution id. (optional)
     * @param variableInstanceId Filter by variable instance id. (optional)
     * @param variableTypeIn Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.20/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#x60;serializable&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic details that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param userOperationId Filter by a user operation id. (optional)
     * @param formFields Only include &#x60;HistoricFormFields&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableUpdates Only include &#x60;HistoricVariableUpdates&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param excludeTaskDetails Excludes all task-related &#x60;HistoricDetails&#x60;, so only items which have no task id set will be selected. When this parameter is used together with &#x60;taskId&#x60;, this call is ignored and task details are not excluded. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param initial Restrict to historic variable updates that contain only initial variable values. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param occurredBefore Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param occurredAfter Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., 2013-01-23T14:42:45.000+0200. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricDetailsCountAsync(String processInstanceId, String processInstanceIdIn, String executionId, String taskId, String activityInstanceId, String caseInstanceId, String caseExecutionId, String variableInstanceId, String variableTypeIn, String tenantIdIn, Boolean withoutTenantId, String userOperationId, Boolean formFields, Boolean variableUpdates, Boolean excludeTaskDetails, Boolean initial, Date occurredBefore, Date occurredAfter, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricDetailsCountValidateBeforeCall(processInstanceId, processInstanceIdIn, executionId, taskId, activityInstanceId, caseInstanceId, caseExecutionId, variableInstanceId, variableTypeIn, tenantIdIn, withoutTenantId, userOperationId, formFields, variableUpdates, excludeTaskDetails, initial, occurredBefore, occurredAfter, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for historicDetail
     * @param id The id of the detail. (required)
     * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call historicDetailCall(String id, Boolean deserializeValue, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/detail/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (deserializeValue != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValue", deserializeValue));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call historicDetailValidateBeforeCall(String id, Boolean deserializeValue, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling historicDetail(Async)");
        }
        

        okhttp3.Call localVarCall = historicDetailCall(id, deserializeValue, _callback);
        return localVarCall;

    }

    /**
     * Get Historic Detail
     * Retrieves a historic detail by id.
     * @param id The id of the detail. (required)
     * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @return HistoricDetailDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public HistoricDetailDto historicDetail(String id, Boolean deserializeValue) throws ApiException {
        ApiResponse<HistoricDetailDto> localVarResp = historicDetailWithHttpInfo(id, deserializeValue);
        return localVarResp.getData();
    }

    /**
     * Get Historic Detail
     * Retrieves a historic detail by id.
     * @param id The id of the detail. (required)
     * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @return ApiResponse&lt;HistoricDetailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HistoricDetailDto> historicDetailWithHttpInfo(String id, Boolean deserializeValue) throws ApiException {
        okhttp3.Call localVarCall = historicDetailValidateBeforeCall(id, deserializeValue, null);
        Type localVarReturnType = new TypeToken<HistoricDetailDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Historic Detail (asynchronously)
     * Retrieves a historic detail by id.
     * @param id The id of the detail. (required)
     * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call historicDetailAsync(String id, Boolean deserializeValue, final ApiCallback<HistoricDetailDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = historicDetailValidateBeforeCall(id, deserializeValue, _callback);
        Type localVarReturnType = new TypeToken<HistoricDetailDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for historicDetailBinary
     * @param id The id of the historic variable update. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Detail with given id exists but is not a binary variable. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Detail with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call historicDetailBinaryCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/detail/{id}/data"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/octet-stream", "*/*", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call historicDetailBinaryValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling historicDetailBinary(Async)");
        }
        

        okhttp3.Call localVarCall = historicDetailBinaryCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Historic Detail (Binary)
     * Retrieves the content of a historic variable update by id. Applicable for byte array and file variables.
     * @param id The id of the historic variable update. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Detail with given id exists but is not a binary variable. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Detail with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File historicDetailBinary(String id) throws ApiException {
        ApiResponse<File> localVarResp = historicDetailBinaryWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Historic Detail (Binary)
     * Retrieves the content of a historic variable update by id. Applicable for byte array and file variables.
     * @param id The id of the historic variable update. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Detail with given id exists but is not a binary variable. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Detail with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> historicDetailBinaryWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = historicDetailBinaryValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Historic Detail (Binary) (asynchronously)
     * Retrieves the content of a historic variable update by id. Applicable for byte array and file variables.
     * @param id The id of the historic variable update. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Detail with given id exists but is not a binary variable. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Detail with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call historicDetailBinaryAsync(String id, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = historicDetailBinaryValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricDetails
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param historicDetailQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricDetailsCall(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricDetailQueryDto historicDetailQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicDetailQueryDto;

        // create path and map variables
        String localVarPath = "/history/detail";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (deserializeValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricDetailsValidateBeforeCall(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricDetailQueryDto historicDetailQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricDetailsCall(firstResult, maxResults, deserializeValues, historicDetailQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Historic Details (POST)
     * Queries for historic details that fulfill the given parameters. This method is slightly more powerful than the [Get Historic Details](https://docs.camunda.org/manual/7.20/reference/rest/history/detail/get-detail-query/) method because it allows sorting by multiple parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.20/reference/rest/history/detail/get-detail-query-count/) method.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param historicDetailQueryDto  (optional)
     * @return List&lt;HistoricDetailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricDetailDto> queryHistoricDetails(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricDetailQueryDto historicDetailQueryDto) throws ApiException {
        ApiResponse<List<HistoricDetailDto>> localVarResp = queryHistoricDetailsWithHttpInfo(firstResult, maxResults, deserializeValues, historicDetailQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Historic Details (POST)
     * Queries for historic details that fulfill the given parameters. This method is slightly more powerful than the [Get Historic Details](https://docs.camunda.org/manual/7.20/reference/rest/history/detail/get-detail-query/) method because it allows sorting by multiple parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.20/reference/rest/history/detail/get-detail-query-count/) method.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param historicDetailQueryDto  (optional)
     * @return ApiResponse&lt;List&lt;HistoricDetailDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricDetailDto>> queryHistoricDetailsWithHttpInfo(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricDetailQueryDto historicDetailQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricDetailsValidateBeforeCall(firstResult, maxResults, deserializeValues, historicDetailQueryDto, null);
        Type localVarReturnType = new TypeToken<List<HistoricDetailDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Historic Details (POST) (asynchronously)
     * Queries for historic details that fulfill the given parameters. This method is slightly more powerful than the [Get Historic Details](https://docs.camunda.org/manual/7.20/reference/rest/history/detail/get-detail-query/) method because it allows sorting by multiple parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.20/reference/rest/history/detail/get-detail-query-count/) method.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param historicDetailQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricDetailsAsync(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricDetailQueryDto historicDetailQueryDto, final ApiCallback<List<HistoricDetailDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricDetailsValidateBeforeCall(firstResult, maxResults, deserializeValues, historicDetailQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricDetailDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
