/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.CountResultDto;
import java.util.Date;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricIdentityLinkLogDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricIdentityLinkLogApi {
    private ApiClient localVarApiClient;

    public HistoricIdentityLinkLogApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricIdentityLinkLogApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getHistoricIdentityLinks
     * @param type Restricts to identity links that have the given type (candidate/assignee/owner). (optional)
     * @param userId Restricts to identity links that have the given user id. (optional)
     * @param groupId Restricts to identity links that have the given group id. (optional)
     * @param dateBefore Restricts to identity links that have the time before the given time. (optional)
     * @param dateAfter Restricts to identity links that have the time after the given time. (optional)
     * @param taskId Restricts to identity links that have the given task id. (optional)
     * @param processDefinitionId Restricts to identity links that have the given process definition id. (optional)
     * @param processDefinitionKey Restricts to identity links that have the given process definition key. (optional)
     * @param operationType Restricts to identity links that have the given operationType (add/delete). (optional)
     * @param assignerId Restricts to identity links that have the given assigner id. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic identity links that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricIdentityLinksCall(String type, String userId, String groupId, Date dateBefore, Date dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/identity-link-log";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userId", userId));
        }

        if (groupId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("groupId", groupId));
        }

        if (dateBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("dateBefore", dateBefore));
        }

        if (dateAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("dateAfter", dateAfter));
        }

        if (taskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskId", taskId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (operationType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("operationType", operationType));
        }

        if (assignerId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("assignerId", assignerId));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricIdentityLinksValidateBeforeCall(String type, String userId, String groupId, Date dateBefore, Date dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricIdentityLinksCall(type, userId, groupId, dateBefore, dateAfter, taskId, processDefinitionId, processDefinitionKey, operationType, assignerId, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Identity Link Logs
     * Queries for historic identity link logs that fulfill given parameters. The size of the result set can be retrieved by using the [Get Identity-Link-Log Count](https://docs.camunda.org/manual/7.20/reference/rest/history/identity-links/get-identity-link-query-count/) method.
     * @param type Restricts to identity links that have the given type (candidate/assignee/owner). (optional)
     * @param userId Restricts to identity links that have the given user id. (optional)
     * @param groupId Restricts to identity links that have the given group id. (optional)
     * @param dateBefore Restricts to identity links that have the time before the given time. (optional)
     * @param dateAfter Restricts to identity links that have the time after the given time. (optional)
     * @param taskId Restricts to identity links that have the given task id. (optional)
     * @param processDefinitionId Restricts to identity links that have the given process definition id. (optional)
     * @param processDefinitionKey Restricts to identity links that have the given process definition key. (optional)
     * @param operationType Restricts to identity links that have the given operationType (add/delete). (optional)
     * @param assignerId Restricts to identity links that have the given assigner id. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic identity links that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;HistoricIdentityLinkLogDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricIdentityLinkLogDto> getHistoricIdentityLinks(String type, String userId, String groupId, Date dateBefore, Date dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<HistoricIdentityLinkLogDto>> localVarResp = getHistoricIdentityLinksWithHttpInfo(type, userId, groupId, dateBefore, dateAfter, taskId, processDefinitionId, processDefinitionKey, operationType, assignerId, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Identity Link Logs
     * Queries for historic identity link logs that fulfill given parameters. The size of the result set can be retrieved by using the [Get Identity-Link-Log Count](https://docs.camunda.org/manual/7.20/reference/rest/history/identity-links/get-identity-link-query-count/) method.
     * @param type Restricts to identity links that have the given type (candidate/assignee/owner). (optional)
     * @param userId Restricts to identity links that have the given user id. (optional)
     * @param groupId Restricts to identity links that have the given group id. (optional)
     * @param dateBefore Restricts to identity links that have the time before the given time. (optional)
     * @param dateAfter Restricts to identity links that have the time after the given time. (optional)
     * @param taskId Restricts to identity links that have the given task id. (optional)
     * @param processDefinitionId Restricts to identity links that have the given process definition id. (optional)
     * @param processDefinitionKey Restricts to identity links that have the given process definition key. (optional)
     * @param operationType Restricts to identity links that have the given operationType (add/delete). (optional)
     * @param assignerId Restricts to identity links that have the given assigner id. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic identity links that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;HistoricIdentityLinkLogDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricIdentityLinkLogDto>> getHistoricIdentityLinksWithHttpInfo(String type, String userId, String groupId, Date dateBefore, Date dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getHistoricIdentityLinksValidateBeforeCall(type, userId, groupId, dateBefore, dateAfter, taskId, processDefinitionId, processDefinitionKey, operationType, assignerId, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<HistoricIdentityLinkLogDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Identity Link Logs (asynchronously)
     * Queries for historic identity link logs that fulfill given parameters. The size of the result set can be retrieved by using the [Get Identity-Link-Log Count](https://docs.camunda.org/manual/7.20/reference/rest/history/identity-links/get-identity-link-query-count/) method.
     * @param type Restricts to identity links that have the given type (candidate/assignee/owner). (optional)
     * @param userId Restricts to identity links that have the given user id. (optional)
     * @param groupId Restricts to identity links that have the given group id. (optional)
     * @param dateBefore Restricts to identity links that have the time before the given time. (optional)
     * @param dateAfter Restricts to identity links that have the time after the given time. (optional)
     * @param taskId Restricts to identity links that have the given task id. (optional)
     * @param processDefinitionId Restricts to identity links that have the given process definition id. (optional)
     * @param processDefinitionKey Restricts to identity links that have the given process definition key. (optional)
     * @param operationType Restricts to identity links that have the given operationType (add/delete). (optional)
     * @param assignerId Restricts to identity links that have the given assigner id. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic identity links that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricIdentityLinksAsync(String type, String userId, String groupId, Date dateBefore, Date dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<HistoricIdentityLinkLogDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricIdentityLinksValidateBeforeCall(type, userId, groupId, dateBefore, dateAfter, taskId, processDefinitionId, processDefinitionKey, operationType, assignerId, tenantIdIn, withoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricIdentityLinkLogDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricIdentityLinksCount
     * @param type Restricts to identity links that have the given type (candidate/assignee/owner). (optional)
     * @param userId Restricts to identity links that have the given user id. (optional)
     * @param groupId Restricts to identity links that have the given group id. (optional)
     * @param dateBefore Restricts to identity links that have the time before the given time. (optional)
     * @param dateAfter Restricts to identity links that have the time after the given time. (optional)
     * @param taskId Restricts to identity links that have the given task id. (optional)
     * @param processDefinitionId Restricts to identity links that have the given process definition id. (optional)
     * @param processDefinitionKey Restricts to identity links that have the given process definition key. (optional)
     * @param operationType Restricts to identity links that have the given operationType (add/delete). (optional)
     * @param assignerId Restricts to identity links that have the given assigner id. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic identity links that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricIdentityLinksCountCall(String type, String userId, String groupId, Date dateBefore, Date dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/identity-link-log/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userId", userId));
        }

        if (groupId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("groupId", groupId));
        }

        if (dateBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("dateBefore", dateBefore));
        }

        if (dateAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("dateAfter", dateAfter));
        }

        if (taskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskId", taskId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (operationType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("operationType", operationType));
        }

        if (assignerId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("assignerId", assignerId));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricIdentityLinksCountValidateBeforeCall(String type, String userId, String groupId, Date dateBefore, Date dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricIdentityLinksCountCall(type, userId, groupId, dateBefore, dateAfter, taskId, processDefinitionId, processDefinitionKey, operationType, assignerId, tenantIdIn, withoutTenantId, _callback);
        return localVarCall;

    }

    /**
     * Get Identity Link Log Count
     * Queries for the number of historic identity link logs that fulfill the given parameters. Takes the same parameters as the [Get Identity-Link-Logs](https://docs.camunda.org/manual/7.20/reference/rest/history/identity-links/get-identity-link-query/) method.
     * @param type Restricts to identity links that have the given type (candidate/assignee/owner). (optional)
     * @param userId Restricts to identity links that have the given user id. (optional)
     * @param groupId Restricts to identity links that have the given group id. (optional)
     * @param dateBefore Restricts to identity links that have the time before the given time. (optional)
     * @param dateAfter Restricts to identity links that have the time after the given time. (optional)
     * @param taskId Restricts to identity links that have the given task id. (optional)
     * @param processDefinitionId Restricts to identity links that have the given process definition id. (optional)
     * @param processDefinitionKey Restricts to identity links that have the given process definition key. (optional)
     * @param operationType Restricts to identity links that have the given operationType (add/delete). (optional)
     * @param assignerId Restricts to identity links that have the given assigner id. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic identity links that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getHistoricIdentityLinksCount(String type, String userId, String groupId, Date dateBefore, Date dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getHistoricIdentityLinksCountWithHttpInfo(type, userId, groupId, dateBefore, dateAfter, taskId, processDefinitionId, processDefinitionKey, operationType, assignerId, tenantIdIn, withoutTenantId);
        return localVarResp.getData();
    }

    /**
     * Get Identity Link Log Count
     * Queries for the number of historic identity link logs that fulfill the given parameters. Takes the same parameters as the [Get Identity-Link-Logs](https://docs.camunda.org/manual/7.20/reference/rest/history/identity-links/get-identity-link-query/) method.
     * @param type Restricts to identity links that have the given type (candidate/assignee/owner). (optional)
     * @param userId Restricts to identity links that have the given user id. (optional)
     * @param groupId Restricts to identity links that have the given group id. (optional)
     * @param dateBefore Restricts to identity links that have the time before the given time. (optional)
     * @param dateAfter Restricts to identity links that have the time after the given time. (optional)
     * @param taskId Restricts to identity links that have the given task id. (optional)
     * @param processDefinitionId Restricts to identity links that have the given process definition id. (optional)
     * @param processDefinitionKey Restricts to identity links that have the given process definition key. (optional)
     * @param operationType Restricts to identity links that have the given operationType (add/delete). (optional)
     * @param assignerId Restricts to identity links that have the given assigner id. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic identity links that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getHistoricIdentityLinksCountWithHttpInfo(String type, String userId, String groupId, Date dateBefore, Date dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        okhttp3.Call localVarCall = getHistoricIdentityLinksCountValidateBeforeCall(type, userId, groupId, dateBefore, dateAfter, taskId, processDefinitionId, processDefinitionKey, operationType, assignerId, tenantIdIn, withoutTenantId, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Identity Link Log Count (asynchronously)
     * Queries for the number of historic identity link logs that fulfill the given parameters. Takes the same parameters as the [Get Identity-Link-Logs](https://docs.camunda.org/manual/7.20/reference/rest/history/identity-links/get-identity-link-query/) method.
     * @param type Restricts to identity links that have the given type (candidate/assignee/owner). (optional)
     * @param userId Restricts to identity links that have the given user id. (optional)
     * @param groupId Restricts to identity links that have the given group id. (optional)
     * @param dateBefore Restricts to identity links that have the time before the given time. (optional)
     * @param dateAfter Restricts to identity links that have the time after the given time. (optional)
     * @param taskId Restricts to identity links that have the given task id. (optional)
     * @param processDefinitionId Restricts to identity links that have the given process definition id. (optional)
     * @param processDefinitionKey Restricts to identity links that have the given process definition key. (optional)
     * @param operationType Restricts to identity links that have the given operationType (add/delete). (optional)
     * @param assignerId Restricts to identity links that have the given assigner id. (optional)
     * @param tenantIdIn Filter by a comma-separated list of tenant ids. (optional)
     * @param withoutTenantId Only include historic identity links that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricIdentityLinksCountAsync(String type, String userId, String groupId, Date dateBefore, Date dateAfter, String taskId, String processDefinitionId, String processDefinitionKey, String operationType, String assignerId, String tenantIdIn, Boolean withoutTenantId, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricIdentityLinksCountValidateBeforeCall(type, userId, groupId, dateBefore, dateAfter, taskId, processDefinitionId, processDefinitionKey, operationType, assignerId, tenantIdIn, withoutTenantId, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
