/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import java.io.File;
import org.camunda.community.rest.client.dto.VariableInstanceDto;
import org.camunda.community.rest.client.dto.VariableInstanceQueryDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariableInstanceApi {
    private ApiClient localVarApiClient;

    public VariableInstanceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VariableInstanceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getVariableInstance
     * @param id The id of the variable instance. (required)
     * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:**  While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getVariableInstanceCall(String id, Boolean deserializeValue, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/variable-instance/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (deserializeValue != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValue", deserializeValue));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getVariableInstanceValidateBeforeCall(String id, Boolean deserializeValue, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getVariableInstance(Async)");
        }
        

        okhttp3.Call localVarCall = getVariableInstanceCall(id, deserializeValue, _callback);
        return localVarCall;

    }

    /**
     * Get Variable Instance
     * Retrieves a variable by id.
     * @param id The id of the variable instance. (required)
     * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:**  While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @return VariableInstanceDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public VariableInstanceDto getVariableInstance(String id, Boolean deserializeValue) throws ApiException {
        ApiResponse<VariableInstanceDto> localVarResp = getVariableInstanceWithHttpInfo(id, deserializeValue);
        return localVarResp.getData();
    }

    /**
     * Get Variable Instance
     * Retrieves a variable by id.
     * @param id The id of the variable instance. (required)
     * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:**  While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @return ApiResponse&lt;VariableInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<VariableInstanceDto> getVariableInstanceWithHttpInfo(String id, Boolean deserializeValue) throws ApiException {
        okhttp3.Call localVarCall = getVariableInstanceValidateBeforeCall(id, deserializeValue, null);
        Type localVarReturnType = new TypeToken<VariableInstanceDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Variable Instance (asynchronously)
     * Retrieves a variable by id.
     * @param id The id of the variable instance. (required)
     * @param deserializeValue Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:**  While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getVariableInstanceAsync(String id, Boolean deserializeValue, final ApiCallback<VariableInstanceDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getVariableInstanceValidateBeforeCall(id, deserializeValue, _callback);
        Type localVarReturnType = new TypeToken<VariableInstanceDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getVariableInstanceBinary
     * @param id The id of the variable instance. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. For binary variables or files without any MIME type information, a byte stream is returned.                       File variables with MIME type information are returned as the saved type. Additionally, for file                       variables the Content-Disposition header will be set. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Variable with given id exists but does not serialize as binary data. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getVariableInstanceBinaryCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/variable-instance/{id}/data"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/octet-stream", "*/*", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getVariableInstanceBinaryValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getVariableInstanceBinary(Async)");
        }
        

        okhttp3.Call localVarCall = getVariableInstanceBinaryCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Variable Instance (Binary)
     * Retrieves the content of a variable by id. Applicable for byte array and file variables.
     * @param id The id of the variable instance. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. For binary variables or files without any MIME type information, a byte stream is returned.                       File variables with MIME type information are returned as the saved type. Additionally, for file                       variables the Content-Disposition header will be set. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Variable with given id exists but does not serialize as binary data. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getVariableInstanceBinary(String id) throws ApiException {
        ApiResponse<File> localVarResp = getVariableInstanceBinaryWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Variable Instance (Binary)
     * Retrieves the content of a variable by id. Applicable for byte array and file variables.
     * @param id The id of the variable instance. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. For binary variables or files without any MIME type information, a byte stream is returned.                       File variables with MIME type information are returned as the saved type. Additionally, for file                       variables the Content-Disposition header will be set. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Variable with given id exists but does not serialize as binary data. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getVariableInstanceBinaryWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getVariableInstanceBinaryValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Variable Instance (Binary) (asynchronously)
     * Retrieves the content of a variable by id. Applicable for byte array and file variables.
     * @param id The id of the variable instance. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. For binary variables or files without any MIME type information, a byte stream is returned.                       File variables with MIME type information are returned as the saved type. Additionally, for file                       variables the Content-Disposition header will be set. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Variable with given id exists but does not serialize as binary data. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getVariableInstanceBinaryAsync(String id, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getVariableInstanceBinaryValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getVariableInstances
     * @param variableName Filter by variable instance name. (optional)
     * @param variableNameLike Filter by the variable instance name. The parameter can include the wildcard &#x60;%&#x60; to express like-strategy such as: starts with (&#x60;%&#x60;name), ends with (name&#x60;%&#x60;) or contains (&#x60;%&#x60;name&#x60;%&#x60;). (optional)
     * @param processInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param executionIdIn Only include variable instances which belong to one of the passed and comma-separated execution ids. (optional)
     * @param caseInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated case instance ids. (optional)
     * @param caseExecutionIdIn Only include variable instances which belong to one of the passed and comma-separated case execution ids. (optional)
     * @param taskIdIn Only include variable instances which belong to one of the passed and comma-separated task ids. (optional)
     * @param batchIdIn Only include variable instances which belong to one of the passed and comma-separated batch ids. (optional)
     * @param activityInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include variable instances which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param variableValues Only include variable instances that have the certain values. Value filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableScopeIdIn Only include variable instances which belong to one of passed scope ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getVariableInstancesCall(String variableName, String variableNameLike, String processInstanceIdIn, String executionIdIn, String caseInstanceIdIn, String caseExecutionIdIn, String taskIdIn, String batchIdIn, String activityInstanceIdIn, String tenantIdIn, String variableValues, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableScopeIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/variable-instance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (variableName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableName", variableName));
        }

        if (variableNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNameLike", variableNameLike));
        }

        if (processInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        }

        if (executionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionIdIn", executionIdIn));
        }

        if (caseInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceIdIn", caseInstanceIdIn));
        }

        if (caseExecutionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseExecutionIdIn", caseExecutionIdIn));
        }

        if (taskIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskIdIn", taskIdIn));
        }

        if (batchIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("batchIdIn", batchIdIn));
        }

        if (activityInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (variableValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValues", variableValues));
        }

        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }

        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }

        if (variableScopeIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableScopeIdIn", variableScopeIdIn));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (deserializeValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getVariableInstancesValidateBeforeCall(String variableName, String variableNameLike, String processInstanceIdIn, String executionIdIn, String caseInstanceIdIn, String caseExecutionIdIn, String taskIdIn, String batchIdIn, String activityInstanceIdIn, String tenantIdIn, String variableValues, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableScopeIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getVariableInstancesCall(variableName, variableNameLike, processInstanceIdIn, executionIdIn, caseInstanceIdIn, caseExecutionIdIn, taskIdIn, batchIdIn, activityInstanceIdIn, tenantIdIn, variableValues, variableNamesIgnoreCase, variableValuesIgnoreCase, variableScopeIdIn, sortBy, sortOrder, firstResult, maxResults, deserializeValues, _callback);
        return localVarCall;

    }

    /**
     * Get Variable Instances
     * Query for variable instances that fulfill given parameters. Parameters may be the properties of variable instances, such as the name or type. The size of the result set can be retrieved by using the [Get Variable Instance Count](https://docs.camunda.org/manual/7.20/reference/rest/variable-instance/get-query-count/) method.
     * @param variableName Filter by variable instance name. (optional)
     * @param variableNameLike Filter by the variable instance name. The parameter can include the wildcard &#x60;%&#x60; to express like-strategy such as: starts with (&#x60;%&#x60;name), ends with (name&#x60;%&#x60;) or contains (&#x60;%&#x60;name&#x60;%&#x60;). (optional)
     * @param processInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param executionIdIn Only include variable instances which belong to one of the passed and comma-separated execution ids. (optional)
     * @param caseInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated case instance ids. (optional)
     * @param caseExecutionIdIn Only include variable instances which belong to one of the passed and comma-separated case execution ids. (optional)
     * @param taskIdIn Only include variable instances which belong to one of the passed and comma-separated task ids. (optional)
     * @param batchIdIn Only include variable instances which belong to one of the passed and comma-separated batch ids. (optional)
     * @param activityInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include variable instances which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param variableValues Only include variable instances that have the certain values. Value filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableScopeIdIn Only include variable instances which belong to one of passed scope ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @return List&lt;VariableInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<VariableInstanceDto> getVariableInstances(String variableName, String variableNameLike, String processInstanceIdIn, String executionIdIn, String caseInstanceIdIn, String caseExecutionIdIn, String taskIdIn, String batchIdIn, String activityInstanceIdIn, String tenantIdIn, String variableValues, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableScopeIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues) throws ApiException {
        ApiResponse<List<VariableInstanceDto>> localVarResp = getVariableInstancesWithHttpInfo(variableName, variableNameLike, processInstanceIdIn, executionIdIn, caseInstanceIdIn, caseExecutionIdIn, taskIdIn, batchIdIn, activityInstanceIdIn, tenantIdIn, variableValues, variableNamesIgnoreCase, variableValuesIgnoreCase, variableScopeIdIn, sortBy, sortOrder, firstResult, maxResults, deserializeValues);
        return localVarResp.getData();
    }

    /**
     * Get Variable Instances
     * Query for variable instances that fulfill given parameters. Parameters may be the properties of variable instances, such as the name or type. The size of the result set can be retrieved by using the [Get Variable Instance Count](https://docs.camunda.org/manual/7.20/reference/rest/variable-instance/get-query-count/) method.
     * @param variableName Filter by variable instance name. (optional)
     * @param variableNameLike Filter by the variable instance name. The parameter can include the wildcard &#x60;%&#x60; to express like-strategy such as: starts with (&#x60;%&#x60;name), ends with (name&#x60;%&#x60;) or contains (&#x60;%&#x60;name&#x60;%&#x60;). (optional)
     * @param processInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param executionIdIn Only include variable instances which belong to one of the passed and comma-separated execution ids. (optional)
     * @param caseInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated case instance ids. (optional)
     * @param caseExecutionIdIn Only include variable instances which belong to one of the passed and comma-separated case execution ids. (optional)
     * @param taskIdIn Only include variable instances which belong to one of the passed and comma-separated task ids. (optional)
     * @param batchIdIn Only include variable instances which belong to one of the passed and comma-separated batch ids. (optional)
     * @param activityInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include variable instances which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param variableValues Only include variable instances that have the certain values. Value filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableScopeIdIn Only include variable instances which belong to one of passed scope ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @return ApiResponse&lt;List&lt;VariableInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<VariableInstanceDto>> getVariableInstancesWithHttpInfo(String variableName, String variableNameLike, String processInstanceIdIn, String executionIdIn, String caseInstanceIdIn, String caseExecutionIdIn, String taskIdIn, String batchIdIn, String activityInstanceIdIn, String tenantIdIn, String variableValues, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableScopeIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues) throws ApiException {
        okhttp3.Call localVarCall = getVariableInstancesValidateBeforeCall(variableName, variableNameLike, processInstanceIdIn, executionIdIn, caseInstanceIdIn, caseExecutionIdIn, taskIdIn, batchIdIn, activityInstanceIdIn, tenantIdIn, variableValues, variableNamesIgnoreCase, variableValuesIgnoreCase, variableScopeIdIn, sortBy, sortOrder, firstResult, maxResults, deserializeValues, null);
        Type localVarReturnType = new TypeToken<List<VariableInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Variable Instances (asynchronously)
     * Query for variable instances that fulfill given parameters. Parameters may be the properties of variable instances, such as the name or type. The size of the result set can be retrieved by using the [Get Variable Instance Count](https://docs.camunda.org/manual/7.20/reference/rest/variable-instance/get-query-count/) method.
     * @param variableName Filter by variable instance name. (optional)
     * @param variableNameLike Filter by the variable instance name. The parameter can include the wildcard &#x60;%&#x60; to express like-strategy such as: starts with (&#x60;%&#x60;name), ends with (name&#x60;%&#x60;) or contains (&#x60;%&#x60;name&#x60;%&#x60;). (optional)
     * @param processInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param executionIdIn Only include variable instances which belong to one of the passed and comma-separated execution ids. (optional)
     * @param caseInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated case instance ids. (optional)
     * @param caseExecutionIdIn Only include variable instances which belong to one of the passed and comma-separated case execution ids. (optional)
     * @param taskIdIn Only include variable instances which belong to one of the passed and comma-separated task ids. (optional)
     * @param batchIdIn Only include variable instances which belong to one of the passed and comma-separated batch ids. (optional)
     * @param activityInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include variable instances which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param variableValues Only include variable instances that have the certain values. Value filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableScopeIdIn Only include variable instances which belong to one of passed scope ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getVariableInstancesAsync(String variableName, String variableNameLike, String processInstanceIdIn, String executionIdIn, String caseInstanceIdIn, String caseExecutionIdIn, String taskIdIn, String batchIdIn, String activityInstanceIdIn, String tenantIdIn, String variableValues, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableScopeIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues, final ApiCallback<List<VariableInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getVariableInstancesValidateBeforeCall(variableName, variableNameLike, processInstanceIdIn, executionIdIn, caseInstanceIdIn, caseExecutionIdIn, taskIdIn, batchIdIn, activityInstanceIdIn, tenantIdIn, variableValues, variableNamesIgnoreCase, variableValuesIgnoreCase, variableScopeIdIn, sortBy, sortOrder, firstResult, maxResults, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<List<VariableInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getVariableInstancesCount
     * @param variableName Filter by variable instance name. (optional)
     * @param variableNameLike Filter by the variable instance name. The parameter can include the wildcard &#x60;%&#x60; to express like-strategy such as: starts with (&#x60;%&#x60;name), ends with (name&#x60;%&#x60;) or contains (&#x60;%&#x60;name&#x60;%&#x60;). (optional)
     * @param processInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param executionIdIn Only include variable instances which belong to one of the passed and comma-separated execution ids. (optional)
     * @param caseInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated case instance ids. (optional)
     * @param caseExecutionIdIn Only include variable instances which belong to one of the passed and comma-separated case execution ids. (optional)
     * @param taskIdIn Only include variable instances which belong to one of the passed and comma-separated task ids. (optional)
     * @param batchIdIn Only include variable instances which belong to one of the passed and comma-separated batch ids. (optional)
     * @param activityInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include variable instances which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param variableValues Only include variable instances that have the certain values. Value filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableScopeIdIn Only include variable instances which belong to one of passed scope ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getVariableInstancesCountCall(String variableName, String variableNameLike, String processInstanceIdIn, String executionIdIn, String caseInstanceIdIn, String caseExecutionIdIn, String taskIdIn, String batchIdIn, String activityInstanceIdIn, String tenantIdIn, String variableValues, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableScopeIdIn, String sortBy, String sortOrder, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/variable-instance/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (variableName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableName", variableName));
        }

        if (variableNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNameLike", variableNameLike));
        }

        if (processInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        }

        if (executionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionIdIn", executionIdIn));
        }

        if (caseInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceIdIn", caseInstanceIdIn));
        }

        if (caseExecutionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseExecutionIdIn", caseExecutionIdIn));
        }

        if (taskIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskIdIn", taskIdIn));
        }

        if (batchIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("batchIdIn", batchIdIn));
        }

        if (activityInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (variableValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValues", variableValues));
        }

        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }

        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }

        if (variableScopeIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableScopeIdIn", variableScopeIdIn));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getVariableInstancesCountValidateBeforeCall(String variableName, String variableNameLike, String processInstanceIdIn, String executionIdIn, String caseInstanceIdIn, String caseExecutionIdIn, String taskIdIn, String batchIdIn, String activityInstanceIdIn, String tenantIdIn, String variableValues, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableScopeIdIn, String sortBy, String sortOrder, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getVariableInstancesCountCall(variableName, variableNameLike, processInstanceIdIn, executionIdIn, caseInstanceIdIn, caseExecutionIdIn, taskIdIn, batchIdIn, activityInstanceIdIn, tenantIdIn, variableValues, variableNamesIgnoreCase, variableValuesIgnoreCase, variableScopeIdIn, sortBy, sortOrder, _callback);
        return localVarCall;

    }

    /**
     * Get Variable Instance Count
     * Query for the number of variable instances that fulfill given parameters. Takes the same parameters as the [Get Variable Instances](https://docs.camunda.org/manual/7.20/reference/rest/variable-instance/get-query/) method.
     * @param variableName Filter by variable instance name. (optional)
     * @param variableNameLike Filter by the variable instance name. The parameter can include the wildcard &#x60;%&#x60; to express like-strategy such as: starts with (&#x60;%&#x60;name), ends with (name&#x60;%&#x60;) or contains (&#x60;%&#x60;name&#x60;%&#x60;). (optional)
     * @param processInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param executionIdIn Only include variable instances which belong to one of the passed and comma-separated execution ids. (optional)
     * @param caseInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated case instance ids. (optional)
     * @param caseExecutionIdIn Only include variable instances which belong to one of the passed and comma-separated case execution ids. (optional)
     * @param taskIdIn Only include variable instances which belong to one of the passed and comma-separated task ids. (optional)
     * @param batchIdIn Only include variable instances which belong to one of the passed and comma-separated batch ids. (optional)
     * @param activityInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include variable instances which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param variableValues Only include variable instances that have the certain values. Value filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableScopeIdIn Only include variable instances which belong to one of passed scope ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getVariableInstancesCount(String variableName, String variableNameLike, String processInstanceIdIn, String executionIdIn, String caseInstanceIdIn, String caseExecutionIdIn, String taskIdIn, String batchIdIn, String activityInstanceIdIn, String tenantIdIn, String variableValues, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableScopeIdIn, String sortBy, String sortOrder) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getVariableInstancesCountWithHttpInfo(variableName, variableNameLike, processInstanceIdIn, executionIdIn, caseInstanceIdIn, caseExecutionIdIn, taskIdIn, batchIdIn, activityInstanceIdIn, tenantIdIn, variableValues, variableNamesIgnoreCase, variableValuesIgnoreCase, variableScopeIdIn, sortBy, sortOrder);
        return localVarResp.getData();
    }

    /**
     * Get Variable Instance Count
     * Query for the number of variable instances that fulfill given parameters. Takes the same parameters as the [Get Variable Instances](https://docs.camunda.org/manual/7.20/reference/rest/variable-instance/get-query/) method.
     * @param variableName Filter by variable instance name. (optional)
     * @param variableNameLike Filter by the variable instance name. The parameter can include the wildcard &#x60;%&#x60; to express like-strategy such as: starts with (&#x60;%&#x60;name), ends with (name&#x60;%&#x60;) or contains (&#x60;%&#x60;name&#x60;%&#x60;). (optional)
     * @param processInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param executionIdIn Only include variable instances which belong to one of the passed and comma-separated execution ids. (optional)
     * @param caseInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated case instance ids. (optional)
     * @param caseExecutionIdIn Only include variable instances which belong to one of the passed and comma-separated case execution ids. (optional)
     * @param taskIdIn Only include variable instances which belong to one of the passed and comma-separated task ids. (optional)
     * @param batchIdIn Only include variable instances which belong to one of the passed and comma-separated batch ids. (optional)
     * @param activityInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include variable instances which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param variableValues Only include variable instances that have the certain values. Value filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableScopeIdIn Only include variable instances which belong to one of passed scope ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getVariableInstancesCountWithHttpInfo(String variableName, String variableNameLike, String processInstanceIdIn, String executionIdIn, String caseInstanceIdIn, String caseExecutionIdIn, String taskIdIn, String batchIdIn, String activityInstanceIdIn, String tenantIdIn, String variableValues, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableScopeIdIn, String sortBy, String sortOrder) throws ApiException {
        okhttp3.Call localVarCall = getVariableInstancesCountValidateBeforeCall(variableName, variableNameLike, processInstanceIdIn, executionIdIn, caseInstanceIdIn, caseExecutionIdIn, taskIdIn, batchIdIn, activityInstanceIdIn, tenantIdIn, variableValues, variableNamesIgnoreCase, variableValuesIgnoreCase, variableScopeIdIn, sortBy, sortOrder, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Variable Instance Count (asynchronously)
     * Query for the number of variable instances that fulfill given parameters. Takes the same parameters as the [Get Variable Instances](https://docs.camunda.org/manual/7.20/reference/rest/variable-instance/get-query/) method.
     * @param variableName Filter by variable instance name. (optional)
     * @param variableNameLike Filter by the variable instance name. The parameter can include the wildcard &#x60;%&#x60; to express like-strategy such as: starts with (&#x60;%&#x60;name), ends with (name&#x60;%&#x60;) or contains (&#x60;%&#x60;name&#x60;%&#x60;). (optional)
     * @param processInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param executionIdIn Only include variable instances which belong to one of the passed and comma-separated execution ids. (optional)
     * @param caseInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated case instance ids. (optional)
     * @param caseExecutionIdIn Only include variable instances which belong to one of the passed and comma-separated case execution ids. (optional)
     * @param taskIdIn Only include variable instances which belong to one of the passed and comma-separated task ids. (optional)
     * @param batchIdIn Only include variable instances which belong to one of the passed and comma-separated batch ids. (optional)
     * @param activityInstanceIdIn Only include variable instances which belong to one of the passed and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include variable instances which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param variableValues Only include variable instances that have the certain values. Value filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form &#x60;key_operator_value&#x60;. &#x60;key&#x60; is the variable name, &#x60;operator&#x60; is the comparison operator to be used and &#x60;value&#x60; the variable value.  **Note:** Values are always treated as &#x60;String&#x60; objects on server side.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. &#x60;key&#x60; and &#x60;value&#x60; may not contain underscore or comma characters. (optional)
     * @param variableNamesIgnoreCase Match all variable names provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match all variable values provided in &#x60;variableValues&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableScopeIdIn Only include variable instances which belong to one of passed scope ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getVariableInstancesCountAsync(String variableName, String variableNameLike, String processInstanceIdIn, String executionIdIn, String caseInstanceIdIn, String caseExecutionIdIn, String taskIdIn, String batchIdIn, String activityInstanceIdIn, String tenantIdIn, String variableValues, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableScopeIdIn, String sortBy, String sortOrder, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getVariableInstancesCountValidateBeforeCall(variableName, variableNameLike, processInstanceIdIn, executionIdIn, caseInstanceIdIn, caseExecutionIdIn, taskIdIn, batchIdIn, activityInstanceIdIn, tenantIdIn, variableValues, variableNamesIgnoreCase, variableValuesIgnoreCase, variableScopeIdIn, sortBy, sortOrder, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryVariableInstances
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param variableInstanceQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryVariableInstancesCall(Integer firstResult, Integer maxResults, Boolean deserializeValues, VariableInstanceQueryDto variableInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = variableInstanceQueryDto;

        // create path and map variables
        String localVarPath = "/variable-instance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (deserializeValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryVariableInstancesValidateBeforeCall(Integer firstResult, Integer maxResults, Boolean deserializeValues, VariableInstanceQueryDto variableInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryVariableInstancesCall(firstResult, maxResults, deserializeValues, variableInstanceQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Variable Instances (POST)
     * Query for variable instances that fulfill given parameters through a JSON object. This method is slightly more powerful than the [Get Variable Instances](https://docs.camunda.org/manual/7.20/reference/rest/variable- instance/get-query/) method because it allows filtering by multiple variable instances of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param variableInstanceQueryDto  (optional)
     * @return List&lt;VariableInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<VariableInstanceDto> queryVariableInstances(Integer firstResult, Integer maxResults, Boolean deserializeValues, VariableInstanceQueryDto variableInstanceQueryDto) throws ApiException {
        ApiResponse<List<VariableInstanceDto>> localVarResp = queryVariableInstancesWithHttpInfo(firstResult, maxResults, deserializeValues, variableInstanceQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Variable Instances (POST)
     * Query for variable instances that fulfill given parameters through a JSON object. This method is slightly more powerful than the [Get Variable Instances](https://docs.camunda.org/manual/7.20/reference/rest/variable- instance/get-query/) method because it allows filtering by multiple variable instances of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param variableInstanceQueryDto  (optional)
     * @return ApiResponse&lt;List&lt;VariableInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<VariableInstanceDto>> queryVariableInstancesWithHttpInfo(Integer firstResult, Integer maxResults, Boolean deserializeValues, VariableInstanceQueryDto variableInstanceQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryVariableInstancesValidateBeforeCall(firstResult, maxResults, deserializeValues, variableInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<List<VariableInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Variable Instances (POST) (asynchronously)
     * Query for variable instances that fulfill given parameters through a JSON object. This method is slightly more powerful than the [Get Variable Instances](https://docs.camunda.org/manual/7.20/reference/rest/variable- instance/get-query/) method because it allows filtering by multiple variable instances of types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param variableInstanceQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;, or if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryVariableInstancesAsync(Integer firstResult, Integer maxResults, Boolean deserializeValues, VariableInstanceQueryDto variableInstanceQueryDto, final ApiCallback<List<VariableInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryVariableInstancesValidateBeforeCall(firstResult, maxResults, deserializeValues, variableInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<VariableInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryVariableInstancesCount
     * @param variableInstanceQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryVariableInstancesCountCall(VariableInstanceQueryDto variableInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = variableInstanceQueryDto;

        // create path and map variables
        String localVarPath = "/variable-instance/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryVariableInstancesCountValidateBeforeCall(VariableInstanceQueryDto variableInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryVariableInstancesCountCall(variableInstanceQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Variable Instance Count (POST)
     * Query for the number of variable instances that fulfill given parameters. This method takes the same message body as the [Get Variable Instances POST](https://docs.camunda.org/manual/7.20/reference/rest/variable- instance/post-query/) method and therefore it is slightly more powerful than the [Get Variable Instance Count](https://docs.camunda.org/manual/7.20/reference/rest/variable-instance/get-query-count/) method.
     * @param variableInstanceQueryDto  (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto queryVariableInstancesCount(VariableInstanceQueryDto variableInstanceQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = queryVariableInstancesCountWithHttpInfo(variableInstanceQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Variable Instance Count (POST)
     * Query for the number of variable instances that fulfill given parameters. This method takes the same message body as the [Get Variable Instances POST](https://docs.camunda.org/manual/7.20/reference/rest/variable- instance/post-query/) method and therefore it is slightly more powerful than the [Get Variable Instance Count](https://docs.camunda.org/manual/7.20/reference/rest/variable-instance/get-query-count/) method.
     * @param variableInstanceQueryDto  (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> queryVariableInstancesCountWithHttpInfo(VariableInstanceQueryDto variableInstanceQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryVariableInstancesCountValidateBeforeCall(variableInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Variable Instance Count (POST) (asynchronously)
     * Query for the number of variable instances that fulfill given parameters. This method takes the same message body as the [Get Variable Instances POST](https://docs.camunda.org/manual/7.20/reference/rest/variable- instance/post-query/) method and therefore it is slightly more powerful than the [Get Variable Instance Count](https://docs.camunda.org/manual/7.20/reference/rest/variable-instance/get-query-count/) method.
     * @param variableInstanceQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if an invalid operator for variable comparison is used. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryVariableInstancesCountAsync(VariableInstanceQueryDto variableInstanceQueryDto, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryVariableInstancesCountValidateBeforeCall(variableInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
